/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.Conversion;
import com.jd.laf.binding.converter.simple.NumberConverter;
import java.time.Duration;

public class DurationConverter
extends NumberConverter {
    public Duration execute(Conversion conversion) {
        if (conversion == null || conversion.source == null) {
            return null;
        }
        if (conversion.source instanceof Number) {
            return Duration.ofMillis(((Number)conversion.source).longValue());
        }
        if (conversion.source instanceof CharSequence || conversion.source instanceof Character) {
            try {
                return Duration.ofMillis(Long.parseLong(conversion.source.toString().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public Class<?> targetType() {
        return Duration.class;
    }
}

