/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.simple.DateTimeConverter;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class InstantConverter
extends DateTimeConverter<Instant> {
    @Override
    protected Instant convert(TemporalAccessor temporal) {
        if (temporal instanceof Instant) {
            return (Instant)temporal;
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toInstant();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toInstant();
        }
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            long value = temporal.getLong(ChronoField.EPOCH_DAY) * 24L * 3600L * 1000L;
            if (temporal.isSupported(ChronoField.MILLI_OF_DAY)) {
                value += temporal.getLong(ChronoField.MILLI_OF_DAY);
            }
            return Instant.ofEpochMilli(value);
        }
        return Instant.from(temporal);
    }

    public Class<?> targetType() {
        return Instant.class;
    }
}

