/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.simple.DateTimeConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;

public class LocalDateConverter
extends DateTimeConverter<LocalDate> {
    @Override
    protected LocalDate convert(TemporalAccessor temporal) {
        if (temporal instanceof LocalDate) {
            return (LocalDate)temporal;
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).toLocalDate();
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(ZoneId.systemDefault()).toLocalDate();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDate();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDate();
        }
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            return LocalDate.ofEpochDay(temporal.getLong(ChronoField.EPOCH_DAY));
        }
        return LocalDate.from(temporal);
    }

    public Class<?> targetType() {
        return LocalDate.class;
    }
}

