/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.simple.DateTimeConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

public class LocalDateTimeConverter
extends DateTimeConverter<LocalDateTime> {
    @Override
    protected LocalDateTime convert(TemporalAccessor temporal) {
        if (temporal instanceof LocalDateTime) {
            return (LocalDateTime)temporal;
        }
        if (temporal instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporal, ZoneId.systemDefault());
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalDateTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalDateTime();
        }
        if (temporal.isSupported(ChronoField.EPOCH_DAY)) {
            long second = temporal.getLong(ChronoField.EPOCH_DAY) * 24L * 3600L;
            if (temporal.isSupported(ChronoField.SECOND_OF_DAY)) {
                second += temporal.getLong(ChronoField.SECOND_OF_DAY);
            }
            int nano = temporal.isSupported(ChronoField.NANO_OF_SECOND) ? temporal.get(ChronoField.NANO_OF_SECOND) : 0;
            ZoneOffset offset = temporal.query(TemporalQueries.offset());
            if (offset == null) {
                offset = OffsetDateTime.now().getOffset();
            }
            return LocalDateTime.ofEpochSecond(second, nano, offset);
        }
        return LocalDateTime.from(temporal);
    }

    public Class<?> targetType() {
        return LocalDateTime.class;
    }
}

