/*
 * Decompiled with CFR 0.152.
 */
package com.jd.laf.binding.converter.simple;

import com.jd.laf.binding.converter.simple.DateTimeConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;

public class LocalTimeConverter
extends DateTimeConverter<LocalTime> {
    @Override
    protected LocalTime guess(String source) {
        LocalTime result = (LocalTime)super.guess(source);
        return result != null ? result : this.convert(DateTimeFormatter.ISO_TIME.parse(source));
    }

    @Override
    protected LocalTime convert(Number number) {
        return LocalTime.ofNanoOfDay(number.longValue());
    }

    @Override
    protected LocalTime convert(TemporalAccessor temporal) {
        if (temporal instanceof LocalTime) {
            return (LocalTime)temporal;
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).toLocalTime();
        }
        if (temporal instanceof Instant) {
            return ((Instant)temporal).atZone(ZoneId.systemDefault()).toLocalTime();
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).toLocalTime();
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).toLocalTime();
        }
        if (temporal.isSupported(ChronoField.NANO_OF_DAY)) {
            return LocalTime.ofNanoOfDay(temporal.getLong(ChronoField.NANO_OF_DAY));
        }
        LocalTime time = temporal.query(TemporalQueries.localTime());
        return time != null ? time : LocalTime.ofNanoOfDay(0L);
    }

    public Class<?> targetType() {
        return LocalTime.class;
    }
}

