/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.datasource;

import org.joyqueue.datasource.DataSourceBuilder;
import org.joyqueue.datasource.DataSourceConfig;
import org.joyqueue.datasource.HikariXDataSource;
import org.joyqueue.datasource.XDataSource;

public class HikariDataSourceBuilder
implements DataSourceBuilder {
    public XDataSource build(DataSourceConfig config) {
        HikariXDataSource ds = new HikariXDataSource();
        ds.setDriverClassName(config.getDriver());
        ds.setJdbcUrl(config.getUrl());
        ds.setUsername(config.getUser());
        ds.setPassword(config.getPassword());
        ds.setConnectionTimeout(config.getConnectionTimeout());
        ds.setIdleTimeout(config.getIdleTimeout());
        ds.setMaxLifetime(config.getMaxLifetime());
        ds.setMaximumPoolSize(config.getMaxPoolSize());
        ds.setMinimumIdle(config.getMinIdle());
        ds.setConnectionTestQuery(config.getValidationQuery());
        ds.setAutoCommit(config.isAutoCommit());
        ds.setTransactionIsolation(config.getTransactionIsolation());
        ds.setReadOnly(config.isReadOnly());
        ds.setCatalog(config.getCatalog());
        System.setProperty("com.zaxxer.hikari.housekeeping.periodMs", String.valueOf(config.getCleanupInterval()));
        if (config.getConnectionProperties() != null) {
            String[] properties;
            for (String property : properties = config.getConnectionProperties().split(";")) {
                int pos = property.indexOf(61);
                if (pos <= 0 || pos >= property.length() - 1) continue;
                String name = property.substring(0, pos);
                String value = property.substring(pos + 1);
                ds.addDataSourceProperty(name, value);
            }
        }
        return ds;
    }

    public Object type() {
        return "HikariCP";
    }
}

