/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core;

import io.journalkeeper.core.LocalDefaultRpcAccessPoint;
import io.journalkeeper.core.api.AdminClient;
import io.journalkeeper.core.api.ClusterAccessPoint;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.RaftClient;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.client.DefaultAdminClient;
import io.journalkeeper.core.client.DefaultRaftClient;
import io.journalkeeper.core.client.LocalClientRpc;
import io.journalkeeper.core.client.RemoteClientRpc;
import io.journalkeeper.core.entry.DefaultJournalEntryParser;
import io.journalkeeper.core.server.Server;
import io.journalkeeper.rpc.RpcAccessPointFactory;
import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.ClientServerRpcAccessPoint;
import io.journalkeeper.utils.retry.IncreasingRetryPolicy;
import io.journalkeeper.utils.retry.RetryPolicy;
import io.journalkeeper.utils.spi.ServiceSupport;
import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.NamedThreadFactory;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrap
implements ClusterAccessPoint {
    private static final Logger logger = LoggerFactory.getLogger(BootStrap.class);
    private static final int SCHEDULE_EXECUTOR_QUEUE_SIZE = 128;
    private final StateFactory stateFactory;
    private final Properties properties;
    private final RaftServer.Roll roll;
    private final RpcAccessPointFactory rpcAccessPointFactory;
    private final List<URI> servers;
    private final Server server;
    private final JournalEntryParser journalEntryParser;
    private final RetryPolicy remoteRetryPolicy = new IncreasingRetryPolicy(new long[]{50L, 50L, 50L, 50L, 50L, 100L, 100L, 100L, 100L, 100L, 100L, 300L, 300L, 300L, 300L, 300L, 300L, 500L, 500L, 500L, 500L, 500L, 500L, 1000L, 1000L, 1000L, 1000L, 1000L, 5000L, 5000L, 5000L, 5000L, 5000L}, 50L);
    private final boolean isExecutorProvided;
    private ScheduledExecutorService serverScheduledExecutor;
    private ScheduledExecutorService clientScheduledExecutor;
    private ExecutorService serverAsyncExecutor;
    private ExecutorService clientAsyncExecutor;
    private RaftClient client = null;
    private AdminClient adminClient = null;
    private RaftClient localClient = null;
    private AdminClient localAdminClient = null;

    public BootStrap(List<URI> servers, Properties properties) {
        this(null, servers, null, null, null, null, null, null, properties);
    }

    public BootStrap(List<URI> servers, ExecutorService clientAsyncExecutor, ScheduledExecutorService clientScheduledExecutor, Properties properties) {
        this(null, servers, null, null, clientAsyncExecutor, clientScheduledExecutor, null, null, properties);
    }

    public BootStrap(RaftServer.Roll roll, StateFactory stateFactory, Properties properties) {
        this(roll, null, stateFactory, new DefaultJournalEntryParser(), null, null, null, null, properties);
    }

    public BootStrap(RaftServer.Roll roll, StateFactory stateFactory, JournalEntryParser journalEntryParser, Properties properties) {
        this(roll, null, stateFactory, journalEntryParser, null, null, null, null, properties);
    }

    public BootStrap(RaftServer.Roll roll, StateFactory stateFactory, JournalEntryParser journalEntryParser, ExecutorService clientAsyncExecutor, ScheduledExecutorService clientScheduledExecutor, ExecutorService serverAsyncExecutor, ScheduledExecutorService serverScheduledExecutor, Properties properties) {
        this(roll, null, stateFactory, journalEntryParser, clientAsyncExecutor, clientScheduledExecutor, serverAsyncExecutor, serverScheduledExecutor, properties);
    }

    private BootStrap(RaftServer.Roll roll, List<URI> servers, StateFactory stateFactory, JournalEntryParser journalEntryParser, ExecutorService clientAsyncExecutor, ScheduledExecutorService clientScheduledExecutor, ExecutorService serverAsyncExecutor, ScheduledExecutorService serverScheduledExecutor, Properties properties) {
        this.stateFactory = stateFactory;
        this.properties = properties;
        this.roll = roll;
        this.rpcAccessPointFactory = (RpcAccessPointFactory)ServiceSupport.load(RpcAccessPointFactory.class);
        this.isExecutorProvided = clientAsyncExecutor != null || clientScheduledExecutor != null || serverAsyncExecutor != null || serverScheduledExecutor != null;
        this.journalEntryParser = journalEntryParser;
        this.clientAsyncExecutor = clientAsyncExecutor;
        this.serverAsyncExecutor = serverAsyncExecutor;
        this.clientScheduledExecutor = clientScheduledExecutor;
        this.serverScheduledExecutor = serverScheduledExecutor;
        this.server = this.createServer();
        this.servers = servers;
    }

    private Server createServer() {
        if (null == this.serverScheduledExecutor && !this.isExecutorProvided) {
            this.serverScheduledExecutor = Executors.newScheduledThreadPool(128, (ThreadFactory)new NamedThreadFactory("JournalKeeper-Server-Scheduled-Executor"));
        }
        if (null == this.serverAsyncExecutor && !this.isExecutorProvided) {
            this.serverAsyncExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("JournalKeeper-Server-Async-Executor"));
        }
        if (null != this.roll) {
            return new Server(this.roll, this.stateFactory, this.journalEntryParser, this.serverScheduledExecutor, this.serverAsyncExecutor, this.properties);
        }
        return null;
    }

    public RaftClient getClient() {
        if (null == this.client) {
            RemoteClientRpc clientRpc = this.createRemoteClientRpc();
            this.client = new DefaultRaftClient(clientRpc, this.properties);
        }
        return this.client;
    }

    public RaftClient getLocalClient() {
        if (null == this.localClient) {
            LocalClientRpc clientRpc = this.createLocalClientRpc();
            this.localClient = new DefaultRaftClient(clientRpc, this.properties);
        }
        return this.localClient;
    }

    private LocalClientRpc createLocalClientRpc() {
        if (null == this.clientAsyncExecutor && !this.isExecutorProvided) {
            this.clientAsyncExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("JournalKeeper-Client-Async-Executor"));
        }
        if (null == this.clientScheduledExecutor && !this.isExecutorProvided) {
            this.clientScheduledExecutor = Executors.newScheduledThreadPool(128, (ThreadFactory)new NamedThreadFactory("JournalKeeper-Client-Scheduled-Executor"));
        }
        if (this.server != null) {
            return new LocalClientRpc((ClientServerRpc)this.server, this.remoteRetryPolicy, this.clientScheduledExecutor);
        }
        throw new IllegalStateException("No local server!");
    }

    private RemoteClientRpc createRemoteClientRpc() {
        RemoteClientRpc clientRpc;
        if (null == this.clientAsyncExecutor && !this.isExecutorProvided) {
            this.clientAsyncExecutor = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("JournalKeeper-Client-Async-Executor"));
        }
        if (null == this.clientScheduledExecutor && !this.isExecutorProvided) {
            this.clientScheduledExecutor = Executors.newScheduledThreadPool(128, (ThreadFactory)new NamedThreadFactory("JournalKeeper-Client-Scheduled-Executor"));
        }
        ClientServerRpcAccessPoint clientServerRpcAccessPoint = this.rpcAccessPointFactory.createClientServerRpcAccessPoint(this.properties);
        if (this.server == null) {
            clientRpc = new RemoteClientRpc(this.getServersForClient(), clientServerRpcAccessPoint, this.remoteRetryPolicy, this.clientAsyncExecutor, this.clientScheduledExecutor);
        } else {
            clientServerRpcAccessPoint = new LocalDefaultRpcAccessPoint(this.server, clientServerRpcAccessPoint);
            clientRpc = new RemoteClientRpc(this.getServersForClient(), clientServerRpcAccessPoint, this.remoteRetryPolicy, this.clientAsyncExecutor, this.clientScheduledExecutor);
            clientRpc.setPreferredServer(this.server.serverUri());
        }
        return clientRpc;
    }

    public void shutdown() {
        if (null != this.client) {
            this.client.stop();
        }
        if (null != this.adminClient) {
            this.adminClient.stop();
        }
        if (null != this.server) {
            StateServer.ServerState state = this.server.serverState();
            if (state == StateServer.ServerState.RUNNING) {
                this.server.stop();
            } else {
                logger.warn("Server {} state is {}, will not stop!", (Object)this.server.serverUri(), (Object)state);
            }
        }
        if (!this.isExecutorProvided) {
            this.shutdownExecutorService(this.serverScheduledExecutor);
            this.shutdownExecutorService(this.serverAsyncExecutor);
            this.shutdownExecutorService(this.clientScheduledExecutor);
            this.shutdownExecutorService(this.clientAsyncExecutor);
        }
    }

    public RaftServer getServer() {
        return this.server;
    }

    public AdminClient getAdminClient() {
        if (null == this.adminClient) {
            RemoteClientRpc clientRpc = this.createRemoteClientRpc();
            this.adminClient = new DefaultAdminClient(clientRpc, this.properties);
        }
        return this.adminClient;
    }

    public AdminClient getLocalAdminClient() {
        if (null == this.localAdminClient) {
            LocalClientRpc clientRpc = this.createLocalClientRpc();
            this.localAdminClient = new DefaultAdminClient(clientRpc, this.properties);
        }
        return this.localAdminClient;
    }

    private List<URI> getServersForClient() {
        if (null == this.server) {
            return this.servers;
        }
        try {
            return this.server.getServers().get().getClusterConfiguration().getVoters();
        }
        catch (Throwable e) {
            throw new RpcException(e);
        }
    }

    private void shutdownExecutorService(ExecutorService executor) {
        if (null != executor) {
            executor.shutdown();
        }
    }

    public JournalEntryParser getJournalEntryParser() {
        return this.journalEntryParser;
    }
}

