/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.client;

import io.journalkeeper.core.api.ClusterReadyAware;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.ServerConfigAware;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.client.ClientRpc;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.RpcException;
import io.journalkeeper.rpc.StatusCode;
import io.journalkeeper.rpc.client.CheckLeadershipResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.event.Watchable;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements ClusterReadyAware,
ServerConfigAware,
Watchable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClient.class);
    final ClientRpc clientRpc;

    AbstractClient(ClientRpc clientRpc) {
        this.clientRpc = clientRpc;
    }

    protected CompletableFuture<List<byte[]>> update(List<UpdateRequest> entries, boolean includeHeader, ResponseConfig responseConfig) {
        return ((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(rpc -> rpc.updateClusterState(new UpdateClusterStateRequest(entries, includeHeader, responseConfig))).thenApply(this::checkResponse)).thenApply(UpdateClusterStateResponse::getResults);
    }

    <R extends BaseResponse> R checkResponse(R response) {
        if (response.getStatusCode() != StatusCode.SUCCESS) {
            throw new RpcException(response);
        }
        return response;
    }

    public void waitForClusterReady(long maxWaitMs) throws TimeoutException {
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < maxWaitMs || maxWaitMs <= 0L) {
            try {
                CheckLeadershipResponse response;
                CheckLeadershipResponse checkLeadershipResponse = response = maxWaitMs > 0L ? (CheckLeadershipResponse)this.clientRpc.invokeClientLeaderRpc(ClientServerRpc::checkLeadership).get(maxWaitMs, TimeUnit.MILLISECONDS) : (CheckLeadershipResponse)this.clientRpc.invokeClientLeaderRpc(ClientServerRpc::checkLeadership).get();
                if (response.success()) {
                    return;
                }
            }
            catch (Exception e) {
                logger.info("Query servers failed. Error: {}", (Object)e.getMessage());
            }
            try {
                Thread.sleep(ThreadLocalRandom.current().nextLong(100L));
            }
            catch (InterruptedException e) {
                throw new CompletionException(e);
            }
        }
        throw new TimeoutException();
    }

    public void updateServers(List<URI> servers) {
        this.clientRpc.updateServers(servers);
    }

    public void watch(EventWatcher eventWatcher) {
        this.clientRpc.watch(eventWatcher);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.clientRpc.unWatch(eventWatcher);
    }

    public void stop() {
        this.clientRpc.stop();
    }
}

