/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.client;

import io.journalkeeper.core.api.AdminClient;
import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.ServerStatus;
import io.journalkeeper.core.api.SnapshotsEntry;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.client.AbstractClient;
import io.journalkeeper.core.client.ClientRpc;
import io.journalkeeper.core.entry.internal.CreateSnapshotEntry;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.RecoverSnapshotEntry;
import io.journalkeeper.core.entry.internal.ReservedPartition;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntry;
import io.journalkeeper.core.entry.internal.SetPreferredLeaderEntry;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.ConvertRollRequest;
import io.journalkeeper.rpc.client.GetServerStatusResponse;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.rpc.client.GetSnapshotsResponse;
import io.journalkeeper.rpc.client.UpdateVotersRequest;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class DefaultAdminClient
extends AbstractClient
implements AdminClient {
    public DefaultAdminClient(ClientRpc clientRpc, Properties properties) {
        super(clientRpc);
    }

    public CompletableFuture<ClusterConfiguration> getClusterConfiguration() {
        return this.clientRpc.invokeClientLeaderRpc(ClientServerRpc::getServers).thenApply(GetServersResponse::getClusterConfiguration);
    }

    public CompletableFuture<ClusterConfiguration> getClusterConfiguration(URI uri) {
        return this.clientRpc.invokeClientServerRpc(uri, ClientServerRpc::getServers).thenApply(GetServersResponse::getClusterConfiguration);
    }

    public CompletableFuture<Boolean> updateVoters(List<URI> oldConfig, List<URI> newConfig) {
        return this.clientRpc.invokeClientLeaderRpc(leaderRpc -> leaderRpc.updateVoters(new UpdateVotersRequest(oldConfig, newConfig))).thenApply(BaseResponse::success);
    }

    public CompletableFuture<Void> convertRoll(URI uri, RaftServer.Roll roll) {
        return this.clientRpc.invokeClientServerRpc(uri, rpc -> rpc.convertRoll(new ConvertRollRequest(roll))).thenApply(r -> null);
    }

    public CompletableFuture<Void> scalePartitions(Set<Integer> partitions) {
        ReservedPartition.validatePartitions(partitions);
        return this.update(InternalEntriesSerializeSupport.serialize(new ScalePartitionsEntry(partitions)));
    }

    private CompletableFuture<Void> update(byte[] entry) {
        return this.update(Collections.singletonList(new UpdateRequest(entry, Short.MAX_VALUE, 1)), false, ResponseConfig.REPLICATION).thenApply(v -> null);
    }

    public CompletableFuture<ServerStatus> getServerStatus(URI uri) {
        return this.clientRpc.invokeClientServerRpc(uri, ClientServerRpc::getServerStatus).thenApply(GetServerStatusResponse::getServerStatus);
    }

    public CompletableFuture<Void> setPreferredLeader(URI preferredLeader) {
        return this.update(InternalEntriesSerializeSupport.serialize(new SetPreferredLeaderEntry(preferredLeader)));
    }

    public CompletableFuture<Void> takeSnapshot() {
        return this.update(InternalEntriesSerializeSupport.serialize(new CreateSnapshotEntry()));
    }

    public CompletableFuture<Void> recoverSnapshot(long index) {
        return this.update(InternalEntriesSerializeSupport.serialize(new RecoverSnapshotEntry(index)));
    }

    public CompletableFuture<SnapshotsEntry> getSnapshots() {
        return this.clientRpc.invokeClientLeaderRpc(ClientServerRpc::getSnapshots).thenApply(GetSnapshotsResponse::getSnapshots);
    }
}

