/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.client;

import io.journalkeeper.core.api.QueryConsistency;
import io.journalkeeper.core.api.RaftClient;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.transaction.JournalKeeperTransactionContext;
import io.journalkeeper.core.api.transaction.TransactionContext;
import io.journalkeeper.core.api.transaction.TransactionId;
import io.journalkeeper.core.api.transaction.UUIDTransactionId;
import io.journalkeeper.core.client.AbstractClient;
import io.journalkeeper.core.client.ClientRpc;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.CompleteTransactionRequest;
import io.journalkeeper.rpc.client.CompleteTransactionResponse;
import io.journalkeeper.rpc.client.CreateTransactionRequest;
import io.journalkeeper.rpc.client.CreateTransactionResponse;
import io.journalkeeper.rpc.client.GetOpeningTransactionsResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRaftClient
extends AbstractClient
implements RaftClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRaftClient.class);
    private final AtomicLong lastApplied = new AtomicLong(-1L);

    public DefaultRaftClient(ClientRpc clientRpc, Properties properties) {
        super(clientRpc);
    }

    @Override
    public CompletableFuture<List<byte[]>> update(List<UpdateRequest> entries, boolean includeHeader, ResponseConfig responseConfig) {
        return ((CompletableFuture)((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(rpc -> rpc.updateClusterState(new UpdateClusterStateRequest(entries, includeHeader, responseConfig))).thenApply(this::checkResponse)).thenApply(response -> {
            this.maybeUpdateLastApplied(response.getLastApplied());
            return response;
        })).thenApply(UpdateClusterStateResponse::getResults);
    }

    public CompletableFuture<byte[]> query(byte[] query, QueryConsistency consistency) {
        if (consistency == QueryConsistency.STRICT) {
            return this.query(query);
        }
        return this.queryAllServers(query, consistency);
    }

    private CompletableFuture<byte[]> queryAllServers(byte[] query, QueryConsistency consistency) {
        return ((CompletableFuture)((CompletableFuture)this.clientRpc.invokeClientServerRpc(rpc -> rpc.queryServerState(new QueryStateRequest(query, consistency == QueryConsistency.NONE ? -1L : this.lastApplied.get()))).thenApply(x$0 -> (QueryStateResponse)super.checkResponse(x$0))).thenApply(response -> {
            this.maybeUpdateLastApplied(response.getLastApplied());
            return response;
        })).thenApply(QueryStateResponse::getResult);
    }

    public CompletableFuture<byte[]> query(byte[] query) {
        return ((CompletableFuture)((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(leaderRpc -> leaderRpc.queryClusterState(new QueryStateRequest(query))).thenApply(x$0 -> (QueryStateResponse)super.checkResponse(x$0))).thenApply(response -> {
            this.maybeUpdateLastApplied(response.getLastApplied());
            return response;
        })).thenApply(QueryStateResponse::getResult);
    }

    public CompletableFuture<TransactionContext> createTransaction(Map<String, String> context) {
        return ((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(rpc -> rpc.createTransaction(new CreateTransactionRequest(context))).thenApply(x$0 -> (CreateTransactionResponse)super.checkResponse(x$0))).thenApply(response -> new JournalKeeperTransactionContext(response.getTransactionId(), context, response.getTimestamp()));
    }

    public CompletableFuture<Void> completeTransaction(TransactionId transactionId, boolean commitOrAbort) {
        return ((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(leaderRpc -> leaderRpc.completeTransaction(new CompleteTransactionRequest(((UUIDTransactionId)transactionId).getUuid(), commitOrAbort))).thenApply(x$0 -> (CompleteTransactionResponse)super.checkResponse(x$0))).thenApply(response -> null);
    }

    public CompletableFuture<Collection<TransactionContext>> getOpeningTransactions() {
        return ((CompletableFuture)((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(ClientServerRpc::getOpeningTransactions).thenApply(x$0 -> (GetOpeningTransactionsResponse)super.checkResponse(x$0))).thenApply(GetOpeningTransactionsResponse::getTransactionContexts)).thenApply(contexts -> contexts.stream().map(c -> c).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> update(TransactionId transactionId, List<UpdateRequest> entries, boolean includeHeader) {
        return ((CompletableFuture)this.clientRpc.invokeClientLeaderRpc(rpc -> rpc.updateClusterState(new UpdateClusterStateRequest(((UUIDTransactionId)transactionId).getUuid(), entries, includeHeader))).thenApply(this::checkResponse)).thenApply(response -> {
            this.maybeUpdateLastApplied(response.getLastApplied());
            return null;
        });
    }

    private void maybeUpdateLastApplied(long index) {
        long finalLastApplied;
        while (index > (finalLastApplied = this.lastApplied.get())) {
            if (!this.lastApplied.compareAndSet(finalLastApplied, index)) continue;
            return;
        }
    }
}

