/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.client;

import io.journalkeeper.core.client.ClientRpc;
import io.journalkeeper.exceptions.ServerBusyException;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.retry.CheckRetry;
import io.journalkeeper.utils.retry.CompletableRetry;
import io.journalkeeper.utils.retry.DestinationSelector;
import io.journalkeeper.utils.retry.RetryPolicy;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClientRpc
implements ClientRpc {
    private static final Logger logger = LoggerFactory.getLogger(LocalClientRpc.class);
    private final ClientServerRpc localServer;
    private final CompletableRetry<URI> completableRetry;
    private final CheckRetry<BaseResponse> checkRetry = new LocalClientCheckRetry();
    private final ScheduledExecutorService scheduledExecutor;
    private final URI localUri;

    public LocalClientRpc(ClientServerRpc localServer, RetryPolicy retryPolicy, ScheduledExecutorService scheduledExecutor) {
        this.localServer = localServer;
        this.scheduledExecutor = scheduledExecutor;
        this.localUri = localServer.serverUri();
        DestinationSelector uriSelector = uriSet -> this.localUri;
        this.completableRetry = new CompletableRetry(retryPolicy, uriSelector);
    }

    @Override
    public <O extends BaseResponse> CompletableFuture<O> invokeClientServerRpc(CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        return this.completableRetry.retry(uri -> invoke.invoke((Object)this.localServer), this.checkRetry, (Object)this.localUri, null, this.scheduledExecutor);
    }

    @Override
    public <O extends BaseResponse> CompletableFuture<O> invokeClientServerRpc(URI uri, CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        if (this.localServer.serverUri().equals(uri)) {
            return this.invokeClientServerRpc(invoke);
        }
        throw new IllegalArgumentException(String.format("Request uri %s is NOT accessible!You should only request to local server %s in local client mode.", uri.toString(), this.localServer.serverUri().toString()));
    }

    @Override
    public <O extends BaseResponse> CompletableFuture<O> invokeClientLeaderRpc(CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        return this.invokeClientServerRpc(invoke);
    }

    @Override
    public URI getPreferredServer() {
        return this.localServer.serverUri();
    }

    @Override
    public void setPreferredServer(URI preferredServer) {
    }

    @Override
    public void stop() {
    }

    public void updateServers(List<URI> servers) {
    }

    public void watch(EventWatcher eventWatcher) {
        this.localServer.watch(eventWatcher);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.localServer.unWatch(eventWatcher);
    }

    private static class LocalClientCheckRetry
    implements CheckRetry<BaseResponse> {
        private LocalClientCheckRetry() {
        }

        public boolean checkException(Throwable exception) {
            try {
                logger.debug("Rpc exception: {}", (Object)exception.getMessage());
                throw exception;
            }
            catch (ServerBusyException | TimeoutException ignored) {
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public boolean checkResult(BaseResponse response) {
            switch (response.getStatusCode()) {
                case TIMEOUT: 
                case SERVER_BUSY: {
                    logger.info("{} failed, cause: {}, Retry...", (Object)response.getClass().getName(), (Object)response.errorString());
                    return true;
                }
            }
            return false;
        }
    }
}

