/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.client;

import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.client.ClientRpc;
import io.journalkeeper.exceptions.NoLeaderException;
import io.journalkeeper.exceptions.NotLeaderException;
import io.journalkeeper.exceptions.RequestTimeoutException;
import io.journalkeeper.exceptions.ServerBusyException;
import io.journalkeeper.exceptions.ServerNotFoundException;
import io.journalkeeper.exceptions.TransportException;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.LeaderResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.ClientServerRpcAccessPoint;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.retry.CheckRetry;
import io.journalkeeper.utils.retry.CompletableRetry;
import io.journalkeeper.utils.retry.RandomDestinationSelector;
import io.journalkeeper.utils.retry.RetryPolicy;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteClientRpc
implements ClientRpc {
    private static final Logger logger = LoggerFactory.getLogger(RemoteClientRpc.class);
    private final ClientServerRpcAccessPoint clientServerRpcAccessPoint;
    private final CompletableRetry<URI> completableRetry;
    private final RandomDestinationSelector<URI> uriSelector;
    private final ClientCheckRetry clientCheckRetry = new ClientCheckRetry();
    private final Executor executor;
    private final ScheduledExecutorService scheduledExecutor;
    private URI leaderUri = null;
    private URI preferredServer = null;

    public RemoteClientRpc(List<URI> servers, ClientServerRpcAccessPoint clientServerRpcAccessPoint, RetryPolicy retryPolicy, Executor executor, ScheduledExecutorService scheduledExecutor) {
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        if (servers == null || servers.isEmpty()) {
            throw new IllegalArgumentException("Argument servers can not be empty!");
        }
        this.clientServerRpcAccessPoint = clientServerRpcAccessPoint;
        this.uriSelector = new PreferredServerRandomUriSelector(servers);
        this.completableRetry = new CompletableRetry(retryPolicy, this.uriSelector);
    }

    @Override
    public final <O extends BaseResponse> CompletableFuture<O> invokeClientServerRpc(CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        return this.completableRetry.retry(uri -> invoke.invoke((Object)this.clientServerRpcAccessPoint.getClintServerRpc(uri)), (CheckRetry)this.clientCheckRetry, this.executor, this.scheduledExecutor);
    }

    @Override
    public <O extends BaseResponse> CompletableFuture<O> invokeClientServerRpc(URI uri, CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        return this.completableRetry.retry(uri1 -> invoke.invoke((Object)this.clientServerRpcAccessPoint.getClintServerRpc(uri1)), (CheckRetry)this.clientCheckRetry, (Object)uri, this.executor, this.scheduledExecutor);
    }

    @Override
    public final <O extends BaseResponse> CompletableFuture<O> invokeClientLeaderRpc(CompletableRetry.RpcInvoke<O, ClientServerRpc> invoke) {
        return this.invokeClientServerRpc(rpc -> this.unSetLeaderUriWhenLeaderRpcFailed((CompletableFuture)this.getCachedLeaderRpc((ClientServerRpc)rpc).thenCompose(arg_0 -> ((CompletableRetry.RpcInvoke)invoke).invoke(arg_0))));
    }

    private <O extends BaseResponse> CompletableFuture<O> unSetLeaderUriWhenLeaderRpcFailed(CompletableFuture<O> future) {
        return ((CompletableFuture)future.exceptionally(e -> {
            this.leaderUri = null;
            throw new CompletionException((Throwable)e);
        })).thenApply(response -> {
            if (!response.success()) {
                this.leaderUri = null;
            }
            return response;
        });
    }

    private CompletableFuture<ClientServerRpc> getCachedLeaderRpc(ClientServerRpc clientServerRpc) {
        CompletableFuture<URI> leaderUriFuture = new CompletableFuture<URI>();
        if (this.leaderUri == null) {
            ClusterConfiguration clusterConfiguration;
            GetServersResponse getServersResponse = null;
            try {
                getServersResponse = (GetServersResponse)clientServerRpc.getServers().get();
            }
            catch (Throwable e) {
                Throwable ex = e instanceof ExecutionException ? e.getCause() : e;
                leaderUriFuture = new CompletableFuture();
                leaderUriFuture.completeExceptionally(ex);
            }
            if (null != getServersResponse && getServersResponse.success() && null != (clusterConfiguration = getServersResponse.getClusterConfiguration())) {
                this.leaderUri = clusterConfiguration.getLeader();
            }
        }
        if (this.leaderUri != null) {
            leaderUriFuture.complete(this.leaderUri);
        } else if (!leaderUriFuture.isDone()) {
            leaderUriFuture.completeExceptionally(new NoLeaderException());
        }
        return leaderUriFuture.thenApply(arg_0 -> ((ClientServerRpcAccessPoint)this.clientServerRpcAccessPoint).getClintServerRpc(arg_0));
    }

    @Override
    public void stop() {
        this.clientServerRpcAccessPoint.stop();
    }

    @Override
    public URI getPreferredServer() {
        return this.preferredServer;
    }

    @Override
    public void setPreferredServer(URI preferredServer) {
        this.preferredServer = preferredServer;
    }

    public void updateServers(List<URI> servers) {
        this.uriSelector.setAllDestinations(servers);
    }

    public void watch(EventWatcher eventWatcher) {
        this.completableRetry.retry(uri -> {
            this.clientServerRpcAccessPoint.getClintServerRpc(uri).watch(eventWatcher);
            return CompletableFuture.completedFuture(null);
        }, (CheckRetry)this.clientCheckRetry, this.executor, this.scheduledExecutor);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.completableRetry.retry(uri -> {
            this.clientServerRpcAccessPoint.getClintServerRpc(uri).unWatch(eventWatcher);
            return CompletableFuture.completedFuture(null);
        }, (CheckRetry)this.clientCheckRetry, this.executor, this.scheduledExecutor);
    }

    private class PreferredServerRandomUriSelector
    extends RandomDestinationSelector<URI> {
        PreferredServerRandomUriSelector(Collection<URI> allDestinations) {
            super(allDestinations);
        }

        public URI select(Set<URI> usedDestinations) {
            if ((null == usedDestinations || usedDestinations.isEmpty()) && null != RemoteClientRpc.this.preferredServer) {
                return RemoteClientRpc.this.preferredServer;
            }
            return (URI)super.select(usedDestinations);
        }
    }

    private class ClientCheckRetry
    implements CheckRetry<BaseResponse> {
        private ClientCheckRetry() {
        }

        public boolean checkException(Throwable exception) {
            try {
                logger.debug("Rpc exception: {}-{}", (Object)exception.getClass().getCanonicalName(), (Object)exception.getMessage());
                throw exception;
            }
            catch (RequestTimeoutException | ServerBusyException | ServerNotFoundException | TransportException ne) {
                return true;
            }
            catch (NoLeaderException ne) {
                RemoteClientRpc.this.leaderUri = null;
                return true;
            }
            catch (NotLeaderException ne) {
                RemoteClientRpc.this.leaderUri = ne.getLeader();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public boolean checkResult(BaseResponse response) {
            switch (response.getStatusCode()) {
                case NOT_LEADER: {
                    RemoteClientRpc.this.leaderUri = ((LeaderResponse)response).getLeader();
                    logger.info("{} failed, cause: {}, Retry...", (Object)response.getClass().getName(), (Object)response.errorString());
                    return true;
                }
                case TIMEOUT: 
                case SERVER_BUSY: 
                case RETRY_LATER: 
                case TRANSPORT_FAILED: 
                case EXCEPTION: {
                    logger.info("{} failed, cause: {}, Retry...", (Object)response.getClass().getName(), (Object)response.errorString());
                    return true;
                }
                case SUCCESS: {
                    return false;
                }
            }
            logger.warn("{} failed, cause: {}!", (Object)response.getClass().getName(), (Object)response.errorString());
            return false;
        }
    }
}

