/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry;

import io.journalkeeper.core.api.BytesFragment;
import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.entry.JournalEntryParseSupport;
import io.journalkeeper.core.journal.ParseJournalException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class DefaultJournalEntry
implements JournalEntry {
    public static final short MAGIC_CODE = ByteBuffer.wrap(new byte[]{-12, 60}).getShort();
    private final byte[] serializedBytes;
    private final ByteBuffer serializedBuffer;
    private int offset = 0;

    DefaultJournalEntry(byte[] serializedBytes, boolean checkMagic, boolean checkLength) {
        this.serializedBytes = serializedBytes;
        this.serializedBuffer = ByteBuffer.wrap(serializedBytes);
        if (checkMagic) {
            this.checkMagic();
        }
        if (checkLength) {
            this.checkLength(serializedBytes);
        }
    }

    private void checkLength(byte[] serializedBytes) {
        if (serializedBytes.length != this.getLength()) {
            throw new ParseJournalException(String.format("Declared length %d not equals actual length %d\uff01", this.getLength(), serializedBytes.length));
        }
    }

    private ByteBuffer serializedBuffer() {
        return this.serializedBuffer;
    }

    private void checkMagic() {
        short magic = JournalEntryParseSupport.getShort((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.MAGIC);
        if (this.magicCode() != magic) {
            throw new ParseJournalException("Check magic failed\uff01");
        }
    }

    public int getBatchSize() {
        return JournalEntryParseSupport.getShort((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.BATCH_SIZE);
    }

    public void setBatchSize(int batchSize) {
        JournalEntryParseSupport.setShort((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.BATCH_SIZE, (short)((short)batchSize));
    }

    public int getPartition() {
        return JournalEntryParseSupport.getShort((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.PARTITION);
    }

    public void setPartition(int partition) {
        JournalEntryParseSupport.setShort((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.PARTITION, (short)((short)partition));
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getTerm() {
        return JournalEntryParseSupport.getInt((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.TERM);
    }

    public void setTerm(int term) {
        JournalEntryParseSupport.setInt((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.TERM, (int)term);
    }

    public BytesFragment getPayload() {
        return new BytesFragment(this.serializedBytes, JournalEntryParseSupport.getHeaderLength(), this.serializedBytes.length - JournalEntryParseSupport.getHeaderLength());
    }

    public final byte[] getSerializedBytes() {
        return this.serializedBytes;
    }

    public int getLength() {
        return JournalEntryParseSupport.getInt((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.LENGTH);
    }

    private void setLength(int length) {
        JournalEntryParseSupport.setInt((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.LENGTH, (int)length);
    }

    public long getTimestamp() {
        return JournalEntryParseSupport.getLong((ByteBuffer)this.serializedBuffer(), (int)JournalEntryParseSupport.TIMESTAMP);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJournalEntry that = (DefaultJournalEntry)o;
        return Arrays.equals(this.serializedBytes, that.serializedBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.serializedBytes);
    }

    private short magicCode() {
        return MAGIC_CODE;
    }
}

