/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry;

import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.entry.DefaultJournalEntry;
import io.journalkeeper.core.entry.JournalEntryParseSupport;
import java.nio.ByteBuffer;

public class DefaultJournalEntryParser
implements JournalEntryParser {
    public int headerLength() {
        return JournalEntryParseSupport.getHeaderLength();
    }

    public JournalEntry parseHeader(byte[] headerBytes) {
        return new DefaultJournalEntry(headerBytes, true, false);
    }

    public JournalEntry parse(byte[] bytes) {
        return new DefaultJournalEntry(bytes, true, true);
    }

    public JournalEntry createJournalEntry(byte[] payload) {
        int headerLength = this.headerLength();
        byte[] rawEntry = new byte[headerLength + payload.length];
        ByteBuffer buffer = ByteBuffer.wrap(rawEntry);
        JournalEntryParseSupport.setInt((ByteBuffer)buffer, (int)JournalEntryParseSupport.LENGTH, (int)rawEntry.length);
        JournalEntryParseSupport.setShort((ByteBuffer)buffer, (int)JournalEntryParseSupport.MAGIC, (short)DefaultJournalEntry.MAGIC_CODE);
        JournalEntryParseSupport.setLong((ByteBuffer)buffer, (int)JournalEntryParseSupport.TIMESTAMP, (long)System.currentTimeMillis());
        for (int i = 0; i < payload.length; ++i) {
            rawEntry[headerLength + i] = payload[i];
        }
        return new DefaultJournalEntry(rawEntry, false, false);
    }
}

