/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry;

import io.journalkeeper.core.journal.ParseJournalException;
import io.journalkeeper.utils.parser.EntryParser;
import java.util.LinkedList;
import java.util.List;

public class JournalEntryParseSupport
extends EntryParser {
    public static final int FIXED_LENGTH_8 = 8;
    private static final int VARIABLE_LENGTH = -1;
    private static final int FIXED_LENGTH_1 = 1;
    private static final int FIXED_LENGTH_2 = 2;
    private static final int FIXED_LENGTH_4 = 4;
    private static final List<Attribute> attributeList = new LinkedList<Attribute>();
    private static int offset = 0;
    private static int firstVarOffset = -1;
    private static int firstVarIndex = -1;
    static final int LENGTH = JournalEntryParseSupport.createAttribute("LENGTH", 4);
    static final int PARTITION = JournalEntryParseSupport.createAttribute("PARTITION", 2);
    static final int TERM = JournalEntryParseSupport.createAttribute("TERM", 4);
    static final int MAGIC = JournalEntryParseSupport.createAttribute("MAGIC", 2);
    static final int BATCH_SIZE = JournalEntryParseSupport.createAttribute("BATCH_SIZE", 2);
    public static final int TIMESTAMP = JournalEntryParseSupport.createAttribute("TIMESTAMP", 8);
    static final int ENTRY = JournalEntryParseSupport.createAttribute("ENTRY", -1);

    public static int getHeaderLength() {
        return firstVarOffset;
    }

    private static int createAttribute(String name, int length) {
        Attribute attribute = new Attribute(name, length);
        if (attribute.length >= 0) {
            if (offset < 0) {
                throw new ParseJournalException("Can not add a fixed length attribute after any variable length attribute!");
            }
            attribute.setOffset(offset);
            offset += length;
        } else {
            if (firstVarOffset < 0) {
                firstVarOffset = offset;
                firstVarIndex = attributeList.size();
                offset = -1;
            }
            attribute.setOffset(firstVarIndex - attributeList.size());
        }
        attributeList.add(attribute);
        return attribute.getOffset();
    }

    private static class Attribute {
        private final int length;
        private final String name;
        private int offset = -1;

        Attribute(String name, int length) {
            this.name = name;
            this.length = length;
        }

        int getLength() {
            return this.length;
        }

        int getOffset() {
            return this.offset;
        }

        void setOffset(int offset) {
            this.offset = offset;
        }

        String getName() {
            return this.name;
        }
    }
}

