/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.entry.internal.CreateSnapshotEntry;
import io.journalkeeper.core.entry.internal.CreateSnapshotEntrySerializer;
import io.journalkeeper.core.entry.internal.InternalEntry;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.LeaderAnnouncementEntry;
import io.journalkeeper.core.entry.internal.LeaderAnnouncementEntrySerializer;
import io.journalkeeper.core.entry.internal.RecoverSnapshotEntry;
import io.journalkeeper.core.entry.internal.RecoverSnapshotEntrySerializer;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntry;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntrySerializer;
import io.journalkeeper.core.entry.internal.SetPreferredLeaderEntry;
import io.journalkeeper.core.entry.internal.SetPreferredLeaderEntrySerializer;
import io.journalkeeper.core.entry.internal.UpdateVotersS1Entry;
import io.journalkeeper.core.entry.internal.UpdateVotersS1EntrySerializer;
import io.journalkeeper.core.entry.internal.UpdateVotersS2Entry;
import io.journalkeeper.core.entry.internal.UpdateVotersS2EntrySerializer;
import io.journalkeeper.exceptions.SerializeException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class InternalEntriesSerializeSupport {
    private static Map<Class<? extends InternalEntry>, Serializer<? extends InternalEntry>> serializerMap = new HashMap<Class<? extends InternalEntry>, Serializer<? extends InternalEntry>>();
    private static Map<InternalEntryType, Class<? extends InternalEntry>> typeMap = new HashMap<InternalEntryType, Class<? extends InternalEntry>>();

    public static <E extends InternalEntry> E parse(byte[] buffer, Class<E> eClass) {
        Object entry = serializerMap.get(eClass).parse(buffer);
        if (eClass.isAssignableFrom(entry.getClass())) {
            return (E)((InternalEntry)entry);
        }
        throw new SerializeException("Type mismatch!");
    }

    public static <E extends InternalEntry> E parse(byte[] buffer, int offset, int length, Class<E> eClass) {
        byte[] body = offset == 0 ? buffer : Arrays.copyOfRange(buffer, offset, offset + length);
        Object entry = serializerMap.get(eClass).parse(body);
        if (eClass.isAssignableFrom(entry.getClass())) {
            return (E)((InternalEntry)entry);
        }
        throw new SerializeException("Type mismatch!");
    }

    public static <E extends InternalEntry> E parse(byte[] buffer) {
        InternalEntryType type = InternalEntriesSerializeSupport.parseEntryType(buffer);
        Class<? extends InternalEntry> eClass = typeMap.get((Object)type);
        if (null == eClass) {
            throw new SerializeException(String.format("Unknown entry type: %s!", type.name()));
        }
        return (E)InternalEntriesSerializeSupport.parse(buffer, eClass);
    }

    public static <E extends InternalEntry> E parse(byte[] buffer, int offset, int length) {
        InternalEntryType type = InternalEntriesSerializeSupport.parseEntryType(buffer, offset, length);
        Class<? extends InternalEntry> eClass = typeMap.get((Object)type);
        if (null == eClass) {
            throw new SerializeException(String.format("Unknown entry type: %s!", type.name()));
        }
        return (E)InternalEntriesSerializeSupport.parse(buffer, offset, length, eClass);
    }

    public static <E extends InternalEntry> byte[] serialize(E entry) {
        Serializer<? extends InternalEntry> serializer = serializerMap.get(entry.getClass());
        if (serializer == null) {
            throw new SerializeException(String.format("Unknown entry class type: %s", entry.getClass().toString()));
        }
        return serializer.serialize(entry);
    }

    public static InternalEntryType parseEntryType(byte[] buffer) {
        return InternalEntryType.valueOf(buffer[0]);
    }

    public static InternalEntryType parseEntryType(byte[] buffer, int offset, int length) {
        return InternalEntryType.valueOf(buffer[offset]);
    }

    private static <E extends InternalEntry> void registerType(InternalEntryType type, Class<E> eClass, Serializer<E> serializer) {
        serializerMap.put(eClass, serializer);
        typeMap.put(type, eClass);
    }

    static {
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_LEADER_ANNOUNCEMENT, LeaderAnnouncementEntry.class, new LeaderAnnouncementEntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_CREATE_SNAPSHOT, CreateSnapshotEntry.class, new CreateSnapshotEntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_SCALE_PARTITIONS, ScalePartitionsEntry.class, new ScalePartitionsEntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_UPDATE_VOTERS_S1, UpdateVotersS1Entry.class, new UpdateVotersS1EntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_UPDATE_VOTERS_S2, UpdateVotersS2Entry.class, new UpdateVotersS2EntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_SET_PREFERRED_LEADER, SetPreferredLeaderEntry.class, new SetPreferredLeaderEntrySerializer());
        InternalEntriesSerializeSupport.registerType(InternalEntryType.TYPE_RECOVER_SNAPSHOT, RecoverSnapshotEntry.class, new RecoverSnapshotEntrySerializer());
    }
}

