/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.LeaderAnnouncementEntry;
import io.journalkeeper.core.entry.internal.UriSerializeSupport;
import java.net.URI;
import java.nio.ByteBuffer;

public class LeaderAnnouncementEntrySerializer
implements Serializer<LeaderAnnouncementEntry> {
    public byte[] serialize(LeaderAnnouncementEntry entry) {
        byte[] buffer = new byte[5 + UriSerializeSupport.sizeOf(entry.getLeaderUri())];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.put((byte)InternalEntryType.TYPE_LEADER_ANNOUNCEMENT.value());
        byteBuffer.putInt(entry.getTerm());
        UriSerializeSupport.serializerUri(byteBuffer, entry.getLeaderUri());
        return buffer;
    }

    public LeaderAnnouncementEntry parse(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.position(1);
        int term = byteBuffer.getInt();
        URI uri = UriSerializeSupport.parseUri(byteBuffer);
        return new LeaderAnnouncementEntry(term, uri);
    }
}

