/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import java.util.Collection;

public class ReservedPartition {
    public static final int RESERVED_PARTITION = 30000;

    public static void validatePartition(int partition) {
        if (partition >= 30000 || partition < 0) {
            throw new IllegalArgumentException(String.format("partition %d should be zero or positive number and less than %d", partition, 30000));
        }
    }

    public static void validatePartitions(int[] partitions) {
        for (int partition : partitions) {
            ReservedPartition.validatePartition(partition);
        }
    }

    public static void validatePartitions(Collection<Integer> partitions) {
        for (Integer partition : partitions) {
            ReservedPartition.validatePartition(partition);
        }
    }
}

