/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntry;
import java.nio.ByteBuffer;
import java.util.HashSet;

public class ScalePartitionsEntrySerializer
implements Serializer<ScalePartitionsEntry> {
    private int sizeOf(ScalePartitionsEntry scalePartitionsEntry) {
        return 1 + 2 * scalePartitionsEntry.getPartitions().size();
    }

    public byte[] serialize(ScalePartitionsEntry entry) {
        byte[] bytes = new byte[this.sizeOf(entry)];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.put((byte)entry.getType().value());
        for (int partition : entry.getPartitions()) {
            buffer.putShort((short)partition);
        }
        return bytes;
    }

    public ScalePartitionsEntry parse(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 1, bytes.length - 1);
        HashSet<Integer> partitions = new HashSet<Integer>();
        while (buffer.hasRemaining()) {
            partitions.add(Short.valueOf(buffer.getShort()).intValue());
        }
        return new ScalePartitionsEntry(partitions);
    }
}

