/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.entry.internal.UpdateVotersS2Entry;
import io.journalkeeper.core.entry.internal.UriSerializeSupport;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;

public class UpdateVotersS2EntrySerializer
implements Serializer<UpdateVotersS2Entry> {
    private int sizeOf(UpdateVotersS2Entry entry) {
        return 9 + Stream.concat(entry.getConfigNew().stream(), entry.getConfigOld().stream()).map(URI::toASCIIString).map(s -> s.getBytes(StandardCharsets.US_ASCII)).mapToInt(b -> ((byte[])b).length + 2).sum();
    }

    public byte[] serialize(UpdateVotersS2Entry entry) {
        byte[] bytes = new byte[this.sizeOf(entry)];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.put((byte)entry.getType().value());
        List<URI> config = entry.getConfigOld();
        UriSerializeSupport.serializeUriList(buffer, config);
        config = entry.getConfigNew();
        UriSerializeSupport.serializeUriList(buffer, config);
        return bytes;
    }

    public UpdateVotersS2Entry parse(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes, 1, bytes.length - 1);
        List<URI> configOld = UriSerializeSupport.parseUriList(buffer);
        List<URI> configNew = UriSerializeSupport.parseUriList(buffer);
        return new UpdateVotersS2Entry(configOld, configNew);
    }
}

