/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.entry.internal;

import io.journalkeeper.exceptions.SerializeException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class UriSerializeSupport {
    public static void serializeUriList(ByteBuffer buffer, List<URI> config) {
        if (config.size() >= Short.MAX_VALUE) {
            throw new SerializeException(String.format("Size of config overflow! Max: %d, actual: %d. ", (short)Short.MAX_VALUE, config.size()));
        }
        buffer.putShort((short)config.size());
        for (URI uri : config) {
            UriSerializeSupport.serializerUri(buffer, uri);
        }
    }

    public static void serializerUri(ByteBuffer buffer, URI uri) {
        byte[] asciiBytes = uri.toASCIIString().getBytes(StandardCharsets.US_ASCII);
        if (asciiBytes.length >= Short.MAX_VALUE) {
            throw new SerializeException(String.format("URI length too large! Max: %d, actual: %d, uri: %s. ", (short)Short.MAX_VALUE, asciiBytes.length, uri));
        }
        buffer.putShort((short)asciiBytes.length);
        buffer.put(asciiBytes);
    }

    public static int sizeOf(URI uri) {
        return uri.toASCIIString().getBytes(StandardCharsets.US_ASCII).length + 2;
    }

    public static List<URI> parseUriList(ByteBuffer buffer) {
        int sizeOfList = buffer.getShort();
        ArrayList<URI> config = new ArrayList<URI>(sizeOfList);
        for (int i = 0; i < sizeOfList; ++i) {
            URI uri = UriSerializeSupport.parseUri(buffer);
            config.add(uri);
        }
        return config;
    }

    public static URI parseUri(ByteBuffer buffer) {
        short length = buffer.getShort();
        byte[] asciiBytes = new byte[length];
        buffer.get(asciiBytes);
        return URI.create(new String(asciiBytes, StandardCharsets.US_ASCII));
    }
}

