/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.monitor;

import io.journalkeeper.monitor.MonitorCollector;
import io.journalkeeper.monitor.MonitoredServer;
import io.journalkeeper.monitor.ServerMonitorInfo;
import io.journalkeeper.utils.spi.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

@Singleton
public class SimpleMonitorCollector
implements MonitorCollector {
    private Map<URI, MonitoredServer> monitoredServers = new HashMap<URI, MonitoredServer>();

    public synchronized void addServer(MonitoredServer server) {
        this.monitoredServers.put(server.uri(), server);
    }

    public synchronized void removeServer(MonitoredServer server) {
        this.monitoredServers.remove(server.uri());
    }

    public MonitoredServer getMonitoredServer(URI uri) {
        return this.monitoredServers.get(uri);
    }

    public Collection<MonitoredServer> getMonitoredServers() {
        return new HashSet<MonitoredServer>(this.monitoredServers.values());
    }

    public Collection<ServerMonitorInfo> collectAll() {
        ArrayList<ServerMonitorInfo> monitorInfos = new ArrayList<ServerMonitorInfo>();
        if (null != this.monitoredServers) {
            for (MonitoredServer monitoredServer : this.monitoredServers.values()) {
                ServerMonitorInfo serverMonitorInfo = monitoredServer.collect();
                monitorInfos.add(serverMonitorInfo);
            }
        }
        return monitorInfos;
    }
}

