/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.serialize;

import io.journalkeeper.core.api.RaftJournal;
import io.journalkeeper.core.api.State;
import io.journalkeeper.core.api.StateResult;
import io.journalkeeper.core.serialize.SerializeExtensionPoint;
import io.journalkeeper.core.serialize.WrappedState;
import io.journalkeeper.core.serialize.WrappedStateResult;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;

public class StateWrapper<E, ER, Q, QR>
implements State,
Flushable {
    private final SerializeExtensionPoint serializeExtensionPoint;
    private final WrappedState<E, ER, Q, QR> wrappedState;
    private final Flushable flushable;

    public StateWrapper(WrappedState<E, ER, Q, QR> wrappedState, SerializeExtensionPoint serializeExtensionPoint) {
        this.serializeExtensionPoint = serializeExtensionPoint;
        this.wrappedState = wrappedState;
        this.flushable = wrappedState instanceof Flushable ? (Flushable)((Object)wrappedState) : null;
    }

    public StateResult execute(byte[] entry, int partition, long index, int batchSize, RaftJournal journal) {
        WrappedStateResult<ER> wrappedStateResult = this.wrappedState.executeAndNotify(this.serializeExtensionPoint.parse(entry));
        return new StateResult(this.serializeExtensionPoint.serialize(wrappedStateResult.getResult()), wrappedStateResult.getEventData());
    }

    public byte[] query(byte[] query, RaftJournal journal) {
        return this.serializeExtensionPoint.serialize(this.wrappedState.query(this.serializeExtensionPoint.parse(query)));
    }

    public void recover(Path path, Properties properties) throws IOException {
        this.wrappedState.recover(path, properties);
    }

    public void close() {
        this.wrappedState.close();
    }

    @Override
    public void flush() throws IOException {
        if (null != this.flushable) {
            this.flushable.flush();
        }
    }
}

