/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.serialize;

import io.journalkeeper.core.BootStrap;
import io.journalkeeper.core.api.AdminClient;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.serialize.JavaSerializeExtensionPoint;
import io.journalkeeper.core.serialize.SerializeExtensionPoint;
import io.journalkeeper.core.serialize.StateWrapper;
import io.journalkeeper.core.serialize.WrappedRaftClient;
import io.journalkeeper.core.serialize.WrappedStateFactory;
import io.journalkeeper.utils.spi.ServiceSupport;
import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedBootStrap<E, ER, Q, QR> {
    public static final String SERIALIZER_CONFIG_KEY = "serializer";
    private static final Logger logger = LoggerFactory.getLogger(WrappedBootStrap.class);
    private final BootStrap bootStrap;
    private final SerializeExtensionPoint serializeExtensionPoint;
    private final Properties properties;

    public WrappedBootStrap(List<URI> servers, Properties properties) {
        this.properties = properties;
        this.serializeExtensionPoint = this.loadSerializer(properties.getProperty(SERIALIZER_CONFIG_KEY, null));
        logger.info("Using serializer: {}.", (Object)this.serializeExtensionPoint.getClass().getCanonicalName());
        this.bootStrap = new BootStrap(servers, properties);
    }

    public WrappedBootStrap(WrappedStateFactory<E, ER, Q, QR> wrappedStateFactory, Properties properties) {
        this(RaftServer.Roll.VOTER, wrappedStateFactory, properties);
    }

    public WrappedBootStrap(RaftServer.Roll roll, WrappedStateFactory<E, ER, Q, QR> wrappedStateFactory, Properties properties) {
        this.properties = properties;
        this.serializeExtensionPoint = this.loadSerializer(properties.getProperty(SERIALIZER_CONFIG_KEY, null));
        logger.info("Using serializer: {}.", (Object)this.serializeExtensionPoint.getClass().getCanonicalName());
        this.bootStrap = new BootStrap(roll, () -> new StateWrapper(wrappedStateFactory.createState(), this.serializeExtensionPoint), properties);
    }

    private SerializeExtensionPoint loadSerializer(String serializer) {
        if (serializer != null && !serializer.isEmpty()) {
            return (SerializeExtensionPoint)ServiceSupport.load(SerializeExtensionPoint.class, (String)serializer);
        }
        return ServiceSupport.tryLoad(SerializeExtensionPoint.class).orElse(new JavaSerializeExtensionPoint());
    }

    public WrappedRaftClient<E, ER, Q, QR> getClient() {
        return new WrappedRaftClient(this.bootStrap.getClient(), this.serializeExtensionPoint);
    }

    public RaftServer getServer() {
        return this.bootStrap.getServer();
    }

    public AdminClient getAdminClient() {
        return this.bootStrap.getAdminClient();
    }

    public void shutdown() {
        this.bootStrap.shutdown();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public WrappedRaftClient<E, ER, Q, QR> getLocalClient() {
        return new WrappedRaftClient(this.bootStrap.getLocalClient(), this.serializeExtensionPoint);
    }
}

