/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.serialize;

import io.journalkeeper.core.api.ClusterReadyAware;
import io.journalkeeper.core.api.QueryConsistency;
import io.journalkeeper.core.api.RaftClient;
import io.journalkeeper.core.api.ServerConfigAware;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.transaction.TransactionContext;
import io.journalkeeper.core.api.transaction.TransactionId;
import io.journalkeeper.core.serialize.SerializeExtensionPoint;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.event.Watchable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;

public class WrappedRaftClient<E, ER, Q, QR>
implements Watchable,
ClusterReadyAware,
ServerConfigAware {
    private final SerializeExtensionPoint serializeExtensionPoint;
    private final RaftClient raftClient;

    public WrappedRaftClient(RaftClient raftClient, SerializeExtensionPoint serializeExtensionPoint) {
        this.serializeExtensionPoint = serializeExtensionPoint;
        this.raftClient = raftClient;
    }

    public CompletableFuture<ER> update(E entry) {
        return this.raftClient.update(this.serializeExtensionPoint.serialize(entry)).thenApply(this.serializeExtensionPoint::parse);
    }

    public CompletableFuture<QR> query(Q query) {
        return this.raftClient.query(this.serializeExtensionPoint.serialize(query)).thenApply(this.serializeExtensionPoint::parse);
    }

    public CompletableFuture<QR> query(Q query, QueryConsistency consistency) {
        return this.raftClient.query(this.serializeExtensionPoint.serialize(query), consistency).thenApply(this.serializeExtensionPoint::parse);
    }

    public CompletableFuture<TransactionContext> createTransaction() {
        return this.raftClient.createTransaction();
    }

    public CompletableFuture<TransactionContext> createTransaction(Map<String, String> context) {
        return this.raftClient.createTransaction(context);
    }

    public CompletableFuture<Void> completeTransaction(TransactionId transactionId, boolean commitOrAbort) {
        return this.raftClient.completeTransaction(transactionId, commitOrAbort);
    }

    public CompletableFuture<Collection<TransactionContext>> getOpeningTransactions() {
        return this.raftClient.getOpeningTransactions();
    }

    public CompletableFuture<Void> update(TransactionId transactionId, E entry) {
        return this.raftClient.update(transactionId, new UpdateRequest(this.serializeExtensionPoint.serialize(entry)));
    }

    public void waitForClusterReady(long maxWaitMs) throws TimeoutException {
        this.raftClient.waitForClusterReady(maxWaitMs);
    }

    public void updateServers(List<URI> servers) {
        this.raftClient.updateServers(servers);
    }

    public void watch(EventWatcher eventWatcher) {
        this.raftClient.watch(eventWatcher);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.raftClient.unWatch(eventWatcher);
    }
}

