/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.base.ReplicableIterator;
import io.journalkeeper.core.api.ClusterConfiguration;
import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.api.StateResult;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.LeaderAnnouncementEntry;
import io.journalkeeper.core.entry.internal.RecoverSnapshotEntry;
import io.journalkeeper.core.entry.internal.ReservedPartition;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntry;
import io.journalkeeper.core.entry.internal.UpdateVotersS1Entry;
import io.journalkeeper.core.entry.internal.UpdateVotersS2Entry;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.journal.JournalSnapshot;
import io.journalkeeper.core.metric.DummyMetric;
import io.journalkeeper.core.server.DefaultExceptionListener;
import io.journalkeeper.core.server.MetricProvider;
import io.journalkeeper.core.server.PartialSnapshot;
import io.journalkeeper.core.server.ServerRpcProvider;
import io.journalkeeper.core.server.VoterConfigManager;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.core.state.EntryFutureImpl;
import io.journalkeeper.core.state.JournalKeeperState;
import io.journalkeeper.core.state.StateQueryResult;
import io.journalkeeper.core.strategy.DefaultJournalCompactionStrategy;
import io.journalkeeper.core.strategy.JournalCompactionStrategy;
import io.journalkeeper.exceptions.IndexOverflowException;
import io.journalkeeper.exceptions.IndexUnderflowException;
import io.journalkeeper.exceptions.JournalException;
import io.journalkeeper.exceptions.NoSuchSnapshotException;
import io.journalkeeper.exceptions.RecoverException;
import io.journalkeeper.metric.JMetric;
import io.journalkeeper.metric.JMetricFactory;
import io.journalkeeper.metric.JMetricSupport;
import io.journalkeeper.persistence.BufferPool;
import io.journalkeeper.persistence.JournalPersistence;
import io.journalkeeper.persistence.MetadataPersistence;
import io.journalkeeper.persistence.PersistenceFactory;
import io.journalkeeper.persistence.ServerMetadata;
import io.journalkeeper.rpc.client.AddPullWatchResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.ConvertRollRequest;
import io.journalkeeper.rpc.client.ConvertRollResponse;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.rpc.client.PullEventsRequest;
import io.journalkeeper.rpc.client.PullEventsResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.RemovePullWatchRequest;
import io.journalkeeper.rpc.client.RemovePullWatchResponse;
import io.journalkeeper.rpc.server.GetServerEntriesRequest;
import io.journalkeeper.rpc.server.GetServerEntriesResponse;
import io.journalkeeper.rpc.server.GetServerStateRequest;
import io.journalkeeper.rpc.server.GetServerStateResponse;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import io.journalkeeper.utils.ThreadSafeFormat;
import io.journalkeeper.utils.event.Event;
import io.journalkeeper.utils.event.EventBus;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.spi.ServiceLoadException;
import io.journalkeeper.utils.spi.ServiceSupport;
import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.ExceptionListener;
import io.journalkeeper.utils.threads.ThreadBuilder;
import io.journalkeeper.utils.threads.Threads;
import io.journalkeeper.utils.threads.ThreadsFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServer
implements ServerRpc,
RaftServer,
ServerRpcProvider,
MetricProvider {
    public static final float RAND_INTERVAL_RANGE = 0.5f;
    private static final Logger logger = LoggerFactory.getLogger(AbstractServer.class);
    private static final String STATE_PATH = "state";
    private static final String SNAPSHOTS_PATH = "snapshots";
    private static final String METADATA_PATH = "metadata";
    private static final String METADATA_FILE = "metadata";
    private static final String PARTIAL_SNAPSHOT_PATH = "partial_snapshot";
    private static final int COMPACT_PERIOD_SEC = 60;
    private static final JMetric DUMMY_METRIC = new DummyMetric();
    private static final String METRIC_APPLY_ENTRIES = "APPLY_ENTRIES";
    protected final JournalKeeperState state;
    protected final ScheduledExecutorService scheduledExecutor;
    protected final ExecutorService asyncExecutor;
    protected final NavigableMap<Long, JournalKeeperState> snapshots = new ConcurrentSkipListMap<Long, JournalKeeperState>();
    protected final PartialSnapshot partialSnapshot;
    protected final BufferPool bufferPool;
    protected final Map<URI, ServerRpc> remoteServers = new HashMap<URI, ServerRpc>();
    protected final EventBus eventBus;
    protected final Threads threads = ThreadsFactory.create();
    protected final Properties properties;
    protected final StateFactory stateFactory;
    protected final JournalEntryParser journalEntryParser;
    protected final VoterConfigManager voterConfigManager;
    private final Map<Integer, ReplicableIterator> snapshotIteratorMap = new ConcurrentHashMap<Integer, ReplicableIterator>();
    private JMetricFactory metricFactory;
    private Map<String, JMetric> metricMap;
    private final JMetric applyEntriesMetric;
    private final AtomicInteger nextSnapshotIteratorId = new AtomicInteger();
    protected URI uri;
    protected Journal journal;
    protected URI leaderUri;
    protected List<URI> observers;
    protected PersistenceFactory persistenceFactory;
    protected MetadataPersistence metadataPersistence;
    protected ServerRpcAccessPoint serverRpcAccessPoint;
    private boolean available = false;
    private Config config;
    private volatile StateServer.ServerState serverState = StateServer.ServerState.CREATED;
    private ServerMetadata lastSavedServerMetadata = null;
    private ScheduledFuture flushStateFuture;
    private ScheduledFuture compactJournalFuture;
    private JournalCompactionStrategy journalCompactionStrategy;

    protected AbstractServer(StateFactory stateFactory, JournalEntryParser journalEntryParser, ScheduledExecutorService scheduledExecutor, ExecutorService asyncExecutor, ServerRpcAccessPoint serverRpcAccessPoint, Properties properties) {
        this.journalEntryParser = journalEntryParser;
        this.scheduledExecutor = scheduledExecutor;
        this.asyncExecutor = asyncExecutor;
        this.config = this.toConfig(properties);
        this.serverRpcAccessPoint = serverRpcAccessPoint;
        this.properties = properties;
        this.stateFactory = stateFactory;
        this.voterConfigManager = new VoterConfigManager(journalEntryParser);
        try {
            this.journalCompactionStrategy = (JournalCompactionStrategy)ServiceSupport.load(JournalCompactionStrategy.class);
        }
        catch (ServiceLoadException ignored) {
            this.journalCompactionStrategy = new DefaultJournalCompactionStrategy(this.config.getJournalRetentionMin());
        }
        logger.info("Using JournalCompactionStrategy: {}.", (Object)this.journalCompactionStrategy.getClass().getCanonicalName());
        if (this.config.isEnableMetric()) {
            try {
                this.metricFactory = (JMetricFactory)ServiceSupport.load(JMetricFactory.class);
                this.metricMap = new ConcurrentHashMap<String, JMetric>();
                if (this.config.getPrintMetricIntervalSec() > 0) {
                    this.threads.createThread(this.buildPrintMetricThread());
                }
            }
            catch (ServiceLoadException se) {
                logger.warn("No metric extension found in the classpath, Metric will disabled!");
                this.config.setEnableMetric(false);
                this.metricFactory = null;
                this.metricMap = null;
            }
        } else {
            this.metricFactory = null;
            this.metricMap = null;
        }
        this.applyEntriesMetric = this.getMetric(METRIC_APPLY_ENTRIES);
        this.eventBus = new EventBus(this.config.getRpcTimeoutMs());
        this.persistenceFactory = (PersistenceFactory)ServiceSupport.load(PersistenceFactory.class);
        this.metadataPersistence = this.persistenceFactory.createMetadataPersistenceInstance();
        this.bufferPool = (BufferPool)ServiceSupport.load(BufferPool.class);
        this.journal = new Journal(this.persistenceFactory, this.bufferPool, journalEntryParser);
        this.state = new JournalKeeperState(stateFactory, this.metadataPersistence);
        this.partialSnapshot = new PartialSnapshot(this.partialSnapshotPath());
        this.state.addInterceptor(InternalEntryType.TYPE_SCALE_PARTITIONS, this::scalePartitions);
        this.state.addInterceptor(InternalEntryType.TYPE_LEADER_ANNOUNCEMENT, this::announceLeader);
        this.state.addInterceptor(InternalEntryType.TYPE_CREATE_SNAPSHOT, this::createSnapShot);
        this.state.addInterceptor(InternalEntryType.TYPE_RECOVER_SNAPSHOT, this::recoverSnapShot);
    }

    public URI serverUri() {
        return this.uri;
    }

    protected void enable() {
        this.available = true;
    }

    protected void disable() {
        this.available = false;
    }

    protected boolean isAvailable() {
        return this.available;
    }

    private AsyncLoopThread buildStateMachineThread() {
        return ThreadBuilder.builder().name(this.threadName("StateMachineThread")).doWork(this::applyEntries).sleepTime(50L, 100L).onException((ExceptionListener)new DefaultExceptionListener("StateMachineThread")).daemon(true).build();
    }

    private AsyncLoopThread buildFlushJournalThread() {
        return ThreadBuilder.builder().name(this.threadName("FlushJournalThread")).doWork(this::flushJournal).sleepTime(this.config.getFlushIntervalMs(), this.config.getFlushIntervalMs()).onException((ExceptionListener)new DefaultExceptionListener("FlushJournalThread")).daemon(true).build();
    }

    private AsyncLoopThread buildPrintMetricThread() {
        return ThreadBuilder.builder().name(this.threadName("PrintMetricThread")).doWork(this::printMetrics).sleepTime((long)(this.config.getPrintMetricIntervalSec() * 1000), (long)(this.config.getPrintMetricIntervalSec() * 1000)).onException((ExceptionListener)new DefaultExceptionListener("PrintMetricThread")).daemon(true).build();
    }

    public synchronized void init(URI uri, List<URI> voters, Set<Integer> userPartitions, URI preferredLeader) throws IOException {
        if (null == userPartitions) {
            userPartitions = new HashSet<Integer>();
        }
        if (userPartitions.isEmpty()) {
            userPartitions.add(0);
        }
        ReservedPartition.validatePartitions(userPartitions);
        this.uri = uri;
        HashSet<Integer> partitions = new HashSet<Integer>(userPartitions);
        partitions.add((Integer)Short.MAX_VALUE);
        partitions.addAll(IntStream.range(30000, 30032).boxed().collect(Collectors.toSet()));
        this.state.init(this.statePath(), voters, partitions, preferredLeader);
        this.createFistSnapshot(voters, partitions, preferredLeader);
        this.lastSavedServerMetadata = this.createServerMetadata();
        this.metadataPersistence.save(this.metadataFile(), (Object)this.lastSavedServerMetadata);
    }

    public boolean isInitialized() {
        try {
            ServerMetadata metadata = (ServerMetadata)this.metadataPersistence.load(this.metadataFile(), ServerMetadata.class);
            return metadata != null && metadata.isInitialized();
        }
        catch (Exception e) {
            return false;
        }
    }

    int getTerm(long index) {
        try {
            return this.journal.getTerm(index);
        }
        catch (IndexUnderflowException e) {
            if (index + 1L == (Long)this.snapshots.firstKey()) {
                return this.snapshots.firstEntry().getValue().lastIncludedTerm();
            }
            throw e;
        }
    }

    protected Path workingDir() {
        return this.config.getWorkingDir();
    }

    protected Path snapshotsPath() {
        return this.workingDir().resolve(SNAPSHOTS_PATH);
    }

    private void createFistSnapshot(List<URI> voters, Set<Integer> partitions, URI preferredLeader) throws IOException {
        JournalKeeperState snapshot = new JournalKeeperState(this.stateFactory, this.metadataPersistence);
        snapshot.init(this.snapshotsPath().resolve(String.valueOf(0L)), voters, partitions, preferredLeader);
    }

    protected Path statePath() {
        return this.workingDir().resolve(STATE_PATH);
    }

    protected Path metadataFile() {
        return this.workingDir().resolve("metadata").resolve("metadata");
    }

    private void applyEntries() {
        while (this.state.lastApplied() < this.journal.commitIndex()) {
            this.applyEntriesMetric.start();
            long offset = this.journal.readOffset(this.state.lastApplied());
            JournalEntry entryHeader = this.journal.readEntryHeaderByOffset(offset);
            StateResult stateResult = this.state.applyEntry(entryHeader, new EntryFutureImpl(this.journal, offset), this.journal);
            this.afterStateChanged(stateResult.getUserResult());
            if (this.config.isEnableEvents()) {
                stateResult.putEventData("lastApplied", String.valueOf(this.state.lastApplied()));
                this.fireEvent(1, stateResult.getEventData());
            }
            this.applyEntriesMetric.end(() -> entryHeader.getLength());
        }
    }

    private void fireOnLeaderChangeEvent(int term, URI leaderUri) {
        if (this.config.isEnableEvents()) {
            HashMap<String, String> eventData = new HashMap<String, String>();
            eventData.put("leader", String.valueOf(leaderUri));
            eventData.put("term", String.valueOf(term));
            this.fireEvent(1000, eventData);
        }
    }

    private void announceLeader(InternalEntryType type, byte[] internalEntry) {
        LeaderAnnouncementEntry leaderAnnouncementEntry = (LeaderAnnouncementEntry)InternalEntriesSerializeSupport.parse(internalEntry);
        this.fireOnLeaderChangeEvent(leaderAnnouncementEntry.getTerm(), leaderAnnouncementEntry.getLeaderUri());
    }

    private void scalePartitions(InternalEntryType type, byte[] internalEntry) {
        ScalePartitionsEntry scalePartitionsEntry = (ScalePartitionsEntry)InternalEntriesSerializeSupport.parse(internalEntry);
        Set<Integer> partitions = scalePartitionsEntry.getPartitions();
        try {
            Set<Integer> currentPartitions = this.journal.getPartitions();
            currentPartitions.removeIf(p -> p >= 30000);
            for (int partition : partitions) {
                if (currentPartitions.contains(partition)) continue;
                this.journal.addPartition(partition);
            }
            ArrayList<Integer> toBeRemoved = new ArrayList<Integer>();
            for (Integer partition : currentPartitions) {
                if (partitions.contains(partition)) continue;
                toBeRemoved.add(partition);
            }
            for (Integer partition : toBeRemoved) {
                this.journal.removePartition(partition);
            }
            logger.info("Journal repartitioned, partitions: {}, path: {}.", this.journal.getPartitions(), (Object)this.journalPath().toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new JournalException((Throwable)e);
        }
    }

    protected void fireEvent(int eventType, Map<String, String> eventData) {
        if (this.config.isEnableEvents()) {
            this.eventBus.fireEvent(new Event(eventType, eventData));
        }
    }

    protected void afterStateChanged(byte[] updateResult) {
    }

    public CompletableFuture<QueryStateResponse> queryServerState(QueryStateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (request.getIndex() > 0L && this.state.lastApplied() < request.getIndex()) {
                    return new QueryStateResponse((Throwable)new IllegalStateException());
                }
                StateQueryResult queryResult = this.state.query(request.getQuery(), this.journal);
                return new QueryStateResponse(queryResult.getResult(), queryResult.getLastApplied());
            }
            catch (Throwable throwable) {
                return new QueryStateResponse(throwable);
            }
        }, this.asyncExecutor);
    }

    public CompletableFuture<QueryStateResponse> querySnapshot(QueryStateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JournalKeeperState snapshot;
                StateQueryResult queryResult;
                if (request.getIndex() > this.state.lastApplied()) {
                    throw new IndexOverflowException();
                }
                if (request.getIndex() == this.state.lastApplied() && (queryResult = this.state.query(request.getQuery(), this.journal)).getLastApplied() == request.getIndex()) {
                    return new QueryStateResponse(queryResult.getResult(), queryResult.getLastApplied());
                }
                Map.Entry<Long, JournalKeeperState> nearestSnapshot = this.snapshots.floorEntry(request.getIndex());
                if (null == nearestSnapshot) {
                    throw new IndexUnderflowException();
                }
                if (request.getIndex() == nearestSnapshot.getKey().longValue()) {
                    snapshot = nearestSnapshot.getValue();
                } else {
                    snapshot = new JournalKeeperState(this.stateFactory, this.metadataPersistence);
                    Path tempSnapshotPath = this.snapshotsPath().resolve(String.valueOf(request.getIndex()));
                    if (Files.exists(tempSnapshotPath, new LinkOption[0])) {
                        throw new ConcurrentModificationException(String.format("A snapshot of position %d is creating, please retry later.", request.getIndex()));
                    }
                    nearestSnapshot.getValue().dump(tempSnapshotPath);
                    snapshot.recover(tempSnapshotPath, this.properties);
                    while (snapshot.lastApplied() < request.getIndex()) {
                        long offset = this.journal.readOffset(snapshot.lastApplied());
                        JournalEntry header = this.journal.readEntryHeaderByOffset(offset);
                        snapshot.applyEntry(header, new EntryFutureImpl(this.journal, offset), this.journal);
                    }
                    snapshot.flush();
                    this.snapshots.putIfAbsent(request.getIndex(), snapshot);
                }
                return new QueryStateResponse(snapshot.query(request.getQuery(), this.journal).getResult());
            }
            catch (Throwable throwable) {
                return new QueryStateResponse(throwable);
            }
        }, this.asyncExecutor);
    }

    private void createSnapShot(InternalEntryType type, byte[] internalEntry) {
        if (type == InternalEntryType.TYPE_CREATE_SNAPSHOT) {
            this.createSnapshot();
        }
    }

    private void recoverSnapShot(InternalEntryType type, byte[] internalEntry) {
        RecoverSnapshotEntry recoverSnapshotEntry = (RecoverSnapshotEntry)InternalEntriesSerializeSupport.parse(internalEntry);
        JournalKeeperState targetSnapshot = (JournalKeeperState)this.snapshots.get(recoverSnapshotEntry.getIndex());
        if (targetSnapshot == null) {
            logger.warn("recover snapshot failed, snapshot not exist, index: {}", (Object)recoverSnapshotEntry.getIndex());
            return;
        }
        try {
            this.createSnapshot();
            this.doRecoverSnapshot(targetSnapshot);
        }
        catch (Exception e) {
            logger.info("recover snapshot exception, target snapshot: {}", (Object)targetSnapshot.getPath(), (Object)e);
        }
    }

    protected void doRecoverSnapshot(JournalKeeperState targetSnapshot) throws IOException {
        logger.info("recover snapshot, target snapshot: {}", (Object)targetSnapshot.getPath());
        this.state.closeUnsafe();
        this.state.clearUserState();
        targetSnapshot.dumpUserState(this.statePath());
        this.state.recoverUserStateUnsafe();
        logger.info("recover snapshot success, target snapshot: {}", (Object)targetSnapshot.getPath());
    }

    private Config toConfig(Properties properties) {
        Config config = new Config();
        config.setSnapshotIntervalSec(Integer.parseInt(properties.getProperty("snapshot_interval_sec", String.valueOf(0))));
        config.setJournalRetentionMin(Integer.parseInt(properties.getProperty("journal_retention_min", String.valueOf(0))));
        config.setRpcTimeoutMs(Long.parseLong(properties.getProperty("rpc_timeout_ms", String.valueOf(1000L))));
        config.setFlushIntervalMs(Long.parseLong(properties.getProperty("flush_interval_ms", String.valueOf(50L))));
        config.setWorkingDir(Paths.get(properties.getProperty("working_dir", config.getWorkingDir().normalize().toString()), new String[0]));
        config.setGetStateBatchSize(Integer.parseInt(properties.getProperty("get_state_batch_size", String.valueOf(0x100000))));
        config.setEnableMetric(Boolean.parseBoolean(properties.getProperty("enable_metric", String.valueOf(false))));
        config.setDisableLogo(Boolean.parseBoolean(properties.getProperty("disable_logo", String.valueOf(false))));
        config.setPrintMetricIntervalSec(Integer.parseInt(properties.getProperty("print_metric_interval_sec", String.valueOf(0))));
        config.setEnableEvents(Boolean.parseBoolean(properties.getProperty("enable_events", String.valueOf(true))));
        return config;
    }

    public void watch(EventWatcher eventWatcher) {
        this.eventBus.watch(eventWatcher);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.eventBus.unWatch(eventWatcher);
    }

    public CompletableFuture<AddPullWatchResponse> addPullWatch() {
        return CompletableFuture.supplyAsync(() -> new AddPullWatchResponse(this.eventBus.addPullWatch(), this.eventBus.pullIntervalMs()), this.asyncExecutor);
    }

    public CompletableFuture<RemovePullWatchResponse> removePullWatch(RemovePullWatchRequest request) {
        return CompletableFuture.runAsync(() -> this.eventBus.removePullWatch(request.getPullWatchId()), this.asyncExecutor).thenApply(v -> new RemovePullWatchResponse());
    }

    public CompletableFuture<PullEventsResponse> pullEvents(PullEventsRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (request.getAckSequence() >= 0L) {
                this.eventBus.ackPullEvents(request.getPullWatchId(), request.getAckSequence());
            }
            return new PullEventsResponse(this.eventBus.pullEvents(request.getPullWatchId()));
        }, this.asyncExecutor);
    }

    public CompletableFuture<GetServersResponse> getServers() {
        return CompletableFuture.supplyAsync(() -> new GetServersResponse(new ClusterConfiguration(this.leaderUri, this.state.voters(), this.observers)), this.asyncExecutor);
    }

    protected Path partialSnapshotPath() {
        return this.workingDir().resolve(PARTIAL_SNAPSHOT_PATH);
    }

    private void createSnapshot() {
        long lastApplied = this.state.lastApplied();
        logger.info("Creating snapshot at index: {}...", (Object)lastApplied);
        Path snapshotPath = this.snapshotsPath().resolve(String.valueOf(lastApplied));
        try {
            this.state.dump(snapshotPath);
            JournalKeeperState snapshot = new JournalKeeperState(this.stateFactory, this.metadataPersistence);
            snapshot.recover(snapshotPath, this.properties);
            snapshot.createSnapshot(this.journal);
            this.snapshots.put(snapshot.lastApplied(), snapshot);
            logger.info("Snapshot at index: {} created, {}.", (Object)lastApplied, (Object)snapshot);
        }
        catch (IOException e) {
            logger.warn("Create snapshot exception! Snapshot: {}.", (Object)snapshotPath, (Object)e);
        }
    }

    public CompletableFuture<GetServerStateResponse> getServerState(GetServerStateRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                int iteratorId;
                if (request.getIteratorId() >= 0) {
                    iteratorId = request.getIteratorId();
                } else {
                    long snapshotIndex = request.getLastIncludedIndex() + 1L;
                    JournalKeeperState snapshot = (JournalKeeperState)this.snapshots.get(snapshotIndex);
                    if (null != snapshot) {
                        ReplicableIterator iterator = snapshot.iterator();
                        iteratorId = this.nextSnapshotIteratorId.getAndIncrement();
                        this.snapshotIteratorMap.put(iteratorId, iterator);
                        this.scheduledExecutor.schedule(() -> this.snapshotIteratorMap.remove(iteratorId), 1L, TimeUnit.MINUTES);
                    } else {
                        throw new NoSuchSnapshotException();
                    }
                }
                ReplicableIterator iterator = this.snapshotIteratorMap.get(iteratorId);
                if (null != iterator) {
                    return new GetServerStateResponse(iterator.lastIncludedIndex(), iterator.lastIncludedTerm(), iterator.offset(), iterator.nextTrunk(), iterator.hasMoreTrunks(), iteratorId);
                }
                throw new NoSuchSnapshotException();
            }
            catch (Throwable t) {
                logger.warn("GetServerState exception!", t);
                return new GetServerStateResponse(t);
            }
        }, this.asyncExecutor).exceptionally(GetServerStateResponse::new);
    }

    public final void start() {
        if (this.serverState != StateServer.ServerState.CREATED) {
            throw new IllegalStateException("AbstractServer can only start once!");
        }
        this.serverState = StateServer.ServerState.STARTING;
        this.doStart();
        this.threads.createThread(this.buildStateMachineThread());
        this.threads.createThread(this.buildFlushJournalThread());
        this.threads.startThread(this.threadName("StateMachineThread"));
        this.threads.startThread(this.threadName("FlushJournalThread"));
        if (this.config.isEnableMetric() && this.config.getPrintMetricIntervalSec() > 0) {
            this.threads.createThread(this.buildPrintMetricThread());
            this.threads.startThread(this.threadName("PrintMetricThread"));
        }
        this.flushStateFuture = this.scheduledExecutor.scheduleAtFixedRate(this::flushState, ThreadLocalRandom.current().nextLong(10L, 50L), this.config.getFlushIntervalMs(), TimeUnit.MILLISECONDS);
        this.compactJournalFuture = this.scheduledExecutor.scheduleAtFixedRate(this::compactJournalPeriodically, ThreadLocalRandom.current().nextLong(0L, 60L), 60L, TimeUnit.SECONDS);
        this.serverState = StateServer.ServerState.RUNNING;
    }

    protected abstract void doStart();

    private void flushAll() {
        this.journal.flush();
        this.flushState();
    }

    private void flushJournal() {
        this.journal.flush();
        this.onJournalFlushed();
    }

    protected void onJournalFlushed() {
    }

    private void flushState() {
        try {
            this.state.flush();
            ServerMetadata metadata = this.createServerMetadata();
            if (!metadata.equals((Object)this.lastSavedServerMetadata)) {
                this.metadataPersistence.save(this.metadataFile(), (Object)metadata);
                this.lastSavedServerMetadata = metadata;
            }
        }
        catch (ClosedByInterruptException metadata) {
        }
        catch (Throwable e) {
            logger.warn("Flush exception, commitIndex: {}, lastApplied: {}, server: {}: ", new Object[]{this.journal.commitIndex(), this.state.lastApplied(), this.uri, e});
        }
    }

    @Override
    public CompletableFuture<ServerRpc> getServerRpc(URI uri) {
        return CompletableFuture.completedFuture(this.remoteServers.computeIfAbsent(uri, uri1 -> this.serverRpcAccessPoint.getServerRpcAgent(uri1)));
    }

    public final void stop() {
        try {
            if (this.serverState == StateServer.ServerState.RUNNING) {
                this.serverState = StateServer.ServerState.STOPPING;
                this.doStop();
                this.remoteServers.values().forEach(ClientServerRpc::stop);
                this.waitJournalApplied();
                this.threads.stopThread(this.threadName("StateMachineThread"));
                this.threads.stopThread(this.threadName("FlushJournalThread"));
                if (this.threads.exists(this.threadName("PrintMetricThread"))) {
                    this.threads.stopThread(this.threadName("PrintMetricThread"));
                }
                this.stopAndWaitScheduledFeature(this.compactJournalFuture, 1000L);
                this.stopAndWaitScheduledFeature(this.flushStateFuture, 1000L);
                if (this.persistenceFactory instanceof Closeable) {
                    ((Closeable)this.persistenceFactory).close();
                }
                this.flushAll();
                this.journal.close();
                this.serverState = StateServer.ServerState.STOPPED;
                logger.info("Server {} stopped.", (Object)this.serverUri());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.warn("Exception: ", t);
        }
    }

    private void waitJournalApplied() throws InterruptedException {
        while (this.journal.commitIndex() < this.state.lastApplied()) {
            Thread.sleep(50L);
        }
    }

    protected abstract void doStop();

    protected void stopAndWaitScheduledFeature(ScheduledFuture scheduledFuture, long timeout) throws TimeoutException {
        if (scheduledFuture != null) {
            long t0 = System.currentTimeMillis();
            while (!scheduledFuture.isDone()) {
                if (System.currentTimeMillis() - t0 > timeout) {
                    throw new TimeoutException("Wait for async job timeout!");
                }
                scheduledFuture.cancel(true);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.warn("Exception: ", (Throwable)e);
                }
            }
        }
    }

    public synchronized void recover() throws IOException {
        this.lastSavedServerMetadata = (ServerMetadata)this.metadataPersistence.load(this.metadataFile(), ServerMetadata.class);
        if (this.lastSavedServerMetadata == null || !this.lastSavedServerMetadata.isInitialized()) {
            throw new RecoverException(String.format("Recover failed! Cause: metadata is not initialized. Metadata path: %s.", this.metadataFile().toString()));
        }
        this.onMetadataRecovered(this.lastSavedServerMetadata);
        this.state.recover(this.statePath(), this.properties);
        this.recoverSnapshots();
        this.recoverJournal(this.state.getPartitions(), this.snapshots.firstEntry().getValue().getJournalSnapshot(), this.lastSavedServerMetadata.getCommitIndex());
        this.onJournalRecovered(this.journal);
        logger.info(this.getStartupInfo());
    }

    private String getStartupInfo() {
        String version = this.getClass().getPackage().getImplementationVersion();
        StringBuilder sb = new StringBuilder("\n=======================================================================\n" + (this.config.isDisableLogo() ? "" : "\n      _                              _   _  __                         \n     | | ___  _   _ _ __ _ __   __ _| | | |/ /___  ___ _ __   ___ _ __ \n  _  | |/ _ \\| | | | '__| '_ \\ / _` | | | ' // _ \\/ _ \\ '_ \\ / _ \\ '__|\n | |_| | (_) | |_| | |  | | | | (_| | | | . \\  __/  __/ |_) |  __/ |   \n  \\___/ \\___/ \\__,_|_|  |_| |_|\\__,_|_| |_|\\_\\___|\\___| .__/ \\___|_|   \n                                                      |_|              \n  Version:\t" + version + "\n" + "-----------------------------------------------------------------------\n") + String.format("URI:\t%s\n", this.serverUri()) + String.format("Working dir:\t%s\n", this.workingDir()) + String.format("Config:\t%s\n", this.state.getConfigState()) + String.format("State:\tlastAppliedIndex=%d, lastIncludedTerm=%d, preferredLeader=%s\n", this.state.lastApplied(), this.state.lastIncludedTerm(), this.state.getPreferredLeader()) + String.format("Journal:\t[%d, %d], commitIndex=%d\n", this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex()));
        this.journal.getPartitionMap().entrySet().stream().filter(entry -> (Integer)entry.getKey() < 30000).sorted(Comparator.comparing(Map.Entry::getKey)).forEach(entry -> sb.append("  Partition ").append(entry.getKey()).append(":\t").append(String.format("[%d, %d]\n", ((JournalPersistence)entry.getValue()).min() / 8L, ((JournalPersistence)entry.getValue()).max() / 8L)));
        sb.append("Snapshots: \t").append(this.snapshots.keySet()).append("\n");
        sb.append("=======================================================================\n");
        return sb.toString();
    }

    protected void onJournalRecovered(Journal journal) {
        this.recoverVoterConfig();
    }

    private void recoverVoterConfig() {
        boolean isRecoveredFromJournal = false;
        for (long index = this.journal.maxIndex(Short.MAX_VALUE) - 1L; index >= this.journal.minIndex(Short.MAX_VALUE); --index) {
            JournalEntry entry = this.journal.readByPartition(Short.MAX_VALUE, index);
            InternalEntryType type = InternalEntriesSerializeSupport.parseEntryType(entry.getPayload().getBytes());
            if (type == InternalEntryType.TYPE_UPDATE_VOTERS_S1) {
                UpdateVotersS1Entry updateVotersS1Entry = (UpdateVotersS1Entry)InternalEntriesSerializeSupport.parse(entry.getPayload().getBytes());
                this.state.setConfigState(new ConfigState(updateVotersS1Entry.getConfigOld(), updateVotersS1Entry.getConfigNew()));
                isRecoveredFromJournal = true;
                break;
            }
            if (type != InternalEntryType.TYPE_UPDATE_VOTERS_S2) continue;
            UpdateVotersS2Entry updateVotersS2Entry = (UpdateVotersS2Entry)InternalEntriesSerializeSupport.parse(entry.getPayload().getBytes());
            this.state.setConfigState(new ConfigState(updateVotersS2Entry.getConfigNew()));
            isRecoveredFromJournal = true;
            break;
        }
        if (isRecoveredFromJournal) {
            logger.info("Voters config is recovered from journal.");
        } else {
            logger.info("No voters config entry found in journal, Using config in the metadata.");
        }
        logger.info(this.state.getConfigState().toString());
    }

    private void recoverJournal(Set<Integer> partitions, JournalSnapshot journalSnapshot, long commitIndex) throws IOException {
        this.journal.recover(this.journalPath(), commitIndex, journalSnapshot, this.properties);
        this.journal.rePartition(partitions);
    }

    private Path journalPath() {
        return this.workingDir();
    }

    private void recoverSnapshots() throws IOException {
        if (!Files.isDirectory(this.snapshotsPath(), new LinkOption[0])) {
            Files.createDirectories(this.snapshotsPath(), new FileAttribute[0]);
        }
        StreamSupport.stream(Files.newDirectoryStream(this.snapshotsPath(), entry -> entry.getFileName().toString().matches("\\d+")).spliterator(), false).map(path -> {
            JournalKeeperState snapshot = new JournalKeeperState(this.stateFactory, this.metadataPersistence);
            snapshot.recover((Path)path, this.properties, true);
            if (Long.parseLong(path.getFileName().toString()) == snapshot.lastApplied()) {
                return snapshot;
            }
            return null;
        }).filter(Objects::nonNull).peek(JournalKeeperState::close).forEach(snapshot -> this.snapshots.put(snapshot.lastApplied(), (JournalKeeperState)snapshot));
    }

    protected void onMetadataRecovered(ServerMetadata metadata) {
        this.uri = metadata.getThisServer();
    }

    protected ServerMetadata createServerMetadata() {
        ServerMetadata serverMetadata = new ServerMetadata();
        serverMetadata.setInitialized(true);
        serverMetadata.setThisServer(this.uri);
        serverMetadata.setCommitIndex(this.journal.commitIndex());
        return serverMetadata;
    }

    protected long randomInterval(long interval) {
        return interval + Math.round(ThreadLocalRandom.current().nextDouble(-0.5, 0.5) * (double)interval);
    }

    public CompletableFuture<GetServerEntriesResponse> getServerEntries(GetServerEntriesRequest request) {
        return CompletableFuture.supplyAsync(() -> new GetServerEntriesResponse(this.journal.readRaw(request.getIndex(), (int)Math.min((long)request.getMaxSize(), this.state.lastApplied() - request.getIndex())), this.journal.minIndex(), this.state.lastApplied()), this.asyncExecutor).exceptionally(e -> {
            try {
                throw e;
            }
            catch (CompletionException ce) {
                return new GetServerEntriesResponse(ce.getCause(), this.journal.minIndex(), this.state.lastApplied());
            }
            catch (Throwable throwable) {
                return new GetServerEntriesResponse(throwable, this.journal.minIndex(), this.state.lastApplied());
            }
        });
    }

    public CompletableFuture<ConvertRollResponse> convertRoll(ConvertRollRequest request) {
        throw new UnsupportedOperationException();
    }

    public StateServer.ServerState serverState() {
        return this.serverState;
    }

    protected long getRpcTimeoutMs() {
        return this.config.getRpcTimeoutMs();
    }

    public void compact(long indexExclusive) {
        Long index = this.snapshots.floorKey(indexExclusive);
        if (null != index) {
            logger.info("Request compact journal to {}, found a floor snapshot at index: {}.", (Object)indexExclusive, (Object)index);
            this.compactJournalToSnapshot(index);
        } else {
            logger.warn("Request compact journal to {}, no snapshot found which less than or equal {}, nothing to compact!", (Object)indexExclusive, (Object)indexExclusive);
        }
    }

    private void compactJournalPeriodically() {
        long index = this.journalCompactionStrategy.calculateCompactionIndex(this.snapshots.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JournalKeeperState)entry.getValue()).timestamp(), (v1, v2) -> {
            throw new RuntimeException(String.format("Duplicate key for values %s and %s", v1, v2));
        }, TreeMap::new)), this.journal);
        if (index > (Long)this.snapshots.firstKey()) {
            this.compactJournalToSnapshot(index);
        }
    }

    private void compactJournalToSnapshot(long index) {
        logger.info("Compact journal to index: {}...", (Object)index);
        try {
            JournalKeeperState snapshot = (JournalKeeperState)this.snapshots.get(index);
            if (null != snapshot) {
                JournalSnapshot journalSnapshot = snapshot.getJournalSnapshot();
                logger.info("Compact journal entries, journal snapshot: {}, journal: {}...", (Object)journalSnapshot, (Object)this.journal);
                this.journal.compact(snapshot.getJournalSnapshot());
                logger.info("Compact journal finished, journal: {}.", (Object)this.journal);
                NavigableMap<Long, JournalKeeperState> headMap = this.snapshots.headMap(index, false);
                while (!headMap.isEmpty()) {
                    snapshot = (JournalKeeperState)headMap.remove(headMap.firstKey());
                    logger.info("Discard snapshot: {}.", (Object)snapshot.getPath());
                    snapshot.close();
                    snapshot.clear();
                }
            } else {
                logger.warn("Compact journal failed! Cause no snapshot at index: {}.", (Object)index);
            }
        }
        catch (Throwable e) {
            logger.warn("Compact journal exception!", e);
        }
    }

    public JournalKeeperState getState() {
        return this.state;
    }

    @Override
    public JMetric getMetric(String name) {
        if (this.config.isEnableMetric()) {
            return this.metricMap.computeIfAbsent(name, arg_0 -> ((JMetricFactory)this.metricFactory).create(arg_0));
        }
        return DUMMY_METRIC;
    }

    @Override
    public boolean isMetricEnabled() {
        return this.config.isEnableMetric();
    }

    @Override
    public void removeMetric(String name) {
        if (this.config.isEnableMetric()) {
            this.metricMap.remove(name);
        }
    }

    private void printMetrics() {
        this.metricMap.values().stream().map(JMetric::getAndReset).map(JMetricSupport::formatNs).forEach(arg_0 -> ((Logger)logger).info(arg_0));
        this.onPrintMetric();
    }

    URI getLeaderUri() {
        return this.leaderUri;
    }

    Journal getJournal() {
        return this.journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void installSnapshot(long offset, long lastIncludedIndex, int lastIncludedTerm, byte[] data, boolean isDone) throws IOException, TimeoutException {
        PartialSnapshot partialSnapshot = this.partialSnapshot;
        synchronized (partialSnapshot) {
            logger.debug("Install snapshot, offset: {}, lastIncludedIndex: {}, lastIncludedTerm: {}, data length: {}, isDone: {}... journal minIndex: {}, maxIndex: {}, commitIndex: {}...", new Object[]{ThreadSafeFormat.formatWithComma((long)offset), ThreadSafeFormat.formatWithComma((long)lastIncludedIndex), lastIncludedTerm, data.length, isDone, ThreadSafeFormat.formatWithComma((long)this.journal.minIndex()), ThreadSafeFormat.formatWithComma((long)this.journal.maxIndex()), ThreadSafeFormat.formatWithComma((long)this.journal.commitIndex())});
            long lastApplied = lastIncludedIndex + 1L;
            Path snapshotPath = this.snapshotsPath().resolve(String.valueOf(lastApplied));
            this.partialSnapshot.installTrunk(offset, data, snapshotPath);
            if (isDone) {
                JournalKeeperState snapshot;
                logger.debug("All snapshot files received, discard any existing snapshot with a same or smaller index...");
                NavigableMap<Long, JournalKeeperState> headMap = this.snapshots.headMap(lastApplied, true);
                while (!headMap.isEmpty()) {
                    snapshot = (JournalKeeperState)headMap.remove(headMap.firstKey());
                    logger.info("Discard snapshot: {}.", (Object)snapshot.getPath());
                    snapshot.close();
                    snapshot.clear();
                }
                logger.debug("add the installed snapshot to snapshots: {}...", (Object)snapshotPath);
                this.partialSnapshot.finish();
                snapshot = new JournalKeeperState(this.stateFactory, this.metadataPersistence);
                snapshot.recover(snapshotPath, this.properties);
                this.snapshots.put(lastApplied, snapshot);
                logger.debug("New installed snapshot: {}.", (Object)snapshot.getJournalSnapshot());
                logger.debug("Compact journal entries, journal: {}...", (Object)this.journal);
                this.threads.stopThread(this.threadName("FlushJournalThread"));
                try {
                    if (this.journal.minIndex() >= lastIncludedIndex && lastIncludedIndex < this.journal.maxIndex() && this.journal.getTerm(lastIncludedIndex) == lastIncludedTerm) {
                        this.journal.compact(snapshot.getJournalSnapshot());
                    } else {
                        this.journal.clear(snapshot.getJournalSnapshot());
                    }
                }
                finally {
                    this.threads.startThread(this.threadName("FlushJournalThread"));
                }
                logger.debug("Compact journal finished, journal: {}.", (Object)this.journal);
                logger.debug("Use the new installed snapshot as server's state...");
                this.stopAndWaitScheduledFeature(this.flushStateFuture, 1000L);
                this.threads.stopThread(this.threadName("StateMachineThread"));
                try {
                    this.state.close();
                    this.state.clear();
                    snapshot.dump(this.statePath());
                    this.state.recover(this.statePath(), this.properties);
                }
                finally {
                    this.threads.startThread(this.threadName("StateMachineThread"));
                    this.flushStateFuture = this.scheduledExecutor.scheduleAtFixedRate(this::flushState, ThreadLocalRandom.current().nextLong(10L, 50L), this.config.getFlushIntervalMs(), TimeUnit.MILLISECONDS);
                }
                logger.debug("Install snapshot successfully!");
            }
        }
    }

    String threadName(String staticThreadName) {
        return this.serverUri() + "-" + staticThreadName;
    }

    protected void onPrintMetric() {
    }

    public static class Config {
        public static final int DEFAULT_SNAPSHOT_INTERVAL_SEC = 0;
        public static final long DEFAULT_RPC_TIMEOUT_MS = 1000L;
        public static final long DEFAULT_FLUSH_INTERVAL_MS = 50L;
        public static final int DEFAULT_GET_STATE_BATCH_SIZE = 0x100000;
        public static final boolean DEFAULT_ENABLE_METRIC = false;
        public static final boolean DEFAULT_DISABLE_LOGO = false;
        public static final int DEFAULT_PRINT_METRIC_INTERVAL_SEC = 0;
        public static final int DEFAULT_JOURNAL_RETENTION_MIN = 0;
        public static final boolean DEFAULT_ENABLE_EVENTS = true;
        public static final String SNAPSHOT_INTERVAL_SEC_KEY = "snapshot_interval_sec";
        public static final String RPC_TIMEOUT_MS_KEY = "rpc_timeout_ms";
        public static final String FLUSH_INTERVAL_MS_KEY = "flush_interval_ms";
        public static final String WORKING_DIR_KEY = "working_dir";
        public static final String GET_STATE_BATCH_SIZE_KEY = "get_state_batch_size";
        public static final String ENABLE_METRIC_KEY = "enable_metric";
        public static final String DISABLE_LOGO_KEY = "disable_logo";
        public static final String PRINT_METRIC_INTERVAL_SEC_KEY = "print_metric_interval_sec";
        public static final String JOURNAL_RETENTION_MIN_KEY = "journal_retention_min";
        public static final String ENABLE_EVENTS_KEY = "enable_events";
        private int snapshotIntervalSec = 0;
        private long rpcTimeoutMs = 1000L;
        private long flushIntervalMs = 50L;
        private Path workingDir = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("journalkeeper");
        private int getStateBatchSize = 0x100000;
        private boolean enableMetric = false;
        private boolean disableLogo = false;
        private int printMetricIntervalSec = 0;
        private int journalRetentionMin = 0;
        private boolean enableEvents = true;

        int getSnapshotIntervalSec() {
            return this.snapshotIntervalSec;
        }

        void setSnapshotIntervalSec(int snapshotIntervalSec) {
            this.snapshotIntervalSec = snapshotIntervalSec;
        }

        long getRpcTimeoutMs() {
            return this.rpcTimeoutMs;
        }

        void setRpcTimeoutMs(long rpcTimeoutMs) {
            this.rpcTimeoutMs = rpcTimeoutMs;
        }

        public long getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public void setFlushIntervalMs(long flushIntervalMs) {
            this.flushIntervalMs = flushIntervalMs;
        }

        public Path getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(Path workingDir) {
            this.workingDir = workingDir;
        }

        public int getGetStateBatchSize() {
            return this.getStateBatchSize;
        }

        public void setGetStateBatchSize(int getStateBatchSize) {
            this.getStateBatchSize = getStateBatchSize;
        }

        public boolean isEnableMetric() {
            return this.enableMetric;
        }

        public void setEnableMetric(boolean enableMetric) {
            this.enableMetric = enableMetric;
        }

        public int getPrintMetricIntervalSec() {
            return this.printMetricIntervalSec;
        }

        public void setPrintMetricIntervalSec(int printMetricIntervalSec) {
            this.printMetricIntervalSec = printMetricIntervalSec;
        }

        public int getJournalRetentionMin() {
            return this.journalRetentionMin;
        }

        public void setJournalRetentionMin(int journalRetentionMin) {
            this.journalRetentionMin = journalRetentionMin;
        }

        public boolean isDisableLogo() {
            return this.disableLogo;
        }

        public void setDisableLogo(boolean disableLogo) {
            this.disableLogo = disableLogo;
        }

        public boolean isEnableEvents() {
            return this.enableEvents;
        }

        public void setEnableEvents(boolean enableEvents) {
            this.enableEvents = enableEvents;
        }
    }
}

