/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.VoterState;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.server.VoterConfigManager;
import io.journalkeeper.core.state.JournalKeeperState;
import io.journalkeeper.exceptions.IndexUnderflowException;
import io.journalkeeper.rpc.server.AsyncAppendEntriesRequest;
import io.journalkeeper.rpc.server.AsyncAppendEntriesResponse;
import io.journalkeeper.utils.state.ServerStateMachine;
import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.Threads;
import java.net.URI;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Follower
extends ServerStateMachine
implements StateServer {
    private static final Logger logger = LoggerFactory.getLogger(Follower.class);
    protected final JournalKeeperState state;
    private final Journal journal;
    private final URI serverUri;
    private final int currentTerm;
    private final VoterConfigManager voterConfigManager;
    private final Threads threads;
    private final NavigableMap<Long, JournalKeeperState> snapshots;
    private long leaderMaxIndex = -1L;
    private boolean readyForStartPreferredLeaderElection = false;

    Follower(Journal journal, JournalKeeperState state, URI serverUri, int currentTerm, VoterConfigManager voterConfigManager, Threads threads, NavigableMap<Long, JournalKeeperState> snapshots, int cachedRequests) {
        super(true);
        this.state = state;
        this.voterConfigManager = voterConfigManager;
        this.threads = threads;
        this.snapshots = snapshots;
        this.journal = journal;
        this.serverUri = serverUri;
        this.currentTerm = currentTerm;
    }

    private String threadName(String staticThreadName) {
        return this.serverUri + "-" + staticThreadName;
    }

    private String voterInfo() {
        return String.format("voterState: %s, currentTerm: %d, minIndex: %d, maxIndex: %d, commitIndex: %d, lastApplied: %d, uri: %s", VoterState.LEADER, this.currentTerm, this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex(), this.state.lastApplied(), this.serverUri.toString());
    }

    private int getTerm(long index) {
        try {
            return this.journal.getTerm(index);
        }
        catch (IndexUnderflowException e) {
            if (index + 1L == (Long)this.snapshots.firstKey()) {
                return this.snapshots.firstEntry().getValue().lastIncludedTerm();
            }
            throw e;
        }
    }

    AsyncAppendEntriesResponse handleAppendEntriesRequest(AsyncAppendEntriesRequest request) {
        boolean notHeartBeat;
        boolean bl = notHeartBeat = null != request.getEntries() && request.getEntries().size() > 0;
        if (notHeartBeat && (request.getPrevLogIndex() < this.journal.minIndex() - 1L || request.getPrevLogIndex() >= this.journal.maxIndex() || this.getTerm(request.getPrevLogIndex()) != request.getPrevLogTerm())) {
            return new AsyncAppendEntriesResponse(false, request.getPrevLogIndex() + 1L, request.getTerm(), request.getEntries().size());
        }
        try {
            if (notHeartBeat) {
                long startIndex = request.getPrevLogIndex() + 1L;
                this.voterConfigManager.maybeRollbackConfig(startIndex, this.journal, this.state.getConfigState());
                this.journal.compareOrAppendRaw(request.getEntries(), startIndex);
                this.voterConfigManager.maybeUpdateNonLeaderConfig(request.getEntries(), this.state.getConfigState());
            }
            if (request.getLeaderCommit() > this.journal.commitIndex()) {
                this.journal.commit(Math.min(request.getLeaderCommit(), this.journal.maxIndex()));
                this.threads.wakeupThread(this.threadName("StateMachineThread"));
            }
            if (this.leaderMaxIndex < request.getMaxIndex()) {
                this.leaderMaxIndex = request.getMaxIndex();
            }
            return new AsyncAppendEntriesResponse(true, request.getPrevLogIndex() + 1L, this.currentTerm, request.getEntries().size());
        }
        catch (Throwable t) {
            logger.warn("Exception when handle AsyncReplicationRequest, term: {}, leader: {}, prevLogIndex: {}, prevLogTerm: {}, entries: {}, leaderCommits: {}, {}.", new Object[]{request.getTerm(), request.getLeader(), request.getPrevLogIndex(), request.getPrevLogTerm(), request.getEntries().size(), request.getLeaderCommit(), this.voterInfo(), t});
            return new AsyncAppendEntriesResponse(t);
        }
    }

    long getLeaderMaxIndex() {
        return this.leaderMaxIndex;
    }

    protected void doStart() {
        super.doStart();
    }

    protected void doStop() {
        super.doStop();
    }

    public boolean isReadyForStartPreferredLeaderElection() {
        return this.readyForStartPreferredLeaderElection;
    }

    public void setReadyForStartPreferredLeaderElection(boolean readyForStartPreferredLeaderElection) {
        this.readyForStartPreferredLeaderElection = readyForStartPreferredLeaderElection;
    }
}

