/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.base.ReplicableIterator;
import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.VoterState;
import io.journalkeeper.core.api.transaction.JournalKeeperTransactionContext;
import io.journalkeeper.core.entry.internal.CreateSnapshotEntry;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.LeaderAnnouncementEntry;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.server.Callback;
import io.journalkeeper.core.server.CallbackResultBelt;
import io.journalkeeper.core.server.DefaultExceptionListener;
import io.journalkeeper.core.server.MetricNames;
import io.journalkeeper.core.server.MetricProvider;
import io.journalkeeper.core.server.ResponseFuture;
import io.journalkeeper.core.server.RingBufferBelt;
import io.journalkeeper.core.server.ServerRpcProvider;
import io.journalkeeper.core.server.VoterConfigManager;
import io.journalkeeper.core.state.ApplyInternalEntryInterceptor;
import io.journalkeeper.core.state.ApplyReservedEntryInterceptor;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.core.state.JournalKeeperState;
import io.journalkeeper.core.transaction.JournalTransactionManager;
import io.journalkeeper.exceptions.IndexUnderflowException;
import io.journalkeeper.exceptions.NotLeaderException;
import io.journalkeeper.metric.JMetric;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.rpc.server.AsyncAppendEntriesRequest;
import io.journalkeeper.rpc.server.AsyncAppendEntriesResponse;
import io.journalkeeper.rpc.server.InstallSnapshotRequest;
import io.journalkeeper.rpc.server.InstallSnapshotResponse;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.utils.async.Async;
import io.journalkeeper.utils.state.ServerStateMachine;
import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.ExceptionListener;
import io.journalkeeper.utils.threads.ThreadBuilder;
import io.journalkeeper.utils.threads.Threads;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Leader
extends ServerStateMachine
implements StateServer {
    private static final Logger logger = LoggerFactory.getLogger(Leader.class);
    protected final JournalKeeperState state;
    private final BlockingQueue<UpdateStateRequestResponse> pendingUpdateStateRequests;
    private final CallbackResultBelt replicationCallbacks;
    private final CallbackResultBelt flushCallbacks;
    private final List<ReplicationDestination> followers = new CopyOnWriteArrayList<ReplicationDestination>();
    private final AtomicLong journalFlushIndex = new AtomicLong(0L);
    private final Threads threads;
    private final long heartbeatIntervalMs;
    private final int replicationBatchSize;
    private final long rpcTimeoutMs;
    private final Journal journal;
    private final Map<Long, JournalKeeperState> immutableSnapshots;
    private final URI serverUri;
    private final int currentTerm;
    private final Map<URI, JMetric> appendEntriesRpcMetricMap;
    private final ServerRpcProvider serverRpcProvider;
    private final ScheduledExecutorService scheduledExecutor;
    private final VoterConfigManager voterConfigManager;
    private final MetricProvider metricProvider;
    private final AtomicBoolean writeEnabled = new AtomicBoolean(true);
    private final JournalEntryParser journalEntryParser;
    private final JournalTransactionManager journalTransactionManager;
    private final ApplyReservedEntryInterceptor journalTransactionInterceptor;
    private final ApplyInternalEntryInterceptor leaderAnnouncementInterceptor;
    private final NavigableMap<Long, JournalKeeperState> snapshots;
    private final int snapshotIntervalSec;
    private final AtomicBoolean isLeaderAnnouncementApplied = new AtomicBoolean(false);
    private final AtomicLong callbackBarrier = new AtomicLong(0L);
    private AtomicLong leaderShipDeadLineMs = new AtomicLong(0L);
    private JMetric updateClusterStateMetric;
    private JMetric appendJournalMetric;
    private ScheduledFuture takeSnapshotFuture;
    private AtomicBoolean isAnyFollowerNextIndexUpdated = new AtomicBoolean(false);

    Leader(Journal journal, JournalKeeperState state, Map<Long, JournalKeeperState> immutableSnapshots, int currentTerm, URI serverUri, int cacheRequests, long heartbeatIntervalMs, long rpcTimeoutMs, int replicationBatchSize, int snapshotIntervalSec, Threads threads, ServerRpcProvider serverRpcProvider, ClientServerRpc server, ScheduledExecutorService scheduledExecutor, VoterConfigManager voterConfigManager, MetricProvider metricProvider, JournalEntryParser journalEntryParser, long transactionTimeoutMs, NavigableMap<Long, JournalKeeperState> snapshots) {
        super(true);
        this.pendingUpdateStateRequests = new LinkedBlockingQueue<UpdateStateRequestResponse>(cacheRequests);
        this.state = state;
        this.serverUri = serverUri;
        this.replicationBatchSize = replicationBatchSize;
        this.rpcTimeoutMs = rpcTimeoutMs;
        this.currentTerm = currentTerm;
        this.immutableSnapshots = immutableSnapshots;
        this.snapshotIntervalSec = snapshotIntervalSec;
        this.threads = threads;
        this.serverRpcProvider = serverRpcProvider;
        this.scheduledExecutor = scheduledExecutor;
        this.voterConfigManager = voterConfigManager;
        this.metricProvider = metricProvider;
        this.journalEntryParser = journalEntryParser;
        this.snapshots = snapshots;
        this.replicationCallbacks = new RingBufferBelt(rpcTimeoutMs, cacheRequests);
        this.flushCallbacks = new RingBufferBelt(rpcTimeoutMs, cacheRequests);
        this.appendEntriesRpcMetricMap = new HashMap<URI, JMetric>(2);
        this.journal = journal;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.journalTransactionManager = new JournalTransactionManager(journal, server, scheduledExecutor, transactionTimeoutMs);
        this.journalTransactionInterceptor = (entryHeader, entryFuture, index) -> this.journalTransactionManager.applyEntry(entryHeader, entryFuture);
        this.leaderAnnouncementInterceptor = (type, internalEntry) -> {
            LeaderAnnouncementEntry leaderAnnouncementEntry;
            if (type == InternalEntryType.TYPE_LEADER_ANNOUNCEMENT && (leaderAnnouncementEntry = (LeaderAnnouncementEntry)InternalEntriesSerializeSupport.parse(internalEntry)).getTerm() == currentTerm) {
                logger.info("Leader announcement applied! Leader: {}, term: {}.", (Object)serverUri, (Object)currentTerm);
                this.isLeaderAnnouncementApplied.compareAndSet(false, true);
            }
        };
        this.callbackBarrier.set(journal.maxIndex());
    }

    private AsyncLoopThread buildLeaderAppendJournalEntryThread() {
        return ThreadBuilder.builder().name(this.threadName("LeaderAppendEntryThread")).doWork(this::appendJournalEntry).sleepTime(0L, 0L).onException((ExceptionListener)new DefaultExceptionListener("LeaderAppendEntryThread")).daemon(true).build();
    }

    private AsyncLoopThread buildLeaderReplicationResponseThread() {
        return ThreadBuilder.builder().name(this.threadName("leaderCommitThread")).doWork(this::commit).sleepTime(this.heartbeatIntervalMs, this.heartbeatIntervalMs).onException((ExceptionListener)new DefaultExceptionListener("leaderCommitThread")).daemon(true).build();
    }

    private AsyncLoopThread buildCallbackThread() {
        return ThreadBuilder.builder().name(this.threadName("LeaderCallbackThread")).doWork(this::callback).sleepTime(this.heartbeatIntervalMs, this.heartbeatIntervalMs).onException((ExceptionListener)new DefaultExceptionListener("LeaderCallbackThread")).daemon(true).build();
    }

    private String threadName(String staticThreadName) {
        return this.serverUri + "-" + staticThreadName;
    }

    private void appendJournalEntry() throws Exception {
        UpdateStateRequestResponse rr = this.pendingUpdateStateRequests.take();
        UpdateClusterStateRequest request = rr.getRequest();
        ResponseFuture responseFuture = rr.getResponseFuture();
        try {
            if (request.getRequests().size() == 1 && this.voterConfigManager.maybeUpdateLeaderConfig((UpdateRequest)request.getRequests().get(0), this.state.getConfigState(), this.journal, () -> this.doAppendJournalEntryCallable(request, responseFuture), this.serverUri, this)) {
                return;
            }
            this.doAppendJournalEntry(request, responseFuture);
        }
        catch (Throwable t) {
            responseFuture.getResponseFuture().complete(new UpdateClusterStateResponse(t));
            throw t;
        }
    }

    private Void doAppendJournalEntryCallable(UpdateClusterStateRequest request, ResponseFuture responseFuture) throws InterruptedException {
        this.doAppendJournalEntry(request, responseFuture);
        return null;
    }

    private void doAppendJournalEntry(UpdateClusterStateRequest request, ResponseFuture responseFuture) throws InterruptedException {
        this.appendJournalMetric.start();
        ArrayList<JournalEntry> journalEntries = new ArrayList<JournalEntry>(request.getRequests().size());
        for (UpdateRequest serializedUpdateRequest : request.getRequests()) {
            JournalEntry entry = request.isIncludeHeader() ? this.journalEntryParser.parse(serializedUpdateRequest.getEntry()) : this.journalEntryParser.createJournalEntry(serializedUpdateRequest.getEntry());
            entry.setPartition(serializedUpdateRequest.getPartition());
            entry.setBatchSize(serializedUpdateRequest.getBatchSize());
            entry.setTerm(this.currentTerm);
            if (request.getTransactionId() != null) {
                entry = this.journalTransactionManager.wrapTransactionalEntry(entry, request.getTransactionId(), this.journalEntryParser);
            }
            journalEntries.add(entry);
        }
        this.appendAndCallback(journalEntries, request.getResponseConfig(), responseFuture);
        this.wakeupReplicationThreads();
        this.threads.wakeupThread(this.threadName("FlushJournalThread"));
        this.appendJournalMetric.end(() -> journalEntries.stream().mapToLong(JournalEntry::getLength).sum());
    }

    private void wakeupReplicationThreads() {
        for (ReplicationDestination follower : this.followers) {
            try {
                this.threads.wakeupThread(follower.getReplicationThreadName());
            }
            catch (NoSuchElementException e) {
                logger.warn("Wake up {} failed, follower {} maybe removed.", (Object)follower.getReplicationThreadName(), (Object)follower.getUri());
            }
        }
        if (this.followers.isEmpty()) {
            this.threads.wakeupThread(this.threadName("leaderCommitThread"));
        }
    }

    private void appendAndCallback(List<JournalEntry> journalEntries, ResponseConfig responseConfig, ResponseFuture responseFuture) throws InterruptedException {
        if (journalEntries.size() == 1) {
            long offset = this.journal.append(journalEntries.get(0));
            this.setCallback(responseConfig, responseFuture, offset);
        } else {
            List<Long> offsets = this.journal.append(journalEntries);
            for (Long offset : offsets) {
                this.setCallback(responseConfig, responseFuture, offset);
            }
        }
    }

    private void setCallback(ResponseConfig responseConfig, ResponseFuture responseFuture, long offset) throws InterruptedException {
        if (responseConfig == ResponseConfig.REPLICATION) {
            this.replicationCallbacks.put(new Callback(offset, responseFuture));
        } else if (responseConfig == ResponseConfig.PERSISTENCE) {
            this.flushCallbacks.put(new Callback(offset, responseFuture));
        } else if (responseConfig == ResponseConfig.ALL) {
            this.replicationCallbacks.put(new Callback(offset, responseFuture));
            this.flushCallbacks.put(new Callback(offset, responseFuture));
        }
        this.callbackBarrier.set(offset);
    }

    private int getPreLogTerm(long currentLogIndex) {
        if (currentLogIndex > this.journal.minIndex()) {
            return this.journal.getTerm(currentLogIndex - 1L);
        }
        if (currentLogIndex == this.journal.minIndex() && this.immutableSnapshots.containsKey(currentLogIndex)) {
            return this.immutableSnapshots.get(currentLogIndex).lastIncludedTerm();
        }
        if (currentLogIndex == 0L) {
            return -1;
        }
        throw new IndexUnderflowException();
    }

    private void commit() throws IOException {
        while (this.serverState() == StateServer.ServerState.RUNNING && !Thread.currentThread().isInterrupted() && this.journal.commitIndex() < this.journal.maxIndex() && (this.followers.isEmpty() || this.isAnyFollowerNextIndexUpdated.get())) {
            ConfigState configState = this.state.getConfigState();
            ArrayList<ReplicationDestination> finalFollowers = new ArrayList<ReplicationDestination>(this.followers);
            long N = 0L;
            if (finalFollowers.isEmpty()) {
                N = this.journal.maxIndex();
            } else if (this.isAnyFollowerNextIndexUpdated.compareAndSet(true, false)) {
                if (configState.isJointConsensus()) {
                    long[] sortedMatchIndexInOldConfig = finalFollowers.stream().filter(follower -> configState.getConfigOld().contains(follower.getUri())).mapToLong(ReplicationDestination::getMatchIndex).sorted().toArray();
                    long nInOldConfig = sortedMatchIndexInOldConfig.length > 0 ? sortedMatchIndexInOldConfig[sortedMatchIndexInOldConfig.length / 2] : this.journal.maxIndex();
                    long[] sortedMatchIndexInNewConfig = finalFollowers.stream().filter(follower -> configState.getConfigNew().contains(follower.getUri())).mapToLong(ReplicationDestination::getMatchIndex).sorted().toArray();
                    long nInNewConfig = sortedMatchIndexInNewConfig.length > 0 ? sortedMatchIndexInNewConfig[sortedMatchIndexInNewConfig.length / 2] : this.journal.maxIndex();
                    N = Math.min(nInNewConfig, nInOldConfig);
                } else {
                    long[] sortedMatchIndex = finalFollowers.stream().mapToLong(ReplicationDestination::getMatchIndex).sorted().toArray();
                    if (sortedMatchIndex.length > 0) {
                        N = sortedMatchIndex[sortedMatchIndex.length / 2];
                    }
                }
            }
            if (N <= this.journal.commitIndex() || this.getTerm(N - 1L) != this.currentTerm) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Set commitIndex {} to {}, {}.", new Object[]{this.journal.commitIndex(), N, this.voterInfo()});
            }
            this.journal.commit(N);
            this.onCommitted();
        }
    }

    private void onCommitted() {
        this.threads.wakeupThread(this.threadName("StateMachineThread"));
        this.wakeupReplicationThreads();
    }

    private int getTerm(long index) {
        try {
            return this.journal.getTerm(index);
        }
        catch (IndexUnderflowException e) {
            if (index + 1L == (Long)this.snapshots.firstKey()) {
                return this.snapshots.firstEntry().getValue().lastIncludedTerm();
            }
            throw e;
        }
    }

    private void installSnapshot(ReplicationDestination follower, JournalKeeperState snapshot) {
        try {
            logger.info("Install snapshot to {} ...", (Object)follower.getUri());
            ServerRpc rpc = this.serverRpcProvider.getServerRpc(follower.getUri()).get(this.heartbeatIntervalMs, TimeUnit.MILLISECONDS);
            int offset = 0;
            ReplicableIterator iterator = snapshot.iterator();
            while (iterator.hasMoreTrunks()) {
                byte[] trunk = iterator.nextTrunk();
                InstallSnapshotRequest request = new InstallSnapshotRequest(this.currentTerm, this.serverUri, snapshot.lastIncludedIndex(), snapshot.lastIncludedTerm(), offset, trunk, !iterator.hasMoreTrunks());
                InstallSnapshotResponse response = (InstallSnapshotResponse)rpc.installSnapshot(request).get();
                if (!response.success()) {
                    logger.warn("Install snapshot to {} failed! Cause: {}.", (Object)follower.getUri(), (Object)response.errorString());
                    return;
                }
                offset += trunk.length;
            }
            logger.info("Install snapshot to {} success!", (Object)follower.getUri());
        }
        catch (Throwable t) {
            logger.warn("Install snapshot to {} failed!", (Object)follower.getUri(), (Object)t);
        }
    }

    private void callback() {
        long callbackIndex = this.journalFlushIndex.get();
        if (callbackIndex > this.callbackBarrier.get()) {
            this.flushCallbacks.callbackBefore(this.callbackBarrier.get());
        }
        while (callbackIndex > this.callbackBarrier.get()) {
            Thread.yield();
        }
        this.flushCallbacks.callbackBefore(callbackIndex);
    }

    private String voterInfo() {
        return String.format("voterState: %s, currentTerm: %d, minIndex: %d, maxIndex: %d, commitIndex: %d, lastApplied: %d, uri: %s", VoterState.LEADER, this.currentTerm, this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex(), this.state.lastApplied(), this.serverUri.toString());
    }

    CompletableFuture<UpdateClusterStateResponse> updateClusterState(UpdateClusterStateRequest request) {
        UpdateStateRequestResponse requestResponse = new UpdateStateRequestResponse(request, this.updateClusterStateMetric);
        try {
            if (this.serverState() != StateServer.ServerState.RUNNING) {
                throw new IllegalStateException(String.format("Leader is not RUNNING, state: %s.", this.serverState().toString()));
            }
            if (!this.writeEnabled.get()) {
                throw new IllegalStateException("Server disabled temporarily.");
            }
            this.pendingUpdateStateRequests.put(requestResponse);
            if (request.getResponseConfig() == ResponseConfig.RECEIVE) {
                requestResponse.getResponseFuture().getResponseFuture().complete(new UpdateClusterStateResponse());
            }
        }
        catch (Throwable e) {
            requestResponse.getResponseFuture().getResponseFuture().complete(new UpdateClusterStateResponse(e));
        }
        return requestResponse.getResponseFuture().getResponseFuture();
    }

    void disableWrite(long timeoutMs, int term) {
        if (this.currentTerm != term) {
            throw new IllegalStateException(String.format("Term not matched! Term in leader: %d, term in request: %d", this.currentTerm, term));
        }
        this.writeEnabled.set(false);
        this.scheduledExecutor.schedule(() -> this.writeEnabled.set(true), timeoutMs, TimeUnit.MILLISECONDS);
    }

    protected void doStart() {
        super.doStart();
        this.followers.addAll(this.state.getConfigState().voters().stream().filter(uri -> !uri.equals(this.serverUri)).map(uri -> new ReplicationDestination((URI)uri, this.journal.maxIndex())).collect(Collectors.toList()));
        this.followers.forEach(follower -> this.appendEntriesRpcMetricMap.put(follower.getUri(), this.metricProvider.getMetric(MetricNames.compose("APPEND_ENTRIES_RPC", follower.getUri()))));
        this.appendJournalMetric = this.metricProvider.getMetric("APPEND_JOURNAL");
        this.updateClusterStateMetric = this.metricProvider.getMetric("UPDATE_CLUSTER_STATE");
        this.threads.createThread(this.buildLeaderAppendJournalEntryThread());
        this.threads.createThread(this.buildLeaderReplicationResponseThread());
        this.threads.createThread(this.buildCallbackThread());
        this.threads.startThread(this.threadName("leaderCommitThread"));
        this.followers.forEach(rec$ -> ((ReplicationDestination)rec$).start());
        this.threads.startThread(this.threadName("LeaderCallbackThread"));
        this.threads.startThread(this.threadName("LeaderAppendEntryThread"));
        this.journalTransactionManager.start();
        this.state.addInterceptor(this.journalTransactionInterceptor);
        this.state.addInterceptor(InternalEntryType.TYPE_LEADER_ANNOUNCEMENT, this.leaderAnnouncementInterceptor);
        if (this.snapshotIntervalSec > 0) {
            this.takeSnapshotFuture = this.scheduledExecutor.scheduleAtFixedRate(this::takeSnapshotPeriodically, ThreadLocalRandom.current().nextLong(0L, this.snapshotIntervalSec), this.snapshotIntervalSec, TimeUnit.SECONDS);
        }
        this.appendLeaderAnnouncementEntry();
    }

    private void appendLeaderAnnouncementEntry() {
        try {
            byte[] payload = InternalEntriesSerializeSupport.serialize(new LeaderAnnouncementEntry(this.currentTerm, this.serverUri));
            JournalEntry journalEntry = this.journalEntryParser.createJournalEntry(payload);
            journalEntry.setTerm(this.currentTerm);
            journalEntry.setPartition(Short.MAX_VALUE);
            this.appendAndCallback(Collections.singletonList(journalEntry), null, null);
        }
        catch (InterruptedException e) {
            logger.warn("Exception: ", (Throwable)e);
        }
    }

    private void takeSnapshotPeriodically() {
        if (this.state.lastApplied() > (Long)this.snapshots.lastKey()) {
            logger.info("Send create snapshot request.");
            this.updateClusterState(new UpdateClusterStateRequest(new UpdateRequest(InternalEntriesSerializeSupport.serialize(new CreateSnapshotEntry()), Short.MAX_VALUE, 1)));
        } else {
            logger.info("No entry since last snapshot, no need to create a new snapshot.");
        }
    }

    protected void doStop() {
        this.mayBeWaitingForAppendJournals();
        if (this.takeSnapshotFuture != null) {
            this.takeSnapshotFuture.cancel(true);
        }
        this.state.removeInterceptor(InternalEntryType.TYPE_LEADER_ANNOUNCEMENT, this.leaderAnnouncementInterceptor);
        this.state.removeInterceptor(this.journalTransactionInterceptor);
        this.journalTransactionManager.stop();
        this.threads.stopThread(this.threadName("LeaderAppendEntryThread"));
        this.followers.forEach(rec$ -> ((ReplicationDestination)rec$).stop());
        this.threads.stopThread(this.threadName("LeaderCallbackThread"));
        this.failAllPendingCallbacks();
        this.threads.stopThread(this.threadName("leaderCommitThread"));
        this.threads.removeThread(this.threadName("LeaderAppendEntryThread"));
        this.threads.removeThread(this.threadName("LeaderCallbackThread"));
        this.threads.removeThread(this.threadName("leaderCommitThread"));
        this.removeAppendEntriesRpcMetrics();
        this.metricProvider.removeMetric("APPEND_JOURNAL");
        this.metricProvider.removeMetric("UPDATE_CLUSTER_STATE");
        super.doStop();
    }

    private void mayBeWaitingForAppendJournals() {
        while (!this.pendingUpdateStateRequests.isEmpty()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void failAllPendingCallbacks() {
        this.replicationCallbacks.failAll();
        this.flushCallbacks.failAll();
    }

    private void removeAppendEntriesRpcMetrics() {
        this.appendEntriesRpcMetricMap.forEach((followerUri, metric) -> this.metricProvider.removeMetric(MetricNames.compose("APPEND_ENTRIES_RPC", followerUri)));
    }

    void callback(long lastApplied, byte[] result) {
        while (lastApplied > this.callbackBarrier.get()) {
            Thread.yield();
        }
        this.replicationCallbacks.callback(lastApplied, result);
    }

    void onJournalFlushed() {
        this.journalFlushIndex.set(this.journal.maxIndex());
        if (this.serverState() == StateServer.ServerState.RUNNING) {
            this.threads.wakeupThread(this.threadName("LeaderAppendEntryThread"));
            this.threads.wakeupThread(this.threadName("LeaderCallbackThread"));
        }
    }

    CompletableFuture<Void> waitLeadership() {
        return this.waitLeadership(System.currentTimeMillis() + this.rpcTimeoutMs);
    }

    private CompletableFuture<Void> waitLeadership(long deadLineTimestamp) {
        if (System.currentTimeMillis() > deadLineTimestamp) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally((Throwable)new NotLeaderException(null));
            return future;
        }
        if (this.checkLeadership()) {
            return CompletableFuture.completedFuture(null);
        }
        return Async.scheduleAsync((ScheduledExecutorService)this.scheduledExecutor, () -> this.waitLeadership(deadLineTimestamp), (long)(this.heartbeatIntervalMs / 10L), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private boolean checkLeadership() {
        if (!this.isLeaderAnnouncementApplied.get()) {
            return false;
        }
        if (this.followers.isEmpty()) {
            return true;
        }
        if (System.currentTimeMillis() <= this.leaderShipDeadLineMs.get()) {
            return true;
        }
        long[] sortedHeartbeatResponseTimes = this.followers.stream().mapToLong(ReplicationDestination::getLastHeartbeatResponseTime).sorted().toArray();
        this.leaderShipDeadLineMs.set(sortedHeartbeatResponseTimes[sortedHeartbeatResponseTimes.length / 2] + this.heartbeatIntervalMs);
        return System.currentTimeMillis() <= this.leaderShipDeadLineMs.get();
    }

    CompletableFuture<JournalKeeperTransactionContext> createTransaction(Map<String, String> context) {
        return this.journalTransactionManager.createTransaction(context);
    }

    CompletableFuture<Void> completeTransaction(UUID transactionId, boolean commitOrAbort) {
        return this.journalTransactionManager.completeTransaction(transactionId, commitOrAbort);
    }

    Collection<JournalKeeperTransactionContext> getOpeningTransactions() {
        return this.journalTransactionManager.getOpeningTransactions();
    }

    int getRequestQueueSize() {
        return this.pendingUpdateStateRequests.size();
    }

    boolean isWriteEnabled() {
        return this.writeEnabled.get();
    }

    List<ReplicationDestination> getFollowers() {
        return Collections.unmodifiableList(this.followers);
    }

    void addFollower(URI followerUri) {
        ReplicationDestination follower = new ReplicationDestination(followerUri, this.journal.maxIndex());
        follower.start();
        this.followers.add(follower);
    }

    void removeFollower(URI followerUri) {
        ReplicationDestination follower = this.followers.stream().filter(f -> Objects.equals(f.getUri(), followerUri)).findAny().orElse(null);
        if (null != follower) {
            follower.stop();
            this.appendEntriesRpcMetricMap.remove(followerUri);
            this.followers.remove(follower);
        }
    }

    Collection<URI> getFollowerUris() {
        return this.followers.stream().map(ReplicationDestination::getUri).collect(Collectors.toSet());
    }

    class ReplicationDestination {
        private final URI uri;
        private long nextIndex;
        private long matchIndex = 0L;
        private long lastHeartbeatResponseTime;
        private long lastHeartbeatRequestTime = 0L;
        private final String replicationThreadName;
        private final JMetric metric;

        ReplicationDestination(URI uri, long nextIndex) {
            this.uri = uri;
            this.nextIndex = nextIndex;
            this.lastHeartbeatResponseTime = 0L;
            this.replicationThreadName = "LeaderReplicationThread-" + Leader.this.serverUri + "->" + uri;
            this.metric = (JMetric)Leader.this.appendEntriesRpcMetricMap.get(uri);
        }

        private AsyncLoopThread buildLeaderReplicationThread() {
            return ThreadBuilder.builder().name(this.replicationThreadName).doWork(this::replication).sleepTime(Leader.this.heartbeatIntervalMs, Leader.this.heartbeatIntervalMs).onException((ExceptionListener)new DefaultExceptionListener(this.replicationThreadName)).daemon(true).build();
        }

        String getReplicationThreadName() {
            return this.replicationThreadName;
        }

        private void start() {
            Leader.this.threads.createThread(this.buildLeaderReplicationThread());
            Leader.this.threads.startThread(this.replicationThreadName);
        }

        private void stop() {
            Leader.this.threads.stopThread(this.replicationThreadName);
            Leader.this.threads.removeThread(this.replicationThreadName);
        }

        private void replication() {
            long maxIndex;
            while (!(Leader.this.serverState() != StateServer.ServerState.RUNNING || Thread.currentThread().isInterrupted() || this.nextIndex >= (maxIndex = Leader.this.journal.maxIndex()) && System.currentTimeMillis() - this.lastHeartbeatRequestTime < Leader.this.heartbeatIntervalMs)) {
                long start = this.metric == null ? 0L : System.nanoTime();
                Map.Entry<Long, JournalKeeperState> fistSnapShotEntry = Leader.this.snapshots.firstEntry();
                this.maybeInstallSnapshotFirst(fistSnapShotEntry);
                List<Object> entries = this.nextIndex < maxIndex ? Leader.this.journal.readRaw(this.nextIndex, Leader.this.replicationBatchSize) : Collections.emptyList();
                AsyncAppendEntriesRequest request = new AsyncAppendEntriesRequest(Leader.this.currentTerm, Leader.this.serverUri, this.nextIndex - 1L, Leader.this.getPreLogTerm(this.nextIndex), entries, Leader.this.journal.commitIndex(), maxIndex);
                AsyncAppendEntriesResponse response = null;
                try {
                    response = (AsyncAppendEntriesResponse)((CompletableFuture)Leader.this.serverRpcProvider.getServerRpc(this.uri).thenCompose(serverRpc -> serverRpc.asyncAppendEntries(request))).get();
                    this.lastHeartbeatRequestTime = System.currentTimeMillis();
                }
                catch (InterruptedException ie) {
                    logger.warn("Replication was interrupted, from {} to {}.", (Object)Leader.this.serverUri, (Object)this.uri);
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (ExecutionException e) {
                    logger.warn("Replication execution exception, from {} to {}, cause: {}.", new Object[]{Leader.this.serverUri, this.uri, null == e.getCause() ? e.getMessage() : e.getCause().getMessage()});
                }
                catch (Throwable t) {
                    logger.warn("Replication exception, from {} to {}, cause: {}.", new Object[]{Leader.this.serverUri, this.uri, t.getMessage()});
                }
                if (null == response || !response.success()) break;
                this.lastHeartbeatResponseTime = System.currentTimeMillis();
                if (response.isSuccess()) {
                    if (entries.size() > 0) {
                        this.nextIndex += (long)entries.size();
                        this.matchIndex = this.nextIndex;
                        Leader.this.isAnyFollowerNextIndexUpdated.compareAndSet(false, true);
                        Leader.this.threads.wakeupThread(Leader.this.threadName("leaderCommitThread"));
                    }
                } else {
                    int rollbackSize = (int)Math.min((long)Leader.this.replicationBatchSize, this.nextIndex - fistSnapShotEntry.getKey());
                    this.nextIndex -= (long)rollbackSize;
                }
                if (null == this.metric) continue;
                this.metric.mark(() -> System.nanoTime() - start, () -> request.getEntries().stream().mapToLong(e -> ((byte[])e).length).sum());
            }
        }

        private void maybeInstallSnapshotFirst(Map.Entry<Long, JournalKeeperState> fistSnapShotEntry) {
            if (this.nextIndex <= fistSnapShotEntry.getKey()) {
                Leader.this.installSnapshot(this, fistSnapShotEntry.getValue());
                this.nextIndex = fistSnapShotEntry.getKey();
            }
        }

        URI getUri() {
            return this.uri;
        }

        long getNextIndex() {
            return this.nextIndex;
        }

        long getMatchIndex() {
            return this.matchIndex;
        }

        long getLastHeartbeatResponseTime() {
            return this.lastHeartbeatResponseTime;
        }

        long getLastHeartbeatRequestTime() {
            return this.lastHeartbeatRequestTime;
        }

        public String toString() {
            return "{uri=" + this.uri + ", nextIndex=" + this.nextIndex + ", matchIndex=" + this.matchIndex + '}';
        }
    }

    private static class UpdateStateRequestResponse {
        private final UpdateClusterStateRequest request;
        private final ResponseFuture responseFuture;
        private final long start = System.nanoTime();

        UpdateStateRequestResponse(UpdateClusterStateRequest request, JMetric metric) {
            this.request = request;
            this.responseFuture = new ResponseFuture(request.getResponseConfig(), request.getRequests().size());
            if (null != metric) {
                this.responseFuture.getResponseFuture().thenRun(() -> metric.mark(() -> System.nanoTime() - this.start, () -> request.getRequests().stream().mapToLong(r -> r.getEntry().length).sum()));
            }
        }

        UpdateClusterStateRequest getRequest() {
            return this.request;
        }

        ResponseFuture getResponseFuture() {
            return this.responseFuture;
        }
    }
}

