/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.ServerStatus;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.server.AbstractServer;
import io.journalkeeper.core.server.DefaultExceptionListener;
import io.journalkeeper.exceptions.InstallSnapshotException;
import io.journalkeeper.exceptions.NotLeaderException;
import io.journalkeeper.exceptions.NotVoterException;
import io.journalkeeper.metric.JMetric;
import io.journalkeeper.persistence.ServerMetadata;
import io.journalkeeper.rpc.BaseResponse;
import io.journalkeeper.rpc.StatusCode;
import io.journalkeeper.rpc.client.CheckLeadershipResponse;
import io.journalkeeper.rpc.client.CompleteTransactionRequest;
import io.journalkeeper.rpc.client.CompleteTransactionResponse;
import io.journalkeeper.rpc.client.CreateTransactionRequest;
import io.journalkeeper.rpc.client.CreateTransactionResponse;
import io.journalkeeper.rpc.client.GetOpeningTransactionsResponse;
import io.journalkeeper.rpc.client.GetServerStatusResponse;
import io.journalkeeper.rpc.client.GetSnapshotsResponse;
import io.journalkeeper.rpc.client.LastAppliedResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.rpc.client.UpdateVotersRequest;
import io.journalkeeper.rpc.client.UpdateVotersResponse;
import io.journalkeeper.rpc.server.AsyncAppendEntriesRequest;
import io.journalkeeper.rpc.server.AsyncAppendEntriesResponse;
import io.journalkeeper.rpc.server.DisableLeaderWriteRequest;
import io.journalkeeper.rpc.server.DisableLeaderWriteResponse;
import io.journalkeeper.rpc.server.GetServerEntriesRequest;
import io.journalkeeper.rpc.server.GetServerEntriesResponse;
import io.journalkeeper.rpc.server.GetServerStateRequest;
import io.journalkeeper.rpc.server.GetServerStateResponse;
import io.journalkeeper.rpc.server.InstallSnapshotRequest;
import io.journalkeeper.rpc.server.InstallSnapshotResponse;
import io.journalkeeper.rpc.server.RequestVoteRequest;
import io.journalkeeper.rpc.server.RequestVoteResponse;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import io.journalkeeper.utils.retry.CheckRetry;
import io.journalkeeper.utils.retry.CompletableRetry;
import io.journalkeeper.utils.retry.DestinationSelector;
import io.journalkeeper.utils.retry.IncreasingRetryPolicy;
import io.journalkeeper.utils.retry.RandomDestinationSelector;
import io.journalkeeper.utils.retry.RetryPolicy;
import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.ExceptionListener;
import io.journalkeeper.utils.threads.ThreadBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Observer
extends AbstractServer {
    private static final Logger logger = LoggerFactory.getLogger(Observer.class);
    private final JMetric replicationMetric;
    private final CompletableRetry<URI> serverRpcRetry;
    private final Config config;

    Observer(StateFactory stateFactory, JournalEntryParser journalEntryParser, ScheduledExecutorService scheduledExecutor, ExecutorService asyncExecutor, ServerRpcAccessPoint serverRpcAccessPoint, Properties properties) {
        super(stateFactory, journalEntryParser, scheduledExecutor, asyncExecutor, serverRpcAccessPoint, properties);
        this.config = this.toConfig(properties);
        this.replicationMetric = this.getMetric("OBSERVER_REPLICATION");
        this.serverRpcRetry = new CompletableRetry((RetryPolicy)new IncreasingRetryPolicy(new long[]{100L, 500L, 3000L, 10000L}, 50L), (DestinationSelector)new RandomDestinationSelector(this.config.getParents()));
    }

    private Config toConfig(Properties properties) {
        Config config = new Config();
        config.setPullBatchSize(Integer.parseInt(properties.getProperty("observer.pull_batch_size", String.valueOf(0x400000))));
        String parentsString = properties.getProperty("observer.parents", null);
        if (null != parentsString) {
            config.setParents(Arrays.stream(parentsString.split(",")).map(String::trim).map(URI::create).collect(Collectors.toList()));
        } else {
            logger.warn("Empty config {} in properties!", (Object)"observer.parents");
        }
        return config;
    }

    private AsyncLoopThread buildReplicationThread() {
        return ThreadBuilder.builder().name(this.threadName("ObserverReplicationThread")).condition(() -> this.serverState() == StateServer.ServerState.RUNNING).doWork(this::pullEntries).sleepTime(50L, 100L).onException((ExceptionListener)new DefaultExceptionListener("ObserverReplicationThread")).daemon(true).build();
    }

    private <O extends BaseResponse> CompletableFuture<O> invokeParentsRpc(CompletableRetry.RpcInvoke<O, ServerRpc> invoke) {
        return this.serverRpcRetry.retry(uri -> invoke.invoke((Object)this.serverRpcAccessPoint.getServerRpcAgent(uri)), new CheckRetry<O>(){

            public boolean checkException(Throwable exception) {
                return true;
            }

            public boolean checkResult(O result) {
                return !result.success();
            }
        }, (Executor)this.asyncExecutor, this.scheduledExecutor);
    }

    private void pullEntries() throws Throwable {
        GetServerEntriesResponse response;
        this.replicationMetric.start();
        long traffic = 0L;
        if (this.journal.commitIndex() == 0L) {
            this.installSnapshot(0L);
        }
        if ((response = (GetServerEntriesResponse)this.invokeParentsRpc(rpc -> rpc.getServerEntries(new GetServerEntriesRequest(this.journal.commitIndex(), this.config.getPullBatchSize()))).get()).success()) {
            this.journal.appendBatchRaw(response.getEntries());
            this.voterConfigManager.maybeUpdateNonLeaderConfig(response.getEntries(), this.state.getConfigState());
            this.journal.commit(this.journal.maxIndex());
            this.threads.wakeupThread(this.threadName("StateMachineThread"));
        } else if (response.getStatusCode() == StatusCode.INDEX_UNDERFLOW) {
            this.installSnapshot(response.getMinIndex());
        } else if (response.getStatusCode() != StatusCode.INDEX_OVERFLOW) {
            logger.warn("Pull entry failed! {}", (Object)response.errorString());
        }
        this.replicationMetric.end(() -> response.getEntries().stream().mapToLong(bytes -> ((byte[])bytes).length).sum());
    }

    private void installSnapshot(long index) throws InterruptedException, ExecutionException, IOException, TimeoutException {
        boolean done;
        long lastIncludedIndex = index - 1L;
        int iteratorId = -1;
        do {
            int finalIteratorId;
            GetServerStateResponse r;
            if (!(r = (GetServerStateResponse)this.invokeParentsRpc(arg_0 -> Observer.lambda$installSnapshot$5(lastIncludedIndex, finalIteratorId = iteratorId, arg_0)).get()).success()) {
                throw new InstallSnapshotException(r.errorString());
            }
            this.installSnapshot(r.getOffset(), r.getLastIncludedIndex(), r.getLastIncludedTerm(), r.getData(), r.isDone());
            iteratorId = r.getIteratorId();
            done = r.isDone();
        } while (!done);
    }

    public RaftServer.Roll roll() {
        return RaftServer.Roll.OBSERVER;
    }

    @Override
    protected void onMetadataRecovered(ServerMetadata metadata) {
        super.onMetadataRecovered(metadata);
        this.config.setParents(metadata.getParents());
    }

    @Override
    public void doStart() {
        this.threads.createThread(this.buildReplicationThread());
        this.threads.startThread(this.threadName("ObserverReplicationThread"));
    }

    @Override
    public void doStop() {
        this.threads.stopThread(this.threadName("ObserverReplicationThread"));
    }

    public CompletableFuture<UpdateClusterStateResponse> updateClusterState(UpdateClusterStateRequest request) {
        return CompletableFuture.completedFuture(new UpdateClusterStateResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<QueryStateResponse> queryClusterState(QueryStateRequest request) {
        return CompletableFuture.completedFuture(new QueryStateResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<LastAppliedResponse> lastApplied() {
        return CompletableFuture.completedFuture(new LastAppliedResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<GetServerStatusResponse> getServerStatus() {
        return CompletableFuture.supplyAsync(() -> new ServerStatus(RaftServer.Roll.OBSERVER, this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex(), this.state.lastApplied(), null), this.asyncExecutor).thenApply(GetServerStatusResponse::new);
    }

    public CompletableFuture<UpdateVotersResponse> updateVoters(UpdateVotersRequest request) {
        return CompletableFuture.completedFuture(new UpdateVotersResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<CreateTransactionResponse> createTransaction(CreateTransactionRequest request) {
        return CompletableFuture.completedFuture(new CreateTransactionResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<CompleteTransactionResponse> completeTransaction(CompleteTransactionRequest request) {
        return CompletableFuture.completedFuture(new CompleteTransactionResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<GetOpeningTransactionsResponse> getOpeningTransactions() {
        return CompletableFuture.completedFuture(new GetOpeningTransactionsResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<GetSnapshotsResponse> getSnapshots() {
        return CompletableFuture.completedFuture(new GetSnapshotsResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<CheckLeadershipResponse> checkLeadership() {
        return CompletableFuture.completedFuture(new CheckLeadershipResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<AsyncAppendEntriesResponse> asyncAppendEntries(AsyncAppendEntriesRequest request) {
        return CompletableFuture.completedFuture(new AsyncAppendEntriesResponse((Throwable)new NotVoterException()));
    }

    public CompletableFuture<RequestVoteResponse> requestVote(RequestVoteRequest request) {
        return CompletableFuture.completedFuture(new RequestVoteResponse((Throwable)new NotVoterException()));
    }

    public CompletableFuture<DisableLeaderWriteResponse> disableLeaderWrite(DisableLeaderWriteRequest request) {
        return CompletableFuture.completedFuture(new DisableLeaderWriteResponse((Throwable)new NotVoterException()));
    }

    public CompletableFuture<InstallSnapshotResponse> installSnapshot(InstallSnapshotRequest request) {
        return CompletableFuture.completedFuture(new InstallSnapshotResponse((Throwable)new NotVoterException()));
    }

    @Override
    protected ServerMetadata createServerMetadata() {
        ServerMetadata serverMetadata = super.createServerMetadata();
        serverMetadata.setParents(this.config.getParents());
        return serverMetadata;
    }

    private static /* synthetic */ CompletableFuture lambda$installSnapshot$5(long lastIncludedIndex, int finalIteratorId, ServerRpc rpc) {
        return rpc.getServerState(new GetServerStateRequest(lastIncludedIndex, finalIteratorId));
    }

    private static class Config {
        private static final int DEFAULT_PULL_BATCH_SIZE = 0x400000;
        private static final String PULL_BATCH_SIZE_KEY = "observer.pull_batch_size";
        private static final String PARENTS_KEY = "observer.parents";
        private List<URI> parents = Collections.emptyList();
        private int pullBatchSize = 0x400000;

        private Config() {
        }

        private int getPullBatchSize() {
            return this.pullBatchSize;
        }

        private void setPullBatchSize(int pullBatchSize) {
            this.pullBatchSize = pullBatchSize;
        }

        public List<URI> getParents() {
            return this.parents;
        }

        public void setParents(List<URI> parents) {
            this.parents = parents;
        }
    }
}

