/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.exceptions.InstallSnapshotException;
import io.journalkeeper.utils.files.FileUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartialSnapshot {
    private static final Logger logger = LoggerFactory.getLogger(PartialSnapshot.class);
    private final Path partialSnapshotPath;
    private Path snapshotPath = null;
    private long offset = 0L;

    PartialSnapshot(Path partialSnapshotPath) {
        this.partialSnapshotPath = partialSnapshotPath;
    }

    private Path getSnapshotPath() {
        return this.snapshotPath;
    }

    public long getOffset() {
        return this.offset;
    }

    void installTrunk(long offset, byte[] data, Path snapshotPath) throws IOException {
        if (offset == 0L) {
            this.begin(snapshotPath);
        } else {
            if (!this.isPartial()) {
                throw new InstallSnapshotException(String.format("No partial snapshot exists! Install path: %s.", snapshotPath));
            }
            if (!snapshotPath.equals(this.getSnapshotPath())) {
                throw new InstallSnapshotException(String.format("Partial snapshot path not match! Partial snapshot: %s, install path: %s.", this, snapshotPath));
            }
            if (offset != this.getOffset()) {
                throw new InstallSnapshotException(String.format("Partial snapshot offset not match! Partial snapshot: %s, request offset: %d.", this, offset));
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int filenameLength = buffer.getInt();
        byte[] filenameBytes = new byte[filenameLength];
        buffer.get(filenameBytes);
        String filePathString = new String(filenameBytes, StandardCharsets.UTF_8);
        long offsetOfFile = buffer.getLong();
        Path filePath = this.partialSnapshotPath.resolve(filePathString);
        if (offsetOfFile == 0L) {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
        }
        logger.info("Installing snapshot file: {}...", (Object)filePath);
        if (offsetOfFile == 0L || Files.size(filePath) == offsetOfFile) {
            try (FileOutputStream output = new FileOutputStream(filePath.toFile(), true);){
                output.write(data, buffer.position(), buffer.remaining());
            }
            this.offset += (long)data.length;
        } else {
            throw new InstallSnapshotException(String.format("Current file size %d should equal trunk offset %d! File: %s", Files.size(filePath), offsetOfFile, filePath.toString()));
        }
    }

    void finish() throws IOException {
        FileUtils.deleteFolder((Path)this.snapshotPath);
        FileUtils.dump((Path)this.partialSnapshotPath, (Path)this.snapshotPath);
        this.snapshotPath = null;
        this.offset = 0L;
    }

    private void begin(Path path) throws IOException {
        if (null == path) {
            throw new IllegalArgumentException("Path can not be null!");
        }
        this.snapshotPath = path;
        this.offset = 0L;
        if (Files.exists(this.partialSnapshotPath, new LinkOption[0])) {
            FileUtils.deleteFolder((Path)this.partialSnapshotPath);
        }
        Files.createDirectories(this.partialSnapshotPath, new FileAttribute[0]);
    }

    private boolean isPartial() {
        return this.snapshotPath != null;
    }

    public String toString() {
        return "PartialSnapshot{path=" + this.snapshotPath + ", offset=" + this.offset + '}';
    }
}

