/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

class ResponseFuture {
    private final CompletableFuture<UpdateClusterStateResponse> responseFuture;
    private final CompletableFuture<UpdateClusterStateResponse> flushFuture = new CompletableFuture();
    private final CompletableFuture<UpdateClusterStateResponse> replicationFuture = new CompletableFuture();
    private int flushCountDown;
    private int replicationCountDown;
    private List<byte[]> results;

    ResponseFuture(ResponseConfig responseConfig, int count) {
        switch (responseConfig) {
            case PERSISTENCE: {
                this.responseFuture = this.flushFuture;
                break;
            }
            case ALL: {
                this.responseFuture = new CompletableFuture();
                this.replicationFuture.whenComplete((replicationResponse, e) -> {
                    if (null == e) {
                        if (replicationResponse.success()) {
                            this.flushFuture.whenComplete((flushResponse, t) -> {
                                if (null == t) {
                                    if (flushResponse.success()) {
                                        this.responseFuture.complete((UpdateClusterStateResponse)replicationResponse);
                                    } else {
                                        this.responseFuture.complete((UpdateClusterStateResponse)flushResponse);
                                    }
                                } else {
                                    this.responseFuture.complete(new UpdateClusterStateResponse(t));
                                }
                            });
                        } else {
                            this.responseFuture.complete((UpdateClusterStateResponse)replicationResponse);
                        }
                    } else {
                        this.responseFuture.complete(new UpdateClusterStateResponse(e));
                    }
                });
                break;
            }
            default: {
                this.responseFuture = this.replicationFuture;
            }
        }
        this.flushCountDown = count;
        this.replicationCountDown = count;
        this.results = new ArrayList<byte[]>(count);
    }

    CompletableFuture<UpdateClusterStateResponse> getResponseFuture() {
        return this.responseFuture;
    }

    void countDownFlush() {
        if (--this.flushCountDown == 0) {
            this.flushFuture.complete(new UpdateClusterStateResponse(Collections.emptyList(), -1L));
        }
    }

    void putResult(byte[] result, long lastApplied) {
        this.results.add(result);
        if (--this.replicationCountDown == 0) {
            this.replicationFuture.complete(new UpdateClusterStateResponse(this.results, lastApplied));
        }
    }

    void completedExceptionally(Throwable throwable) {
        this.responseFuture.completeExceptionally(throwable);
    }
}

