/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.server.Callback;
import io.journalkeeper.core.server.CallbackResultBelt;
import io.journalkeeper.utils.buffer.LockFreeRingBuffer;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingBufferBelt
implements CallbackResultBelt {
    private static final Logger logger = LoggerFactory.getLogger(RingBufferBelt.class);
    private final long timeoutMs;
    private final LockFreeRingBuffer<Callback> buffer;

    RingBufferBelt(long timeoutMs, int capacity) {
        this.timeoutMs = timeoutMs;
        this.buffer = new LockFreeRingBuffer(Callback.class, capacity);
    }

    @Override
    public boolean full() {
        return this.buffer.full();
    }

    @Override
    public void put(Callback callback) throws InterruptedException {
        while (!this.buffer.put((Object)callback)) {
            Thread.yield();
        }
    }

    @Override
    public void callbackBefore(long position) {
        Callback c;
        while ((c = (Callback)this.buffer.get()) != null && c.getPosition() <= position) {
            c = (Callback)this.buffer.remove();
            if (null == c) continue;
            c.getResponseFuture().countDownFlush();
        }
        this.callbackTimeouted();
    }

    private void callbackTimeouted() {
        Callback c;
        long deadline = System.currentTimeMillis() - this.timeoutMs;
        while ((c = (Callback)this.buffer.get()) != null && c.getTimestamp() < deadline) {
            c = (Callback)this.buffer.remove();
            if (null == c) continue;
            c.getResponseFuture().completedExceptionally(new TimeoutException());
        }
    }

    @Override
    public void callback(long position, byte[] result) {
        Callback c;
        while ((c = (Callback)this.buffer.get()) != null && c.getPosition() < position) {
            c = (Callback)this.buffer.remove();
            c.getResponseFuture().completedExceptionally(new IllegalStateException());
            logger.warn("Callback index not match! next callback in the waiting buffer: {}, request callback index: {}, ", (Object)c.getPosition(), (Object)position);
        }
        if (null != c && c.getPosition() == position) {
            c = (Callback)this.buffer.remove();
            c.getResponseFuture().putResult(result, position);
        }
    }

    @Override
    public void failAll() {
        while (!this.buffer.empty()) {
            ((Callback)this.buffer.remove()).getResponseFuture().completedExceptionally(new IllegalStateException());
        }
    }
}

