/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.server.AbstractServer;
import io.journalkeeper.core.server.Observer;
import io.journalkeeper.core.server.ServerMonitorInfoProvider;
import io.journalkeeper.core.server.Voter;
import io.journalkeeper.monitor.MonitorCollector;
import io.journalkeeper.monitor.MonitoredServer;
import io.journalkeeper.rpc.RpcAccessPointFactory;
import io.journalkeeper.rpc.client.AddPullWatchResponse;
import io.journalkeeper.rpc.client.CheckLeadershipResponse;
import io.journalkeeper.rpc.client.CompleteTransactionRequest;
import io.journalkeeper.rpc.client.CompleteTransactionResponse;
import io.journalkeeper.rpc.client.ConvertRollRequest;
import io.journalkeeper.rpc.client.ConvertRollResponse;
import io.journalkeeper.rpc.client.CreateTransactionRequest;
import io.journalkeeper.rpc.client.CreateTransactionResponse;
import io.journalkeeper.rpc.client.GetOpeningTransactionsResponse;
import io.journalkeeper.rpc.client.GetServerStatusResponse;
import io.journalkeeper.rpc.client.GetServersResponse;
import io.journalkeeper.rpc.client.GetSnapshotsResponse;
import io.journalkeeper.rpc.client.LastAppliedResponse;
import io.journalkeeper.rpc.client.PullEventsRequest;
import io.journalkeeper.rpc.client.PullEventsResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.RemovePullWatchRequest;
import io.journalkeeper.rpc.client.RemovePullWatchResponse;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.rpc.client.UpdateVotersRequest;
import io.journalkeeper.rpc.client.UpdateVotersResponse;
import io.journalkeeper.rpc.server.AsyncAppendEntriesRequest;
import io.journalkeeper.rpc.server.AsyncAppendEntriesResponse;
import io.journalkeeper.rpc.server.DisableLeaderWriteRequest;
import io.journalkeeper.rpc.server.DisableLeaderWriteResponse;
import io.journalkeeper.rpc.server.GetServerEntriesRequest;
import io.journalkeeper.rpc.server.GetServerEntriesResponse;
import io.journalkeeper.rpc.server.GetServerStateRequest;
import io.journalkeeper.rpc.server.GetServerStateResponse;
import io.journalkeeper.rpc.server.InstallSnapshotRequest;
import io.journalkeeper.rpc.server.InstallSnapshotResponse;
import io.journalkeeper.rpc.server.RequestVoteRequest;
import io.journalkeeper.rpc.server.RequestVoteResponse;
import io.journalkeeper.rpc.server.ServerRpc;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.spi.ServiceSupport;
import io.journalkeeper.utils.state.StateServer;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements ServerRpc,
RaftServer {
    private static final Logger logger = LoggerFactory.getLogger(Server.class);
    private final RpcAccessPointFactory rpcAccessPointFactory;
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService asyncExecutor;
    private final Properties properties;
    private final StateFactory stateFactory;
    private final JournalEntryParser journalEntryParser;
    private final ServerMonitorInfoProvider serverMonitorInfoProvider;
    private final Collection<MonitorCollector> monitorCollectors;
    private AbstractServer server;
    private StateServer rpcServer = null;
    private StateServer.ServerState serverState = StateServer.ServerState.CREATED;
    private ServerRpcAccessPoint serverRpcAccessPoint;

    public Server(RaftServer.Roll roll, StateFactory stateFactory, JournalEntryParser journalEntryParser, ScheduledExecutorService scheduledExecutor, ExecutorService asyncExecutor, Properties properties) {
        this.rpcAccessPointFactory = (RpcAccessPointFactory)ServiceSupport.load(RpcAccessPointFactory.class);
        this.scheduledExecutor = scheduledExecutor;
        this.asyncExecutor = asyncExecutor;
        this.stateFactory = stateFactory;
        this.properties = properties;
        this.serverRpcAccessPoint = this.rpcAccessPointFactory.createServerRpcAccessPoint(properties);
        this.journalEntryParser = journalEntryParser;
        this.server = this.createServer(roll);
        this.serverMonitorInfoProvider = new ServerMonitorInfoProvider(this);
        this.monitorCollectors = ServiceSupport.loadAll(MonitorCollector.class);
    }

    private AbstractServer createServer(RaftServer.Roll roll) {
        if (roll == RaftServer.Roll.VOTER) {
            return new Voter(this.stateFactory, this.journalEntryParser, this.scheduledExecutor, this.asyncExecutor, this.serverRpcAccessPoint, this.properties);
        }
        return new Observer(this.stateFactory, this.journalEntryParser, this.scheduledExecutor, this.asyncExecutor, this.serverRpcAccessPoint, this.properties);
    }

    public RaftServer.Roll roll() {
        return this.server.roll();
    }

    public void init(URI uri, List<URI> voters, Set<Integer> partitions, URI preferredLeader) throws IOException {
        this.server.init(uri, voters, partitions, preferredLeader);
    }

    public boolean isInitialized() {
        return this.server.isInitialized();
    }

    public void recover() throws IOException {
        this.server.recover();
    }

    public URI serverUri() {
        return null == this.server ? null : this.server.serverUri();
    }

    public CompletableFuture<UpdateClusterStateResponse> updateClusterState(UpdateClusterStateRequest request) {
        return this.server.updateClusterState(request);
    }

    public CompletableFuture<QueryStateResponse> queryClusterState(QueryStateRequest request) {
        return this.server.queryClusterState(request);
    }

    public CompletableFuture<QueryStateResponse> queryServerState(QueryStateRequest request) {
        return this.server.queryServerState(request);
    }

    public CompletableFuture<LastAppliedResponse> lastApplied() {
        return this.server.lastApplied();
    }

    public CompletableFuture<QueryStateResponse> querySnapshot(QueryStateRequest request) {
        return this.server.querySnapshot(request);
    }

    public CompletableFuture<GetServersResponse> getServers() {
        return this.server.getServers();
    }

    public CompletableFuture<GetServerStatusResponse> getServerStatus() {
        return this.server.getServerStatus();
    }

    public CompletableFuture<AddPullWatchResponse> addPullWatch() {
        return this.server.addPullWatch();
    }

    public CompletableFuture<RemovePullWatchResponse> removePullWatch(RemovePullWatchRequest request) {
        return this.server.removePullWatch(request);
    }

    public CompletableFuture<UpdateVotersResponse> updateVoters(UpdateVotersRequest request) {
        return this.server.updateVoters(request);
    }

    public CompletableFuture<PullEventsResponse> pullEvents(PullEventsRequest request) {
        return this.server.pullEvents(request);
    }

    public CompletableFuture<ConvertRollResponse> convertRoll(ConvertRollRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (request.getRoll() != null && request.getRoll() != this.server.roll()) {
                try {
                    if (this.server.serverState() != StateServer.ServerState.RUNNING) {
                        throw new IllegalStateException("Server is not running, current state: " + this.server.serverState() + "!");
                    }
                    this.server.stop();
                    this.server = this.createServer(request.getRoll());
                    this.server.recover();
                    this.server.start();
                }
                catch (Throwable t) {
                    return new ConvertRollResponse(t);
                }
            }
            return new ConvertRollResponse();
        }, this.asyncExecutor);
    }

    public CompletableFuture<CreateTransactionResponse> createTransaction(CreateTransactionRequest request) {
        return this.server.createTransaction(request);
    }

    public CompletableFuture<CompleteTransactionResponse> completeTransaction(CompleteTransactionRequest request) {
        return this.server.completeTransaction(request);
    }

    public CompletableFuture<GetOpeningTransactionsResponse> getOpeningTransactions() {
        return this.server.getOpeningTransactions();
    }

    public CompletableFuture<GetSnapshotsResponse> getSnapshots() {
        return this.server.getSnapshots();
    }

    public CompletableFuture<CheckLeadershipResponse> checkLeadership() {
        return this.server.checkLeadership();
    }

    public void watch(EventWatcher eventWatcher) {
        this.server.watch(eventWatcher);
    }

    public void unWatch(EventWatcher eventWatcher) {
        this.server.unWatch(eventWatcher);
    }

    public CompletableFuture<AsyncAppendEntriesResponse> asyncAppendEntries(AsyncAppendEntriesRequest request) {
        return this.server.asyncAppendEntries(request);
    }

    public CompletableFuture<RequestVoteResponse> requestVote(RequestVoteRequest request) {
        return this.server.requestVote(request);
    }

    public CompletableFuture<GetServerEntriesResponse> getServerEntries(GetServerEntriesRequest request) {
        return this.server.getServerEntries(request);
    }

    public CompletableFuture<GetServerStateResponse> getServerState(GetServerStateRequest request) {
        return this.server.getServerState(request);
    }

    public CompletableFuture<DisableLeaderWriteResponse> disableLeaderWrite(DisableLeaderWriteRequest request) {
        return this.server.disableLeaderWrite(request);
    }

    public CompletableFuture<InstallSnapshotResponse> installSnapshot(InstallSnapshotRequest request) {
        return this.server.installSnapshot(request);
    }

    private void addMonitorProviderToCollectors() {
        if (null != this.monitorCollectors) {
            for (MonitorCollector monitorCollector : this.monitorCollectors) {
                monitorCollector.addServer((MonitoredServer)this.serverMonitorInfoProvider);
            }
        }
    }

    private void removeMonitorProviderToCollectors() {
        if (null != this.monitorCollectors) {
            for (MonitorCollector monitorCollector : this.monitorCollectors) {
                monitorCollector.removeServer((MonitoredServer)this.serverMonitorInfoProvider);
            }
        }
    }

    public void start() {
        this.addMonitorProviderToCollectors();
        if (this.serverState != StateServer.ServerState.CREATED) {
            throw new IllegalStateException("Server can only start once!");
        }
        this.serverState = StateServer.ServerState.STARTING;
        this.server.start();
        this.rpcServer = this.rpcAccessPointFactory.bindServerService((ServerRpc)this);
        this.rpcServer.start();
        this.serverState = StateServer.ServerState.RUNNING;
    }

    public void stop() {
        if (this.serverState == StateServer.ServerState.RUNNING) {
            this.serverState = StateServer.ServerState.STOPPING;
            if (this.rpcServer != null) {
                this.rpcServer.stop();
            }
            this.server.stop();
            this.serverRpcAccessPoint.stop();
            this.serverState = StateServer.ServerState.STOPPED;
            this.removeMonitorProviderToCollectors();
            logger.info("Server {} stopped.", (Object)this.serverUri());
        }
    }

    public StateServer.ServerState serverState() {
        return this.server.serverState();
    }

    AbstractServer getServer() {
        return this.server;
    }
}

