/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.VoterState;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.server.AbstractServer;
import io.journalkeeper.core.server.Follower;
import io.journalkeeper.core.server.Leader;
import io.journalkeeper.core.server.Server;
import io.journalkeeper.core.server.Voter;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.core.state.JournalKeeperState;
import io.journalkeeper.monitor.DiskMonitorInfo;
import io.journalkeeper.monitor.FollowerMonitorInfo;
import io.journalkeeper.monitor.JournalMonitorInfo;
import io.journalkeeper.monitor.JournalPartitionMonitorInfo;
import io.journalkeeper.monitor.LeaderFollowerMonitorInfo;
import io.journalkeeper.monitor.LeaderMonitorInfo;
import io.journalkeeper.monitor.MonitoredServer;
import io.journalkeeper.monitor.NodeMonitorInfo;
import io.journalkeeper.monitor.ServerMonitorInfo;
import io.journalkeeper.monitor.VoterMonitorInfo;
import io.journalkeeper.persistence.JournalPersistence;
import io.journalkeeper.persistence.MonitoredPersistence;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServerMonitorInfoProvider
implements MonitoredServer {
    private final Server server;

    public ServerMonitorInfoProvider(Server server) {
        this.server = server;
    }

    public URI uri() {
        return this.server.serverUri();
    }

    public ServerMonitorInfo collect() {
        ServerMonitorInfo serverMonitorInfo = new ServerMonitorInfo();
        serverMonitorInfo.setUri(this.server.serverUri());
        serverMonitorInfo.setState(this.server.serverState());
        serverMonitorInfo.setRoll(this.server.roll());
        AbstractServer abstractServer = this.server.getServer();
        if (null != abstractServer) {
            serverMonitorInfo.setLeader(abstractServer.getLeaderUri());
            NodeMonitorInfo nodeMonitorInfo = this.collectNodeMonitorInfo(abstractServer.getState().getConfigState());
            serverMonitorInfo.setNodes(nodeMonitorInfo);
            JournalMonitorInfo journalMonitorInfo = this.collectJournalMonitorInfo(abstractServer.getJournal(), abstractServer.getState());
            serverMonitorInfo.setJournal(journalMonitorInfo);
            DiskMonitorInfo diskMonitorInfo = this.collectDistMonitorInfo(abstractServer.getJournal().getJournalPersistence());
            serverMonitorInfo.setDisk(diskMonitorInfo);
            if (this.server.roll() == RaftServer.Roll.VOTER) {
                Voter voter = (Voter)abstractServer;
                VoterMonitorInfo voterMonitorInfo = this.collectVoterMonitorInfo(voter);
                serverMonitorInfo.setVoter(voterMonitorInfo);
            }
        }
        return serverMonitorInfo;
    }

    private DiskMonitorInfo collectDistMonitorInfo(JournalPersistence journalPersistence) {
        DiskMonitorInfo diskMonitorInfo = new DiskMonitorInfo();
        if (journalPersistence instanceof MonitoredPersistence) {
            MonitoredPersistence monitoredPersistence = (MonitoredPersistence)journalPersistence;
            diskMonitorInfo.setPath(monitoredPersistence.getPath());
            diskMonitorInfo.setFree(monitoredPersistence.getFreeSpace());
            diskMonitorInfo.setTotal(monitoredPersistence.getTotalSpace());
        }
        return diskMonitorInfo;
    }

    private VoterMonitorInfo collectVoterMonitorInfo(Voter voter) {
        VoterMonitorInfo voterMonitorInfo = new VoterMonitorInfo();
        voterMonitorInfo.setState(voter.getVoterState());
        voterMonitorInfo.setLastVote(voter.getLastVote());
        voterMonitorInfo.setElectionTimeout(voter.getElectionTimeoutMs());
        voterMonitorInfo.setNextElectionTime(voter.getNextElectionTime());
        voterMonitorInfo.setLastHeartbeat(voter.getLastHeartbeat());
        voterMonitorInfo.setPreferredLeader(voter.getPreferredLeader());
        if (voter.getVoterState() == VoterState.LEADER) {
            Leader leader = voter.getLeader();
            LeaderMonitorInfo leaderMonitorInfo = this.collectLeaderMonitorInfo(leader);
            voterMonitorInfo.setLeader(leaderMonitorInfo);
        } else if (voter.getVoterState() == VoterState.FOLLOWER) {
            Follower follower = voter.getFollower();
            FollowerMonitorInfo followerMonitorInfo = this.collectFollowerMonitorInfo(follower);
            voterMonitorInfo.setFollower(followerMonitorInfo);
        }
        return voterMonitorInfo;
    }

    private FollowerMonitorInfo collectFollowerMonitorInfo(Follower follower) {
        FollowerMonitorInfo followerMonitorInfo = null;
        if (null != follower) {
            followerMonitorInfo = new FollowerMonitorInfo();
            followerMonitorInfo.setState(follower.serverState());
            followerMonitorInfo.setLeaderMaxIndex(follower.getLeaderMaxIndex());
        }
        return followerMonitorInfo;
    }

    private LeaderMonitorInfo collectLeaderMonitorInfo(Leader leader) {
        LeaderMonitorInfo leaderMonitorInfo = null;
        if (null != leader) {
            leaderMonitorInfo = new LeaderMonitorInfo();
            leaderMonitorInfo.setState(leader.serverState());
            leaderMonitorInfo.setRequestQueueSize(leader.getRequestQueueSize());
            leaderMonitorInfo.setWriteEnabled(leader.isWriteEnabled());
            List<Leader.ReplicationDestination> replicationDestinations = leader.getFollowers();
            if (null != replicationDestinations) {
                ArrayList<LeaderFollowerMonitorInfo> leaderFollowerMonitorInfoList = new ArrayList<LeaderFollowerMonitorInfo>(replicationDestinations.size());
                for (Leader.ReplicationDestination destination : replicationDestinations) {
                    LeaderFollowerMonitorInfo destInfo = this.collectLeaderFollowerMonitorInfo(destination);
                    leaderFollowerMonitorInfoList.add(destInfo);
                }
                leaderMonitorInfo.setFollowers(leaderFollowerMonitorInfoList);
            }
        }
        return leaderMonitorInfo;
    }

    private LeaderFollowerMonitorInfo collectLeaderFollowerMonitorInfo(Leader.ReplicationDestination destination) {
        LeaderFollowerMonitorInfo destInfo = new LeaderFollowerMonitorInfo();
        destInfo.setUri(destination.getUri());
        destInfo.setNextIndex(destination.getNextIndex());
        destInfo.setMatchIndex(destination.getMatchIndex());
        destInfo.setLastHeartbeatResponseTime(destination.getLastHeartbeatResponseTime());
        destInfo.setLastHeartbeatRequestTime(destination.getLastHeartbeatRequestTime());
        return destInfo;
    }

    private NodeMonitorInfo collectNodeMonitorInfo(ConfigState voterConfigurationStateMachine) {
        NodeMonitorInfo nodeMonitorInfo = null;
        if (null != voterConfigurationStateMachine) {
            nodeMonitorInfo = new NodeMonitorInfo();
            nodeMonitorInfo.setJointConsensus(voterConfigurationStateMachine.isJointConsensus());
            if (voterConfigurationStateMachine.isJointConsensus()) {
                nodeMonitorInfo.setNewConfig(voterConfigurationStateMachine.getConfigNew());
                nodeMonitorInfo.setOldConfig(voterConfigurationStateMachine.getConfigOld());
            } else {
                nodeMonitorInfo.setConfig(voterConfigurationStateMachine.getConfigNew());
            }
        }
        return nodeMonitorInfo;
    }

    private JournalMonitorInfo collectJournalMonitorInfo(Journal journal, JournalKeeperState state) {
        JournalMonitorInfo journalMonitorInfo = new JournalMonitorInfo();
        if (null != journal) {
            journalMonitorInfo.setMinIndex(journal.minIndex());
            journalMonitorInfo.setMaxIndex(journal.maxIndex());
            journalMonitorInfo.setFlushIndex(journal.flushedIndex());
            journalMonitorInfo.setCommitIndex(journal.commitIndex());
            JournalPersistence journalPersistence = journal.getJournalPersistence();
            journalMonitorInfo.setMinOffset(journalPersistence.min());
            journalMonitorInfo.setMaxOffset(journalPersistence.max());
            journalMonitorInfo.setFlushOffset(journalPersistence.flushed());
            JournalPersistence indexPersistence = journal.getIndexPersistence();
            journalMonitorInfo.setIndexMinOffset(indexPersistence.min());
            journalMonitorInfo.setIndexMaxOffset(indexPersistence.max());
            journalMonitorInfo.setIndexFlushOffset(indexPersistence.flushed());
            Map<Integer, JournalPersistence> partitionMap = journal.getPartitionMap();
            if (null != partitionMap) {
                ArrayList partitionMonitorInfoList = new ArrayList(partitionMap.size());
                partitionMap.entrySet().stream().filter(entry -> (Integer)entry.getKey() < 30000).forEach(entry -> {
                    int partition = (Integer)entry.getKey();
                    JournalPersistence persistence = (JournalPersistence)entry.getValue();
                    JournalPartitionMonitorInfo partitionMonitorInfo = new JournalPartitionMonitorInfo();
                    partitionMonitorInfo.setPartition(partition);
                    partitionMonitorInfo.setMinIndex(persistence.min() / 8L);
                    partitionMonitorInfo.setMaxIndex(persistence.max() / 8L);
                    partitionMonitorInfo.setMinOffset(persistence.min());
                    partitionMonitorInfo.setMaxOffset(persistence.max());
                    partitionMonitorInfo.setFlushOffset(persistence.flushed());
                    partitionMonitorInfoList.add(partitionMonitorInfo);
                });
                journalMonitorInfo.setPartitions(partitionMonitorInfoList);
            }
        }
        if (null != state) {
            journalMonitorInfo.setAppliedIndex(state.lastApplied());
        }
        return journalMonitorInfo;
    }
}

