/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.RaftServer;
import io.journalkeeper.core.api.ServerStatus;
import io.journalkeeper.core.api.SnapshotEntry;
import io.journalkeeper.core.api.SnapshotsEntry;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.VoterState;
import io.journalkeeper.core.api.transaction.UUIDTransactionId;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.UpdateVotersS1Entry;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.server.AbstractServer;
import io.journalkeeper.core.server.CheckTermInterceptor;
import io.journalkeeper.core.server.Follower;
import io.journalkeeper.core.server.Leader;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.exceptions.NotLeaderException;
import io.journalkeeper.exceptions.UpdateConfigurationException;
import io.journalkeeper.persistence.ServerMetadata;
import io.journalkeeper.rpc.client.CheckLeadershipResponse;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.CompleteTransactionRequest;
import io.journalkeeper.rpc.client.CompleteTransactionResponse;
import io.journalkeeper.rpc.client.CreateTransactionRequest;
import io.journalkeeper.rpc.client.CreateTransactionResponse;
import io.journalkeeper.rpc.client.GetOpeningTransactionsResponse;
import io.journalkeeper.rpc.client.GetServerStatusResponse;
import io.journalkeeper.rpc.client.GetSnapshotsResponse;
import io.journalkeeper.rpc.client.LastAppliedResponse;
import io.journalkeeper.rpc.client.QueryStateRequest;
import io.journalkeeper.rpc.client.QueryStateResponse;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.rpc.client.UpdateClusterStateResponse;
import io.journalkeeper.rpc.client.UpdateVotersRequest;
import io.journalkeeper.rpc.client.UpdateVotersResponse;
import io.journalkeeper.rpc.server.AsyncAppendEntriesRequest;
import io.journalkeeper.rpc.server.AsyncAppendEntriesResponse;
import io.journalkeeper.rpc.server.DisableLeaderWriteRequest;
import io.journalkeeper.rpc.server.DisableLeaderWriteResponse;
import io.journalkeeper.rpc.server.InstallSnapshotRequest;
import io.journalkeeper.rpc.server.InstallSnapshotResponse;
import io.journalkeeper.rpc.server.RequestVoteRequest;
import io.journalkeeper.rpc.server.RequestVoteResponse;
import io.journalkeeper.rpc.server.ServerRpcAccessPoint;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Voter
extends AbstractServer
implements CheckTermInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(Voter.class);
    private static final long PREFERRED_LEADER_IN_SYNC_THRESHOLD = 128L;
    private final AtomicInteger currentTerm = new AtomicInteger(0);
    private final Object voteRequestMutex = new Object();
    private final Config config;
    private final VoterStateMachine voterState = new VoterStateMachine();
    private URI votedFor = null;
    private long electionTimeoutMs;
    private long lastHeartbeat = 0L;
    private ScheduledFuture checkElectionTimeoutFuture;
    private ScheduledFuture printStateFuture;
    private Leader leader;
    private Follower follower;
    private long nextElectionTime = 0L;

    Voter(StateFactory stateFactory, JournalEntryParser journalEntryParser, ScheduledExecutorService scheduledExecutor, ExecutorService asyncExecutor, ServerRpcAccessPoint serverRpcAccessPoint, Properties properties) {
        super(stateFactory, journalEntryParser, scheduledExecutor, asyncExecutor, serverRpcAccessPoint, properties);
        this.config = this.toConfig(properties);
        this.state.addInterceptor(InternalEntryType.TYPE_UPDATE_VOTERS_S1, this::applyUpdateVotersInternalEntry);
        this.electionTimeoutMs = this.config.getElectionTimeoutMs() + this.randomInterval(this.config.getElectionTimeoutMs());
    }

    private void applyUpdateVotersInternalEntry(InternalEntryType type, byte[] internalEntry) {
        this.voterConfigManager.applyReservedEntry(type, internalEntry, this.voterState(), this.state.getConfigState(), (ClientServerRpc)this);
    }

    @Override
    protected void onJournalFlushed() {
        if (null != this.leader) {
            this.leader.onJournalFlushed();
        }
    }

    private Config toConfig(Properties properties) {
        Config config = new Config();
        config.setElectionTimeoutMs(Long.parseLong(properties.getProperty("election_timeout_ms", String.valueOf(300L))));
        config.setSnapshotIntervalSec(Integer.parseInt(properties.getProperty("snapshot_interval_sec", String.valueOf(0))));
        config.setJournalRetentionMin(Integer.parseInt(properties.getProperty("journal_retention_min", String.valueOf(0))));
        config.setHeartbeatIntervalMs(Long.parseLong(properties.getProperty("heartbeat_interval_ms", String.valueOf(100L))));
        config.setTransactionTimeoutMs(Long.parseLong(properties.getProperty("transaction_timeout_ms", String.valueOf(600000L))));
        config.setReplicationBatchSize(Integer.parseInt(properties.getProperty("replication_batch_size", String.valueOf(128))));
        config.setCacheRequests(Integer.parseInt(properties.getProperty("cache_requests", String.valueOf(1024))));
        config.setEnablePreVote(Boolean.parseBoolean(properties.getProperty("enable_pre_vote", String.valueOf(true))));
        config.setRpcTimeoutMs(Long.parseLong(properties.getProperty("rpc_timeout_ms", String.valueOf(1000L))));
        config.setFlushIntervalMs(Long.parseLong(properties.getProperty("flush_interval_ms", String.valueOf(50L))));
        config.setPrintStateIntervalSec(Integer.parseInt(properties.getProperty("print_state_interval_sec", String.valueOf(0))));
        config.setWorkingDir(Paths.get(properties.getProperty("working_dir", config.getWorkingDir().normalize().toString()), new String[0]));
        config.setGetStateBatchSize(Integer.parseInt(properties.getProperty("get_state_batch_size", String.valueOf(0x100000))));
        config.setEnableMetric(Boolean.parseBoolean(properties.getProperty("enable_metric", String.valueOf(false))));
        config.setPrintMetricIntervalSec(Integer.parseInt(properties.getProperty("print_metric_interval_sec", String.valueOf(0))));
        config.setEnableEvents(Boolean.parseBoolean(properties.getProperty("enable_events", String.valueOf(true))));
        return config;
    }

    private void checkElectionTimeout() {
        try {
            if (this.voterState() == VoterState.FOLLOWER && System.currentTimeMillis() - this.lastHeartbeat > this.electionTimeoutMs) {
                this.convertToPreVoting();
                if (!this.config.isEnablePreVote()) {
                    this.convertToCandidate();
                }
                this.nextElectionTime = System.currentTimeMillis() + this.electionTimeoutMs;
            }
            if ((this.voterState() == VoterState.PRE_VOTING || this.voterState() == VoterState.CANDIDATE) && System.currentTimeMillis() > this.nextElectionTime) {
                this.startElection(false);
            }
            if (this.checkPreferredLeader()) {
                this.convertToPreVoting();
                this.convertToCandidate();
                this.startElection(true);
            }
        }
        catch (Throwable t) {
            logger.warn("CheckElectionTimeout Exception, {}: ", (Object)this.voterInfo(), (Object)t);
        }
    }

    private boolean isSingleNodeCluster() {
        return !this.state.getConfigState().isJointConsensus() && this.state.getConfigState().voters().size() == 1 && this.state.getConfigState().voters().contains(this.uri);
    }

    private void startElection(boolean fromPreferredLeader) {
        int term;
        boolean isPreVote;
        this.nextElectionTime = Long.MAX_VALUE;
        this.votedFor = this.uri;
        boolean bl = isPreVote = this.voterState.getState() == VoterState.PRE_VOTING;
        if (!isPreVote) {
            term = this.currentTerm.incrementAndGet();
            logger.info("Start election, {}", (Object)this.voterInfo());
        } else {
            term = this.currentTerm.get() + 1;
            logger.info("Start pre vote, {}", (Object)this.voterInfo());
        }
        long lastLogIndex = this.journal.maxIndex() - 1L;
        int lastLogTerm = this.journal.getTerm(lastLogIndex);
        RequestVoteRequest request = new RequestVoteRequest(term, this.uri, lastLogIndex, lastLogTerm, fromPreferredLeader, isPreVote);
        List destinations = this.state.getConfigState().voters().stream().filter(uri -> !uri.equals(this.uri)).collect(Collectors.toList());
        AtomicBoolean isWinTheElection = new AtomicBoolean(false);
        AtomicInteger votesGrantedInNewConfig = new AtomicInteger(0);
        AtomicInteger votesGrantedInOldConfig = new AtomicInteger(0);
        this.updateVotes(isWinTheElection, votesGrantedInNewConfig, votesGrantedInOldConfig, this.uri);
        if (!isWinTheElection.get()) {
            AtomicInteger pendingRequests = new AtomicInteger(destinations.size());
            for (URI destination : destinations) {
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.getServerRpc(destination).thenComposeAsync(serverRpc -> {
                    if (null != serverRpc) {
                        logger.info("Request vote, dest uri: {}, {}...", (Object)serverRpc.serverUri(), (Object)this.voterInfo());
                        return serverRpc.requestVote(request).thenApply(response -> {
                            response.setUri(serverRpc.serverUri());
                            return response;
                        });
                    }
                    return CompletableFuture.completedFuture(null);
                }, (Executor)this.asyncExecutor)).thenAccept(response -> {
                    if (null != response) {
                        logger.info("Request vote result {}, dest uri: {}, {}...", new Object[]{response.isVoteGranted(), response.getUri(), this.voterInfo()});
                        if (response.isVoteGranted()) {
                            this.updateVotes(isWinTheElection, votesGrantedInNewConfig, votesGrantedInOldConfig, response.getUri());
                        }
                    }
                })).exceptionally(e -> {
                    logger.warn("Request vote exception: {}!", (Object)e.getMessage());
                    return null;
                })).thenRun(() -> {
                    if (pendingRequests.decrementAndGet() == 0 && !isWinTheElection.get()) {
                        this.electionTimeoutMs = this.config.getElectionTimeoutMs() + this.randomInterval(this.config.getElectionTimeoutMs());
                        this.nextElectionTime = System.currentTimeMillis() + this.electionTimeoutMs;
                    }
                });
            }
        }
    }

    private void updateVotes(AtomicBoolean isWinTheElection, AtomicInteger votesGrantedInNewConfig, AtomicInteger votesGrantedInOldConfig, URI destination) {
        boolean win;
        ConfigState configState = this.state.getConfigState();
        if (configState.getConfigNew().contains(destination)) {
            votesGrantedInNewConfig.incrementAndGet();
        }
        if (configState.getConfigOld().contains(destination)) {
            votesGrantedInOldConfig.incrementAndGet();
        }
        if (configState.isJointConsensus()) {
            win = votesGrantedInNewConfig.get() >= configState.getConfigNew().size() / 2 + 1 && votesGrantedInOldConfig.get() >= configState.getConfigOld().size() / 2 + 1;
        } else {
            boolean bl = win = votesGrantedInNewConfig.get() >= configState.getConfigNew().size() / 2 + 1;
        }
        if (win && isWinTheElection.compareAndSet(false, true)) {
            if (this.voterState.getState() == VoterState.PRE_VOTING) {
                this.convertToCandidate();
                this.startElection(false);
            } else if (this.voterState.getState() == VoterState.CANDIDATE) {
                this.convertToLeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToCandidate() {
        VoterStateMachine voterStateMachine = this.voterState;
        synchronized (voterStateMachine) {
            VoterState oldState = this.voterState.getState();
            this.voterState.convertToCandidate();
            logger.info("Convert voter state from {} to CANDIDATE, electionTimeout: {}, {}.", new Object[]{oldState, this.electionTimeoutMs, this.voterInfo()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToPreVoting() {
        VoterStateMachine voterStateMachine = this.voterState;
        synchronized (voterStateMachine) {
            VoterState oldState = this.voterState.getState();
            if (oldState == VoterState.FOLLOWER && null != this.follower) {
                this.follower.stop();
                this.follower = null;
            }
            this.voterState.convertToPreVoting();
            logger.info("Convert voter state from {} to PRE_VOTING, electionTimeout: {}, {}.", new Object[]{oldState, this.electionTimeoutMs, this.voterInfo()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToLeader() {
        VoterStateMachine voterStateMachine = this.voterState;
        synchronized (voterStateMachine) {
            VoterState oldState = this.voterState.getState();
            this.voterState.convertToLeader();
            this.leader = new Leader(this.journal, this.state, this.snapshots, this.currentTerm.get(), this.uri, this.config.getCacheRequests(), this.config.getHeartbeatIntervalMs(), this.config.getRpcTimeoutMs(), this.config.getReplicationBatchSize(), this.config.getSnapshotIntervalSec(), this.threads, this, (ClientServerRpc)this, this.scheduledExecutor, this.voterConfigManager, this, this.journalEntryParser, this.config.getTransactionTimeoutMs(), this.snapshots);
            this.leader.start();
            this.leaderUri = this.uri;
            logger.info("Convert voter state from {} to LEADER, {}.", (Object)oldState, (Object)this.voterInfo());
        }
    }

    @Override
    protected void onJournalRecovered(Journal journal) {
        super.onJournalRecovered(journal);
        this.maybeUpdateTermOnRecovery(journal);
    }

    private void maybeUpdateTermOnRecovery(Journal journal) {
        JournalEntry lastEntry;
        if (journal.minIndex() < journal.maxIndex() && (lastEntry = journal.read(journal.maxIndex() - 1L)).getTerm() > this.currentTerm.get()) {
            this.currentTerm.set(lastEntry.getTerm());
            logger.info("Set current term to {}, this is the term of the last entry in the journal.", (Object)this.currentTerm.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToFollower() {
        VoterStateMachine voterStateMachine = this.voterState;
        synchronized (voterStateMachine) {
            VoterState oldState = this.voterState.getState();
            if (oldState == VoterState.LEADER && null != this.leader) {
                this.leader.stop();
                this.leader = null;
            }
            this.voterState.convertToFollower();
            if (oldState == VoterState.FOLLOWER && null != this.follower) {
                this.follower.stop();
                this.follower = null;
            }
            this.follower = new Follower(this.journal, this.state, this.uri, this.currentTerm.get(), this.voterConfigManager, this.threads, this.snapshots, this.config.getCacheRequests());
            this.follower.start();
            this.electionTimeoutMs = this.config.getElectionTimeoutMs() + this.randomInterval(this.config.getElectionTimeoutMs());
            logger.info("Convert voter state from {} to FOLLOWER, electionTimeout: {}, {}.", new Object[]{oldState, this.electionTimeoutMs, this.voterInfo()});
        }
    }

    public RaftServer.Roll roll() {
        return RaftServer.Roll.VOTER;
    }

    public CompletableFuture<AsyncAppendEntriesResponse> asyncAppendEntries(AsyncAppendEntriesRequest request) {
        this.checkTerm(request.getTerm());
        if (request.getTerm() < this.currentTerm.get()) {
            return CompletableFuture.supplyAsync(() -> new AsyncAppendEntriesResponse(false, request.getPrevLogIndex() + 1L, this.currentTerm.get(), request.getEntries().size()));
        }
        if (this.voterState() != VoterState.FOLLOWER) {
            this.convertToFollower();
        }
        if (logger.isDebugEnabled() && request.getEntries() != null && !request.getEntries().isEmpty()) {
            logger.debug("Received appendEntriesRequest, term: {}, leader: {}, prevLogIndex: {}, prevLogTerm: {}, entries: {}, leaderCommit: {}, {}.", new Object[]{request.getTerm(), request.getLeader(), request.getPrevLogIndex(), request.getPrevLogTerm(), request.getEntries().size(), request.getLeaderCommit(), this.voterInfo()});
        }
        this.lastHeartbeat = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("Update lastHeartbeat, {}.", (Object)this.voterInfo());
        }
        if (null != request.getLeader() && !request.getLeader().equals(this.leaderUri)) {
            this.leaderUri = request.getLeader();
        }
        return CompletableFuture.completedFuture(this.follower.handleAppendEntriesRequest(request));
    }

    public CompletableFuture<RequestVoteResponse> requestVote(RequestVoteRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            Object object = this.voteRequestMutex;
            synchronized (object) {
                logger.debug("RequestVoteRpc received: term: {}, candidate: {}, lastLogIndex: {}, lastLogTerm: {}, fromPreferredLeader: {}, isPreVote: {}, {}.", new Object[]{request.getTerm(), request.getCandidate(), request.getLastLogIndex(), request.getLastLogTerm(), request.isFromPreferredLeader(), request.isPreVote(), this.voterInfo()});
                int currentTerm = this.currentTerm.get();
                if (!request.isFromPreferredLeader()) {
                    if (this.voterState() == VoterState.LEADER) {
                        String rejectMsg = "I'm the leader";
                        return this.rejectAndResponse(currentTerm, request.getCandidate(), rejectMsg);
                    }
                    if (System.currentTimeMillis() - this.lastHeartbeat < this.config.getElectionTimeoutMs()) {
                        String rejectMsg = "An election timeout not passed since last heartbeat received";
                        return this.rejectAndResponse(currentTerm, request.getCandidate(), rejectMsg);
                    }
                }
                if (request.getTerm() < currentTerm) {
                    String rejectMsg = String.format("The candidate's term %d less than my term %d.", request.getTerm(), currentTerm);
                    return this.rejectAndResponse(currentTerm, request.getCandidate(), rejectMsg);
                }
                if (!request.isPreVote()) {
                    this.checkTerm(request.getTerm());
                    currentTerm = this.currentTerm.get();
                }
                if (this.votedFor != null && currentTerm == request.getTerm() && !this.votedFor.equals(request.getCandidate())) {
                    String rejectMsg = "Already vote to " + this.votedFor.toString();
                    return this.rejectAndResponse(currentTerm, request.getCandidate(), rejectMsg);
                }
                long finalMaxJournalIndex = this.journal.maxIndex();
                int lastLogTerm = this.journal.getTerm(finalMaxJournalIndex - 1L);
                if (request.getLastLogTerm() <= lastLogTerm && (request.getLastLogTerm() != lastLogTerm || request.getLastLogIndex() < finalMaxJournalIndex - 1L)) {
                    String rejectMsg = "Candidate\u2019s log is at least as up-to-date as my log";
                    return this.rejectAndResponse(currentTerm, request.getCandidate(), rejectMsg);
                }
                if (request.isPreVote()) {
                    logger.debug("Grant pre vote to candidate {}, {}.", (Object)request.getCandidate(), (Object)this.voterInfo());
                } else {
                    logger.debug("Grant vote to candidate {}, {}.", (Object)request.getCandidate(), (Object)this.voterInfo());
                    this.votedFor = request.getCandidate();
                }
                return new RequestVoteResponse(currentTerm, true);
            }
        }, this.asyncExecutor);
    }

    private RequestVoteResponse rejectAndResponse(int term, URI candidate, String rejectMessage) {
        logger.debug("Reject vote request from candidate {}, cause: [{}], {}.", new Object[]{candidate, rejectMessage, this.voterInfo()});
        return new RequestVoteResponse(term, false);
    }

    public CompletableFuture<DisableLeaderWriteResponse> disableLeaderWrite(DisableLeaderWriteRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.voterState() != VoterState.LEADER || null == this.leader) {
                throw new NotLeaderException(this.leaderUri);
            }
            this.leader.disableWrite(request.getTimeoutMs(), request.getTerm());
            return new DisableLeaderWriteResponse(this.currentTerm.get());
        }, this.asyncExecutor).exceptionally(DisableLeaderWriteResponse::new);
    }

    public CompletableFuture<InstallSnapshotResponse> installSnapshot(InstallSnapshotRequest request) {
        if (this.checkTerm(request.getTerm())) {
            return CompletableFuture.completedFuture(new InstallSnapshotResponse(this.currentTerm.get()));
        }
        this.lastHeartbeat = System.currentTimeMillis();
        return this.installSnapshotAsync(request);
    }

    private CompletableFuture<InstallSnapshotResponse> installSnapshotAsync(InstallSnapshotRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            InstallSnapshotResponse response;
            try {
                this.installSnapshot(request.getOffset(), request.getLastIncludedIndex(), request.getLastIncludedTerm(), request.getData(), request.isDone());
                response = new InstallSnapshotResponse(this.currentTerm.get());
            }
            catch (Throwable t) {
                logger.warn("Install snapshot exception!", t);
                response = new InstallSnapshotResponse(t);
            }
            return response;
        }, this.asyncExecutor);
    }

    public CompletableFuture<UpdateClusterStateResponse> updateClusterState(UpdateClusterStateRequest request) {
        Leader finalLeader = this.leader;
        if (this.isLeaderAvailable(finalLeader)) {
            return finalLeader.updateClusterState(request).exceptionally(UpdateClusterStateResponse::new);
        }
        return CompletableFuture.completedFuture(new UpdateClusterStateResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<QueryStateResponse> queryClusterState(QueryStateRequest request) {
        return ((CompletableFuture)((CompletableFuture)this.waitLeadership().thenApplyAsync(aVoid -> this.state.query(request.getQuery(), this.journal).getResult(), (Executor)this.asyncExecutor)).thenApply(QueryStateResponse::new)).exceptionally(exception -> {
            try {
                throw exception instanceof CompletionException ? exception.getCause() : exception;
            }
            catch (Throwable t) {
                return new QueryStateResponse(t);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkTerm(int term) {
        boolean isTermChanged;
        AtomicInteger atomicInteger = this.currentTerm;
        synchronized (atomicInteger) {
            if (term > this.currentTerm.get()) {
                logger.info("Set current term from {} to {}, {}.", new Object[]{this.currentTerm.get(), term, this.voterInfo()});
                this.currentTerm.set(term);
                this.votedFor = null;
                isTermChanged = true;
            } else {
                isTermChanged = false;
            }
        }
        if (isTermChanged) {
            this.convertToFollower();
        }
        return isTermChanged;
    }

    public CompletableFuture<LastAppliedResponse> lastApplied() {
        return ((CompletableFuture)this.waitLeadership().thenApplyAsync(aVoid -> new LastAppliedResponse(this.state.lastApplied()), (Executor)this.asyncExecutor)).exceptionally(exception -> {
            try {
                throw exception instanceof CompletionException ? exception.getCause() : exception;
            }
            catch (Throwable t) {
                return new LastAppliedResponse(t);
            }
        });
    }

    private CompletableFuture<Void> waitLeadership() {
        Leader finalLeader = this.leader;
        if (this.isLeaderAvailable(finalLeader)) {
            return finalLeader.waitLeadership();
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        future.completeExceptionally((Throwable)new NotLeaderException(this.leaderUri));
        return future;
    }

    public CompletableFuture<GetServerStatusResponse> getServerStatus() {
        return CompletableFuture.supplyAsync(() -> new ServerStatus(RaftServer.Roll.VOTER, this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex(), this.state.lastApplied(), this.voterState()), this.asyncExecutor).thenApply(GetServerStatusResponse::new);
    }

    public CompletableFuture<UpdateVotersResponse> updateVoters(UpdateVotersRequest request) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> new UpdateVotersS1Entry(request.getOldConfig(), request.getNewConfig()), this.asyncExecutor).thenApply(InternalEntriesSerializeSupport::serialize)).thenApply(entry -> new UpdateClusterStateRequest(new UpdateRequest(entry, Short.MAX_VALUE, 1)))).thenCompose(this::updateClusterState)).thenAccept(response -> {
            if (!response.success()) {
                throw new CompletionException((Throwable)new UpdateConfigurationException("Failed to update voters configuration in step 1. " + response.errorString()));
            }
        })).thenApply(aVoid -> new UpdateVotersResponse())).exceptionally(UpdateVotersResponse::new);
    }

    public CompletableFuture<CreateTransactionResponse> createTransaction(CreateTransactionRequest request) {
        if (this.voterState.getState() == VoterState.LEADER && this.leader != null) {
            return this.leader.createTransaction(request.getContext()).thenApply(context -> new CreateTransactionResponse((UUIDTransactionId)context.transactionId(), context.timestamp()));
        }
        return CompletableFuture.completedFuture(new CreateTransactionResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<CompleteTransactionResponse> completeTransaction(CompleteTransactionRequest request) {
        if (this.voterState.getState() == VoterState.LEADER && this.leader != null) {
            return this.leader.completeTransaction(request.getTransactionId(), request.isCommitOrAbort()).thenApply(aVoid -> new CompleteTransactionResponse());
        }
        return CompletableFuture.completedFuture(new CompleteTransactionResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<GetOpeningTransactionsResponse> getOpeningTransactions() {
        if (this.voterState.getState() == VoterState.LEADER && this.leader != null) {
            return CompletableFuture.completedFuture(this.leader.getOpeningTransactions()).thenApply(GetOpeningTransactionsResponse::new);
        }
        return CompletableFuture.completedFuture(new GetOpeningTransactionsResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    public CompletableFuture<CheckLeadershipResponse> checkLeadership() {
        return ((CompletableFuture)this.waitLeadership().thenApply(aVoid -> new CheckLeadershipResponse())).exceptionally(exception -> {
            try {
                throw exception instanceof CompletionException ? exception.getCause() : exception;
            }
            catch (Throwable t) {
                return new CheckLeadershipResponse(t);
            }
        });
    }

    private boolean isLeaderAvailable(Leader finalLeader) {
        return this.voterState() == VoterState.LEADER && finalLeader != null;
    }

    public CompletableFuture<GetSnapshotsResponse> getSnapshots() {
        if (this.voterState.getState() == VoterState.LEADER && this.leader != null) {
            return ((CompletableFuture)CompletableFuture.completedFuture(this.snapshots.values().stream().map(state -> new SnapshotEntry(state.lastApplied(), state.timestamp())).collect(Collectors.toList())).thenApply(SnapshotsEntry::new)).thenApply(GetSnapshotsResponse::new);
        }
        return CompletableFuture.completedFuture(new GetSnapshotsResponse((Throwable)new NotLeaderException(this.leaderUri)));
    }

    private void ensureLeadership(Leader finalLeader) {
        if (this.voterState() != VoterState.LEADER || finalLeader == null) {
            throw new NotLeaderException(this.leaderUri);
        }
    }

    private VoterState voterState() {
        return this.voterState.getState();
    }

    @Override
    public void doStart() {
        if (this.isSingleNodeCluster()) {
            this.convertToPreVoting();
            this.convertToCandidate();
            this.convertToLeader();
        } else {
            this.convertToFollower();
        }
        this.checkElectionTimeoutFuture = this.scheduledExecutor.scheduleAtFixedRate(this::checkElectionTimeout, ThreadLocalRandom.current().nextLong(500L, 1000L), this.config.getHeartbeatIntervalMs(), TimeUnit.MILLISECONDS);
        if (this.config.getPrintStateIntervalSec() > 0) {
            this.printStateFuture = this.scheduledExecutor.scheduleAtFixedRate(this::printState, ThreadLocalRandom.current().nextLong(0L, this.config.getPrintStateIntervalSec()), this.config.getPrintStateIntervalSec(), TimeUnit.SECONDS);
        }
    }

    private void printState() {
        logger.info(this.voterInfo());
    }

    @Override
    public void doStop() {
        try {
            this.stopAndWaitScheduledFeature(this.checkElectionTimeoutFuture, 1000L);
            this.stopAndWaitScheduledFeature(this.printStateFuture, 1000L);
            if (null != this.leader) {
                this.leader.stop();
            }
            if (null != this.follower) {
                this.follower.stop();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            logger.warn("Exception, {}: ", (Object)this.voterInfo(), (Object)t);
        }
    }

    @Override
    protected void afterStateChanged(byte[] updateResult) {
        super.afterStateChanged(updateResult);
        if (null != this.leader) {
            try {
                this.leader.callback(this.state.lastApplied(), updateResult);
            }
            catch (Throwable e) {
                logger.warn("Callback exception! {}", (Object)this.voterInfo(), (Object)e);
            }
        }
    }

    @Override
    protected ServerMetadata createServerMetadata() {
        ServerMetadata serverMetadata = super.createServerMetadata();
        serverMetadata.setCurrentTerm(this.currentTerm.get());
        serverMetadata.setVotedFor(this.votedFor);
        return serverMetadata;
    }

    @Override
    protected void onMetadataRecovered(ServerMetadata metadata) {
        super.onMetadataRecovered(metadata);
        this.currentTerm.set(metadata.getCurrentTerm());
        this.votedFor = metadata.getVotedFor();
    }

    private String voterInfo() {
        String ret = String.format("VoterState: %s, currentTerm: %d, minIndex: %d, maxIndex: %d, commitIndex: %d, lastApplied: %d, %s, leader: %s, uri: %s, ", this.voterState.getState(), this.currentTerm.get(), this.journal.minIndex(), this.journal.maxIndex(), this.journal.commitIndex(), this.state.lastApplied(), this.state.getConfigState().toString(), this.leaderUri, this.uri.toString());
        if (this.leader != null) {
            ret = ret + this.leader.getFollowers().stream().map(Leader.ReplicationDestination::toString).collect(Collectors.joining(", "));
        }
        return ret;
    }

    private boolean checkPreferredLeader() {
        if (this.voterState().equals((Object)VoterState.FOLLOWER) && this.serverUri().equals(this.state.getPreferredLeader()) && null != this.follower && this.follower.getLeaderMaxIndex() - this.journal.maxIndex() < 128L && this.follower.getLeaderMaxIndex() > 0L) {
            logger.info("Send DisableLeaderWriteRequest to {}, {}", (Object)this.leaderUri, (Object)this.voterInfo());
            ((CompletableFuture)this.getServerRpc(this.leaderUri).thenComposeAsync(serverRpc -> serverRpc.disableLeaderWrite(new DisableLeaderWriteRequest(10L * this.config.getElectionTimeoutMs(), this.currentTerm.get())), (Executor)this.asyncExecutor)).thenAccept(response -> {
                if (response.success() && response.getTerm() == this.currentTerm.get() && this.voterState() == VoterState.FOLLOWER && this.follower != null) {
                    logger.info("Received DisableLeaderWriteResponse code: SUCCESS, {}", (Object)this.voterInfo());
                    this.follower.setReadyForStartPreferredLeaderElection(true);
                } else {
                    logger.info("Ignore DisableLeaderWriteResponse code: {}, term: {}, errString: {}, {}", new Object[]{response.getStatusCode(), response.getTerm(), response.errorString(), this.voterInfo()});
                }
            });
        }
        return this.voterState().equals((Object)VoterState.FOLLOWER) && this.serverUri().equals(this.state.getPreferredLeader()) && null != this.follower && this.follower.isReadyForStartPreferredLeaderElection() && this.follower.getLeaderMaxIndex() == this.journal.maxIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VoterState getVoterState() {
        VoterStateMachine voterStateMachine = this.voterState;
        synchronized (voterStateMachine) {
            return this.voterState.getState();
        }
    }

    URI getLastVote() {
        return this.votedFor;
    }

    long getElectionTimeoutMs() {
        return this.electionTimeoutMs;
    }

    long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    URI getPreferredLeader() {
        return this.state.getPreferredLeader();
    }

    Leader getLeader() {
        return this.leader;
    }

    Follower getFollower() {
        return this.follower;
    }

    long getNextElectionTime() {
        return this.nextElectionTime;
    }

    int getTerm() {
        return this.currentTerm.get();
    }

    public static class Config
    extends AbstractServer.Config {
        public static final long DEFAULT_HEARTBEAT_INTERVAL_MS = 100L;
        public static final long DEFAULT_ELECTION_TIMEOUT_MS = 300L;
        public static final int DEFAULT_REPLICATION_BATCH_SIZE = 128;
        public static final int DEFAULT_CACHE_REQUESTS = 1024;
        public static final long DEFAULT_TRANSACTION_TIMEOUT_MS = 600000L;
        public static final int DEFAULT_PRINT_STATE_INTERVAL_SEC = 0;
        public static final boolean DEFAULT_ENABLE_PRE_VOTE = true;
        public static final String HEARTBEAT_INTERVAL_KEY = "heartbeat_interval_ms";
        public static final String ELECTION_TIMEOUT_KEY = "election_timeout_ms";
        public static final String REPLICATION_BATCH_SIZE_KEY = "replication_batch_size";
        public static final String CACHE_REQUESTS_KEY = "cache_requests";
        public static final String TRANSACTION_TIMEOUT_MS_KEY = "transaction_timeout_ms";
        public static final String PRINT_STATE_INTERVAL_SEC_KEY = "print_state_interval_sec";
        public static final String ENABLE_PRE_VOTE_KEY = "enable_pre_vote";
        private long heartbeatIntervalMs = 100L;
        private long electionTimeoutMs = 300L;
        private int replicationBatchSize = 128;
        private int cacheRequests = 1024;
        private long transactionTimeoutMs = 600000L;
        private int printStateIntervalSec = 0;
        private boolean enablePreVote = true;

        public int getReplicationBatchSize() {
            return this.replicationBatchSize;
        }

        public void setReplicationBatchSize(int replicationBatchSize) {
            this.replicationBatchSize = replicationBatchSize;
        }

        public long getHeartbeatIntervalMs() {
            return this.heartbeatIntervalMs;
        }

        public void setHeartbeatIntervalMs(long heartbeatIntervalMs) {
            this.heartbeatIntervalMs = heartbeatIntervalMs;
        }

        public long getElectionTimeoutMs() {
            return this.electionTimeoutMs;
        }

        public void setElectionTimeoutMs(long electionTimeoutMs) {
            this.electionTimeoutMs = electionTimeoutMs;
        }

        public int getCacheRequests() {
            return this.cacheRequests;
        }

        public void setCacheRequests(int cacheRequests) {
            this.cacheRequests = cacheRequests;
        }

        public long getTransactionTimeoutMs() {
            return this.transactionTimeoutMs;
        }

        public void setTransactionTimeoutMs(long transactionTimeoutMs) {
            this.transactionTimeoutMs = transactionTimeoutMs;
        }

        public int getPrintStateIntervalSec() {
            return this.printStateIntervalSec;
        }

        public void setPrintStateIntervalSec(int printStateIntervalSec) {
            this.printStateIntervalSec = printStateIntervalSec;
        }

        public boolean isEnablePreVote() {
            return this.enablePreVote;
        }

        public void setEnablePreVote(boolean enablePreVote) {
            this.enablePreVote = enablePreVote;
        }
    }

    private static class VoterStateMachine {
        private VoterState state = VoterState.FOLLOWER;

        private VoterStateMachine() {
        }

        private void convertToLeader() {
            if (this.state != VoterState.CANDIDATE) {
                throw new IllegalStateException(String.format("Change voter state from %s to %s is not allowed!", this.state, VoterState.LEADER));
            }
            this.state = VoterState.LEADER;
        }

        private void convertToFollower() {
            this.state = VoterState.FOLLOWER;
        }

        private void convertToCandidate() {
            if (this.state != VoterState.PRE_VOTING) {
                throw new IllegalStateException(String.format("Change voter state from %s to %s is not allowed!", this.state, VoterState.FOLLOWER));
            }
            this.state = VoterState.CANDIDATE;
        }

        private void convertToPreVoting() {
            if (this.state != VoterState.PRE_VOTING && this.state != VoterState.FOLLOWER) {
                throw new IllegalStateException(String.format("Change voter state from %s to %s is not allowed!", this.state, VoterState.FOLLOWER));
            }
            this.state = VoterState.PRE_VOTING;
        }

        public VoterState getState() {
            return this.state;
        }
    }
}

