/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.server;

import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.ResponseConfig;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.VoterState;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.UpdateVotersS1Entry;
import io.journalkeeper.core.entry.internal.UpdateVotersS2Entry;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.server.Leader;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoterConfigManager {
    private static final Logger logger = LoggerFactory.getLogger(VoterConfigManager.class);
    private final JournalEntryParser journalEntryParser;

    VoterConfigManager(JournalEntryParser journalEntryParser) {
        this.journalEntryParser = journalEntryParser;
    }

    boolean maybeUpdateLeaderConfig(UpdateRequest request, ConfigState votersConfigStateMachine, Journal journal, Callable appendEntryCallable, URI serverUri, Leader leader) throws Exception {
        if (request.getPartition() == Short.MAX_VALUE) {
            InternalEntryType entryType = InternalEntriesSerializeSupport.parseEntryType(request.getEntry());
            if (entryType == InternalEntryType.TYPE_UPDATE_VOTERS_S1) {
                UpdateVotersS1Entry updateVotersS1Entry = (UpdateVotersS1Entry)InternalEntriesSerializeSupport.parse(request.getEntry());
                this.waitingForAllEntriesCommitted(journal);
                votersConfigStateMachine.toJointConsensus(updateVotersS1Entry.getConfigOld(), updateVotersS1Entry.getConfigNew(), appendEntryCallable);
                Collection<URI> followerUris = leader.getFollowerUris();
                for (URI uri : updateVotersS1Entry.getConfigNew()) {
                    if (serverUri.equals(uri) || followerUris.contains(uri)) continue;
                    leader.addFollower(uri);
                }
                return true;
            }
            if (entryType == InternalEntryType.TYPE_UPDATE_VOTERS_S2) {
                this.waitingForAllEntriesCommitted(journal);
                votersConfigStateMachine.toNewConfig(appendEntryCallable);
                Collection<URI> followerUris = leader.getFollowerUris();
                for (URI uri : followerUris) {
                    if (votersConfigStateMachine.voters().contains(uri)) continue;
                    leader.removeFollower(uri);
                }
                return true;
            }
        }
        return false;
    }

    private void waitingForAllEntriesCommitted(Journal journal) throws InterruptedException {
        long t0 = System.nanoTime();
        while (journal.commitIndex() < journal.maxIndex()) {
            if (System.nanoTime() - t0 < 10000000000L) {
                Thread.yield();
                continue;
            }
            Thread.sleep(10L);
        }
    }

    void maybeRollbackConfig(long startIndex, Journal journal, ConfigState votersConfigStateMachine) {
        JournalEntry entry;
        if (startIndex >= journal.maxIndex()) {
            return;
        }
        long index = journal.maxIndex(Short.MAX_VALUE);
        long startOffset = journal.readOffset(startIndex);
        while (--index >= journal.minIndex(Short.MAX_VALUE) && (long)(entry = journal.readByPartition(Short.MAX_VALUE, index)).getOffset() >= startOffset) {
            InternalEntryType reservedEntryType = InternalEntriesSerializeSupport.parseEntryType(entry.getPayload().getBytes());
            if (reservedEntryType == InternalEntryType.TYPE_UPDATE_VOTERS_S2) {
                UpdateVotersS2Entry updateVotersS2Entry = (UpdateVotersS2Entry)InternalEntriesSerializeSupport.parse(entry.getPayload().getBytes());
                votersConfigStateMachine.rollbackToJointConsensus(updateVotersS2Entry.getConfigOld());
                continue;
            }
            if (reservedEntryType != InternalEntryType.TYPE_UPDATE_VOTERS_S1) continue;
            votersConfigStateMachine.rollbackToOldConfig();
        }
    }

    void maybeUpdateNonLeaderConfig(List<byte[]> entries, ConfigState votersConfigStateMachine) throws Exception {
        for (byte[] rawEntry : entries) {
            JournalEntry entryHeader = this.journalEntryParser.parseHeader(rawEntry);
            if (entryHeader.getPartition() != Short.MAX_VALUE) continue;
            int headerLength = this.journalEntryParser.headerLength();
            InternalEntryType entryType = InternalEntriesSerializeSupport.parseEntryType(rawEntry, headerLength, rawEntry.length - headerLength);
            if (entryType == InternalEntryType.TYPE_UPDATE_VOTERS_S1) {
                UpdateVotersS1Entry updateVotersS1Entry = (UpdateVotersS1Entry)InternalEntriesSerializeSupport.parse(rawEntry, headerLength, rawEntry.length - headerLength);
                votersConfigStateMachine.toJointConsensus(updateVotersS1Entry.getConfigOld(), updateVotersS1Entry.getConfigNew(), () -> null);
                continue;
            }
            if (entryType != InternalEntryType.TYPE_UPDATE_VOTERS_S2) continue;
            votersConfigStateMachine.toNewConfig(() -> null);
        }
    }

    void applyReservedEntry(InternalEntryType type, byte[] reservedEntry, VoterState voterState, ConfigState votersConfigStateMachine, ClientServerRpc clientServerRpc) {
        if (type == InternalEntryType.TYPE_UPDATE_VOTERS_S1 && voterState == VoterState.LEADER) {
            byte[] s2Entry = InternalEntriesSerializeSupport.serialize(new UpdateVotersS2Entry(votersConfigStateMachine.getConfigOld(), votersConfigStateMachine.getConfigNew()));
            try {
                if (!votersConfigStateMachine.isJointConsensus()) {
                    throw new IllegalStateException();
                }
                clientServerRpc.updateClusterState(new UpdateClusterStateRequest(Collections.singletonList(new UpdateRequest(s2Entry, Short.MAX_VALUE, 1)), false, ResponseConfig.ONE_WAY));
            }
            catch (Exception e) {
                UpdateVotersS1Entry updateVotersS1Entry = (UpdateVotersS1Entry)InternalEntriesSerializeSupport.parse(reservedEntry);
                logger.warn("Failed to update voter config in step 1! Config in the first step entry from: {} To: {}, voter config old: {}, new: {}.", new Object[]{updateVotersS1Entry.getConfigOld(), updateVotersS1Entry.getConfigNew(), votersConfigStateMachine.getConfigOld(), votersConfigStateMachine.getConfigNew(), e});
            }
        }
    }
}

