/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigState {
    private static final Logger logger = LoggerFactory.getLogger(ConfigState.class);
    private final List<URI> configNew = new ArrayList<URI>(3);
    private final List<URI> configOld = new ArrayList<URI>(3);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean jointConsensus;
    private List<URI> allVoters = new ArrayList<URI>(3);

    public ConfigState(List<URI> configOld, List<URI> configNew) {
        this.jointConsensus = true;
        this.configOld.addAll(configOld);
        this.configNew.addAll(configNew);
        this.buildAllVoters();
    }

    public ConfigState(List<URI> configNew) {
        this.jointConsensus = false;
        this.configNew.addAll(configNew);
        this.buildAllVoters();
    }

    private void buildAllVoters() {
        this.allVoters = Stream.concat(this.configNew.stream(), this.configOld.stream()).distinct().collect(Collectors.toList());
    }

    public List<URI> getConfigNew() {
        this.rwLock.readLock().lock();
        try {
            ArrayList<URI> arrayList = new ArrayList<URI>(this.configNew);
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public List<URI> getConfigOld() {
        this.rwLock.readLock().lock();
        try {
            ArrayList<URI> arrayList = new ArrayList<URI>(this.configOld);
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isJointConsensus() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.jointConsensus;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public List<URI> voters() {
        this.rwLock.readLock().lock();
        try {
            List<URI> list = this.allVoters;
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void toNewConfig(Callable appendEntryCallable) throws Exception {
        this.rwLock.writeLock().lock();
        try {
            if (!this.jointConsensus) {
                throw new IllegalStateException("Invalid joint consensus state! expected: jointConsensus == true, actual: false.");
            }
            logger.info("Config changed from joint consensus to new, ({}, {}) -> {}.", new Object[]{this.configOld, this.configNew, this.configNew});
            appendEntryCallable.call();
            this.jointConsensus = false;
            this.configOld.clear();
            this.buildAllVoters();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toJointConsensus(List<URI> configOld, List<URI> configNew, Callable appendEntryCallable) throws Exception {
        this.rwLock.writeLock().lock();
        try {
            if (this.jointConsensus) {
                throw new IllegalStateException("Invalid joint consensus state! expected: jointConsensus == false, actual: true.");
            }
            logger.info("Config changed to joint consensus, {} -> ({}, {}).", new Object[]{this.configNew, configOld, configNew});
            appendEntryCallable.call();
            this.jointConsensus = true;
            this.configOld.addAll(configOld);
            this.configNew.clear();
            this.configNew.addAll(configNew);
            this.buildAllVoters();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public ConfigState clone() {
        this.rwLock.readLock().lock();
        try {
            if (this.jointConsensus) {
                ConfigState configState = new ConfigState(new ArrayList<URI>(this.configOld), new ArrayList<URI>(this.configNew));
                return configState;
            }
            ConfigState configState = new ConfigState(new ArrayList<URI>(this.configNew));
            return configState;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public String toString() {
        this.rwLock.readLock().lock();
        try {
            String str = "jointConsensus: " + this.jointConsensus + ", ";
            if (this.jointConsensus) {
                str = str + "old config: [" + this.configOld.stream().map(URI::toString).collect(Collectors.joining(", ")) + "], ";
                str = str + "new config: [" + this.configNew.stream().map(URI::toString).collect(Collectors.joining(", ")) + "].";
            } else {
                str = str + "config: [" + this.configNew.stream().map(URI::toString).collect(Collectors.joining(", ")) + "].";
            }
            String string = str;
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void rollbackToOldConfig() {
        this.rwLock.writeLock().lock();
        try {
            if (!this.jointConsensus) {
                throw new IllegalStateException("Invalid joint consensus state! expected: jointConsensus == true, actual: false.");
            }
            logger.info("Config rollback from joint consensus to old, ({}, {}) -> {}.", new Object[]{this.configOld, this.configNew, this.configOld});
            this.jointConsensus = false;
            this.configNew.clear();
            this.configNew.addAll(this.configOld);
            this.configOld.clear();
            this.buildAllVoters();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void rollbackToJointConsensus(List<URI> configOld) {
        this.rwLock.writeLock().lock();
        try {
            if (this.jointConsensus) {
                throw new IllegalStateException("Invalid joint consensus state! expected: jointConsensus == false, actual: true.");
            }
            logger.info("Config rollback to joint consensus, {} -> ({}, {}).", new Object[]{this.configNew, configOld, this.configNew});
            this.jointConsensus = true;
            this.configOld.addAll(configOld);
            this.buildAllVoters();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

