/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import io.journalkeeper.base.ReplicableIterator;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class FolderTrunkIterator
implements ReplicableIterator {
    private final Path root;
    private final List<Path> files;
    private final int maxTrunkSize;
    private final long lastIncludedIndex;
    private final int lastIncludedTerm;
    private int fileIndex = 0;
    private long offsetOfCurrentFile = 0L;
    private long offset;

    public FolderTrunkIterator(Path root, List<Path> files, int maxTrunkSize, long lastIncludedIndex, int lastIncludedTerm) {
        this.root = root;
        this.maxTrunkSize = maxTrunkSize;
        this.lastIncludedIndex = lastIncludedIndex;
        this.lastIncludedTerm = lastIncludedTerm;
        this.files = this.toRelative(root, files);
        this.offset = 0L;
    }

    private List<Path> toRelative(Path root, List<Path> files) {
        return files.stream().map(root::relativize).collect(Collectors.toList());
    }

    public long lastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public int lastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public long offset() {
        return this.offset;
    }

    public byte[] nextTrunk() throws IOException {
        Path relFile = this.files.get(this.fileIndex);
        Path file = this.root.resolve(relFile);
        long fileSize = Files.size(file);
        byte[] filenameBytes = relFile.toString().getBytes(StandardCharsets.UTF_8);
        long remainingSize = fileSize + 4L + (long)filenameBytes.length + 8L - this.offsetOfCurrentFile;
        byte[] trunk = new byte[(int)Math.min(remainingSize, (long)this.maxTrunkSize)];
        ByteBuffer buffer = ByteBuffer.wrap(trunk);
        buffer.putInt(filenameBytes.length);
        buffer.put(filenameBytes);
        buffer.putLong(this.offsetOfCurrentFile);
        int sizeToRead = buffer.remaining();
        try (RandomAccessFile raf = new RandomAccessFile(file.toFile(), "r");
             FileChannel fc = raf.getChannel();){
            fc.position(this.offsetOfCurrentFile);
            while (buffer.hasRemaining()) {
                fc.read(buffer);
            }
        }
        this.offsetOfCurrentFile += (long)sizeToRead;
        if (this.offsetOfCurrentFile == fileSize) {
            ++this.fileIndex;
            this.offsetOfCurrentFile = 0L;
        }
        this.offset += (long)trunk.length;
        return trunk;
    }

    public boolean hasMoreTrunks() {
        return this.fileIndex < this.files.size();
    }
}

