/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import io.journalkeeper.core.journal.JournalSnapshot;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.utils.ThreadSafeFormat;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InternalState
implements JournalSnapshot {
    private ConfigState configState;
    private URI preferredLeader = null;
    private Map<Integer, Long> partitionIndices;
    private long lastIncludedIndex;
    private int lastIncludedTerm;
    private long minOffset;
    private long snapshotTimestamp = System.currentTimeMillis();

    public InternalState() {
    }

    public InternalState(ConfigState configState, Set<Integer> partitions, URI preferredLeader) {
        this.configState = configState;
        this.partitionIndices = new HashMap<Integer, Long>(partitions.size());
        for (Integer partition : partitions) {
            this.partitionIndices.put(partition, 0L);
        }
        this.preferredLeader = preferredLeader;
        this.lastIncludedIndex = -1L;
        this.lastIncludedTerm = -1;
        this.minOffset = 0L;
    }

    public URI getPreferredLeader() {
        return this.preferredLeader;
    }

    public void setPreferredLeader(URI preferredLeader) {
        this.preferredLeader = preferredLeader;
    }

    public Set<Integer> getPartitions() {
        return Collections.unmodifiableSet(this.partitionIndices.keySet());
    }

    public void setPartitions(Set<Integer> partitions) {
        HashMap<Integer, Long> copyOnWriteMap = new HashMap<Integer, Long>();
        for (Integer partition : partitions) {
            copyOnWriteMap.put(partition, this.partitionIndices.getOrDefault(partition, 0L));
        }
        this.partitionIndices = copyOnWriteMap;
    }

    public ConfigState getConfigState() {
        return this.configState;
    }

    public void setConfigState(ConfigState configState) {
        this.configState = configState;
    }

    public long getLastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public void setLastIncludedIndex(long lastIncludedIndex) {
        this.lastIncludedIndex = lastIncludedIndex;
    }

    public int getLastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public void setLastIncludedTerm(int lastIncludedTerm) {
        this.lastIncludedTerm = lastIncludedTerm;
    }

    public void next() {
        ++this.lastIncludedIndex;
    }

    @Override
    public Map<Integer, Long> partitionMinIndices() {
        return Collections.unmodifiableMap(this.partitionIndices);
    }

    @Override
    public long minIndex() {
        return this.lastIncludedIndex + 1L;
    }

    @Override
    public long minOffset() {
        return this.minOffset;
    }

    public long getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public void setSnapshotTimestamp(long snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    public Map<Integer, Long> getPartitionIndices() {
        return Collections.unmodifiableMap(this.partitionIndices);
    }

    public void setPartitionIndices(Map<Integer, Long> partitionIndices) {
        this.partitionIndices = new HashMap<Integer, Long>(partitionIndices);
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public void setMinOffset(long minOffset) {
        this.minOffset = minOffset;
    }

    public String toString() {
        return "InternalState{configState=" + this.configState + ", preferredLeader=" + this.preferredLeader + ", partitionIndices=" + this.partitionIndices + ", lastIncludedIndex=" + this.lastIncludedIndex + ", lastIncludedTerm=" + this.lastIncludedTerm + ", minOffset=" + this.minOffset + ", snapshotTimestamp=" + ThreadSafeFormat.format((Date)new Date(this.snapshotTimestamp)) + '}';
    }
}

