/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import io.journalkeeper.base.Replicable;
import io.journalkeeper.base.ReplicableIterator;
import io.journalkeeper.core.api.EntryFuture;
import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.RaftJournal;
import io.journalkeeper.core.api.State;
import io.journalkeeper.core.api.StateFactory;
import io.journalkeeper.core.api.StateResult;
import io.journalkeeper.core.entry.internal.InternalEntriesSerializeSupport;
import io.journalkeeper.core.entry.internal.InternalEntryType;
import io.journalkeeper.core.entry.internal.ScalePartitionsEntry;
import io.journalkeeper.core.entry.internal.SetPreferredLeaderEntry;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.journal.JournalSnapshot;
import io.journalkeeper.core.state.ApplyInternalEntryInterceptor;
import io.journalkeeper.core.state.ApplyReservedEntryInterceptor;
import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.core.state.FolderTrunkIterator;
import io.journalkeeper.core.state.InternalState;
import io.journalkeeper.core.state.PersistInternalState;
import io.journalkeeper.core.state.StateQueryResult;
import io.journalkeeper.exceptions.StateRecoverException;
import io.journalkeeper.persistence.MetadataPersistence;
import io.journalkeeper.utils.files.FileUtils;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalKeeperState
implements Replicable,
Flushable {
    private static final Logger logger = LoggerFactory.getLogger(JournalKeeperState.class);
    private static final String USER_STATE_PATH = "user";
    private static final String INTERNAL_STATE_PATH = "internal";
    private static final String INTERNAL_STATE_FILE = "state";
    private static final int MAX_TRUNK_SIZE = 0x100000;
    private final Map<InternalEntryType, List<ApplyInternalEntryInterceptor>> internalEntryInterceptors = new HashMap<InternalEntryType, List<ApplyInternalEntryInterceptor>>();
    private final List<ApplyReservedEntryInterceptor> reservedEntryInterceptors = new CopyOnWriteArrayList<ApplyReservedEntryInterceptor>();
    private final StateFactory userStateFactory;
    private final MetadataPersistence metadataPersistence;
    private final ReadWriteLock stateFilesLock = new ReentrantReadWriteLock();
    private final StampedLock stateLock = new StampedLock();
    private Path path;
    private State userState;
    private InternalState internalState;
    private Properties properties;
    private AtomicBoolean isUserStateAvailable = new AtomicBoolean(false);

    public JournalKeeperState(StateFactory userStateFactory, MetadataPersistence metadataPersistence) {
        this.userStateFactory = userStateFactory;
        this.metadataPersistence = metadataPersistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Path path, List<URI> voters, Set<Integer> partitions, URI preferredLeader) throws IOException {
        Files.createDirectories(path.resolve(USER_STATE_PATH), new FileAttribute[0]);
        InternalState internalState = new InternalState(new ConfigState(voters), partitions, preferredLeader);
        File lockFile = path.getParent().resolve(path.getFileName() + ".lock").toFile();
        try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
             FileChannel fileChannel = raf.getChannel();){
            FileLock lock = fileChannel.tryLock();
            if (null == lock) {
                throw new ConcurrentModificationException(String.format("Some other thread is operating the state files! State: %s.", path.toString()));
            }
            this.flushInternalState(this.internalStateFile(path), internalState);
            lock.release();
        }
        finally {
            lockFile.delete();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.stateFilesLock.writeLock().lock();
            this.flushInternalState();
            if (this.isUserStateAvailable.get()) {
                this.flushUserState();
            }
        }
        finally {
            this.stateFilesLock.writeLock().unlock();
        }
    }

    private void flushUserState(State userState) throws IOException {
        if (userState instanceof Flushable) {
            ((Flushable)userState).flush();
        }
    }

    private void flushUserState() throws IOException {
        this.flushUserState(this.userState);
    }

    private void flushInternalState() throws IOException {
        this.flushInternalState(this.internalStateFile(this.path), this.internalState);
    }

    private Path internalStateFile(Path statePath) {
        return statePath.resolve(INTERNAL_STATE_PATH).resolve(INTERNAL_STATE_FILE);
    }

    private void flushInternalState(Path internalStateFile, InternalState internalState) throws IOException {
        this.metadataPersistence.save(internalStateFile, (Object)new PersistInternalState().fromInternalState(internalState));
    }

    public void recover(Path path, Properties properties) {
        this.recover(path, properties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(Path path, Properties properties, boolean internalStateOnly) {
        this.stateFilesLock.writeLock().lock();
        try {
            this.recoverUnsafe(path, properties, internalStateOnly);
        }
        finally {
            this.stateFilesLock.writeLock().unlock();
        }
    }

    public void recoverUnsafe(Path path, Properties properties, boolean internalStateOnly) {
        this.path = path;
        this.properties = properties;
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            this.internalState = this.recoverInternalState(this.internalStateFile(path));
            if (!internalStateOnly) {
                this.recoverUserStateUnsafe();
            }
        }
        catch (IOException e) {
            throw new StateRecoverException((Throwable)e);
        }
    }

    private InternalState recoverInternalState(Path internalStateFile) throws IOException {
        return ((PersistInternalState)this.metadataPersistence.load(internalStateFile, PersistInternalState.class)).toInternalState();
    }

    public synchronized void addInterceptor(InternalEntryType type, ApplyInternalEntryInterceptor internalEntryInterceptor) {
        List list = this.internalEntryInterceptors.computeIfAbsent(type, key -> new LinkedList());
        list.add(internalEntryInterceptor);
    }

    public synchronized void removeInterceptor(InternalEntryType type, ApplyInternalEntryInterceptor internalEntryInterceptor) {
        List<ApplyInternalEntryInterceptor> list = this.internalEntryInterceptors.get((Object)type);
        if (null != list) {
            list.remove(internalEntryInterceptor);
        }
    }

    public synchronized void addInterceptor(ApplyReservedEntryInterceptor interceptor) {
        this.reservedEntryInterceptors.add(interceptor);
    }

    public synchronized void removeInterceptor(ApplyReservedEntryInterceptor interceptor) {
        this.reservedEntryInterceptors.remove(interceptor);
    }

    public Path getPath() {
        return this.path;
    }

    public long lastIncludedIndex() {
        return this.internalState.getLastIncludedIndex();
    }

    public int lastIncludedTerm() {
        return this.internalState.getLastIncludedTerm();
    }

    public long lastApplied() {
        return this.lastIncludedIndex() + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateResult applyEntry(JournalEntry entryHeader, EntryFuture entryFuture, RaftJournal journal) {
        int partition = entryHeader.getPartition();
        int batchSize = entryHeader.getBatchSize();
        StateResult result = new StateResult(null);
        long stamp = this.stateLock.writeLock();
        try {
            if (partition < 30000) {
                result = this.userState.execute(entryFuture, partition, this.lastApplied(), batchSize, journal);
            } else if (partition == Short.MAX_VALUE) {
                this.applyInternalEntry(entryFuture.get());
            } else {
                for (ApplyReservedEntryInterceptor reservedEntryInterceptor : this.reservedEntryInterceptors) {
                    reservedEntryInterceptor.applyReservedEntry(entryHeader, entryFuture, this.lastApplied());
                }
            }
            this.internalState.setLastIncludedTerm(entryHeader.getTerm());
            this.internalState.next();
            result.setLastApplied(this.lastApplied());
        }
        finally {
            this.stateLock.unlockWrite(stamp);
        }
        return result;
    }

    private void applyInternalEntry(byte[] internalEntry) {
        InternalEntryType type = InternalEntriesSerializeSupport.parseEntryType(internalEntry);
        logger.info("Apply internal entry, type: {}", (Object)type);
        switch (type) {
            case TYPE_SCALE_PARTITIONS: {
                this.internalState.setPartitions(InternalEntriesSerializeSupport.parse(internalEntry, ScalePartitionsEntry.class).getPartitions());
                break;
            }
            case TYPE_SET_PREFERRED_LEADER: {
                SetPreferredLeaderEntry setPreferredLeaderEntry = (SetPreferredLeaderEntry)InternalEntriesSerializeSupport.parse(internalEntry);
                URI old = this.internalState.getPreferredLeader();
                this.internalState.setPreferredLeader(setPreferredLeaderEntry.getPreferredLeader());
                logger.info("Set preferred leader from {} to {}.", (Object)old, (Object)this.internalState.getPreferredLeader());
                break;
            }
        }
        List<ApplyInternalEntryInterceptor> interceptors = this.internalEntryInterceptors.get((Object)type);
        if (null != interceptors) {
            for (ApplyInternalEntryInterceptor interceptor : interceptors) {
                interceptor.applyInternalEntry(type, internalEntry);
            }
        }
        try {
            this.flushInternalState();
        }
        catch (IOException e) {
            logger.warn("Flush internal state exception! Path: {}.", (Object)this.path, (Object)e);
        }
    }

    private void maybeRecoverUserState() throws IOException {
        long stamp = this.stateLock.writeLock();
        try {
            this.recoverUserStateUnsafe();
        }
        finally {
            this.stateLock.unlockWrite(stamp);
        }
    }

    public void recoverUserStateUnsafe() throws IOException {
        this.userState = this.userStateFactory.createState();
        Path userStatePath = this.path.resolve(USER_STATE_PATH);
        Files.createDirectories(userStatePath, new FileAttribute[0]);
        this.userState.recover(this.path.resolve(USER_STATE_PATH), this.properties);
        this.isUserStateAvailable.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateQueryResult query(byte[] query, RaftJournal journal) {
        long stamp = this.stateLock.tryOptimisticRead();
        StateQueryResult result = new StateQueryResult(this.userState.query(query, journal), this.lastApplied());
        if (!this.stateLock.validate(stamp)) {
            stamp = this.stateLock.readLock();
            try {
                result = new StateQueryResult(this.userState.query(query, journal), this.lastApplied());
            }
            finally {
                this.stateLock.unlockRead(stamp);
            }
        }
        return result;
    }

    public void dump(Path destPath) throws IOException {
        this.flush();
        try {
            this.stateFilesLock.readLock().lock();
            FileUtils.dump((Path)this.path, (Path)destPath);
        }
        finally {
            this.stateFilesLock.readLock().unlock();
        }
    }

    public void dumpUserState(Path destPath) throws IOException {
        this.flush();
        try {
            this.stateFilesLock.readLock().lock();
            FileUtils.dump((Path)this.path.resolve(USER_STATE_PATH), (Path)destPath.resolve(USER_STATE_PATH));
        }
        finally {
            this.stateFilesLock.readLock().unlock();
        }
    }

    private List<Path> listAllFiles(Path path) throws IOException {
        return FileUtils.listAllFiles((Path)path);
    }

    public List<URI> voters() {
        return this.internalState.getConfigState().voters();
    }

    public ReplicableIterator iterator() throws IOException {
        return new FolderTrunkIterator(this.path, this.listAllFiles(this.path), 0x100000, this.lastIncludedIndex(), this.lastIncludedTerm());
    }

    public void close() {
        long stamp = this.stateLock.writeLock();
        try {
            this.closeUnsafe();
        }
        finally {
            this.stateLock.unlockWrite(stamp);
        }
    }

    public void closeUnsafe() {
        if (this.isUserStateAvailable.compareAndSet(true, false) && null != this.userState) {
            this.userState.close();
        }
    }

    public void clearUserState() throws IOException {
        FileUtils.deleteFolder((Path)this.path.resolve(USER_STATE_PATH));
    }

    public void clear() throws IOException {
        FileUtils.deleteFolder((Path)this.path);
    }

    public ConfigState getConfigState() {
        return this.internalState.getConfigState();
    }

    public void setConfigState(ConfigState configState) {
        this.internalState.setConfigState(configState);
    }

    public Set<Integer> getPartitions() {
        return this.internalState.getPartitions();
    }

    public URI getPreferredLeader() {
        return this.internalState.getPreferredLeader();
    }

    public JournalSnapshot getJournalSnapshot() {
        return this.internalState;
    }

    public void createSnapshot(Journal journal) throws IOException {
        this.internalState.setSnapshotTimestamp(System.currentTimeMillis());
        this.internalState.setMinOffset(journal.maxIndex() == this.internalState.minIndex() ? journal.maxOffset() : journal.readOffset(this.internalState.minIndex()));
        Map<Integer, Long> partitionIndices = journal.calcPartitionIndices(this.internalState.minOffset());
        this.internalState.setPartitionIndices(partitionIndices);
        this.flushInternalState();
    }

    public long timestamp() {
        return this.internalState.getSnapshotTimestamp();
    }

    public String toString() {
        return "JournalKeeperState{internalState=" + this.internalState + ", path=" + this.path + '}';
    }
}

