/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import io.journalkeeper.core.state.ConfigState;
import io.journalkeeper.core.state.InternalState;
import java.net.URI;
import java.util.List;
import java.util.Map;

public class PersistInternalState {
    private URI preferredLeader = null;
    private Map<Integer, Long> partitionIndices;
    private long lastIncludedIndex;
    private int lastIncludedTerm;
    private List<URI> configNew;
    private List<URI> configOld;
    private boolean jointConsensus;
    private long minOffset;
    private long snapshotTimestamp;

    public URI getPreferredLeader() {
        return this.preferredLeader;
    }

    public void setPreferredLeader(URI preferredLeader) {
        this.preferredLeader = preferredLeader;
    }

    public Map<Integer, Long> getPartitionIndices() {
        return this.partitionIndices;
    }

    public void setPartitionIndices(Map<Integer, Long> partitionIndices) {
        this.partitionIndices = partitionIndices;
    }

    public long getLastIncludedIndex() {
        return this.lastIncludedIndex;
    }

    public void setLastIncludedIndex(long lastIncludedIndex) {
        this.lastIncludedIndex = lastIncludedIndex;
    }

    public int getLastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public void setLastIncludedTerm(int lastIncludedTerm) {
        this.lastIncludedTerm = lastIncludedTerm;
    }

    public List<URI> getConfigNew() {
        return this.configNew;
    }

    public void setConfigNew(List<URI> configNew) {
        this.configNew = configNew;
    }

    public List<URI> getConfigOld() {
        return this.configOld;
    }

    public void setConfigOld(List<URI> configOld) {
        this.configOld = configOld;
    }

    public boolean isJointConsensus() {
        return this.jointConsensus;
    }

    public void setJointConsensus(boolean jointConsensus) {
        this.jointConsensus = jointConsensus;
    }

    InternalState toInternalState() {
        ConfigState configState = this.isJointConsensus() ? new ConfigState(this.configOld, this.configNew) : new ConfigState(this.configNew);
        InternalState internalState = new InternalState();
        internalState.setConfigState(configState);
        internalState.setPartitionIndices(this.getPartitionIndices());
        internalState.setPreferredLeader(this.getPreferredLeader());
        internalState.setLastIncludedTerm(this.getLastIncludedTerm());
        internalState.setLastIncludedIndex(this.getLastIncludedIndex());
        internalState.setMinOffset(this.getMinOffset());
        internalState.setSnapshotTimestamp(this.getSnapshotTimestamp());
        return internalState;
    }

    PersistInternalState fromInternalState(InternalState internalState) {
        ConfigState configState = internalState.getConfigState();
        this.setJointConsensus(configState.isJointConsensus());
        this.setConfigNew(configState.getConfigNew());
        this.setConfigOld(configState.getConfigOld());
        this.setLastIncludedIndex(internalState.getLastIncludedIndex());
        this.setLastIncludedTerm(internalState.getLastIncludedTerm());
        this.setPartitionIndices(internalState.getPartitionIndices());
        this.setPreferredLeader(internalState.getPreferredLeader());
        this.setMinOffset(internalState.getMinOffset());
        this.setSnapshotTimestamp(internalState.getSnapshotTimestamp());
        return this;
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public void setMinOffset(long minOffset) {
        this.minOffset = minOffset;
    }

    public long getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    public void setSnapshotTimestamp(long snapshotTimestamp) {
        this.snapshotTimestamp = snapshotTimestamp;
    }

    public String toString() {
        return "PersistInternalState{preferredLeader=" + this.preferredLeader + ", partitionIndices=" + this.partitionIndices + ", lastIncludedIndex=" + this.lastIncludedIndex + ", lastIncludedTerm=" + this.lastIncludedTerm + ", configNew=" + this.configNew + ", configOld=" + this.configOld + ", jointConsensus=" + this.jointConsensus + ", minOffset=" + this.minOffset + ", snapshotTimestamp=" + this.snapshotTimestamp + '}';
    }
}

