/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.state;

import io.journalkeeper.utils.files.DoubleCopy;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;

public class StateMetadata
extends DoubleCopy {
    private long lastApplied = 0L;
    private int lastIncludedTerm = 0;

    public StateMetadata(File file) throws IOException {
        super(file, 128);
    }

    protected String getName() {
        return "StateMetadata";
    }

    protected byte[] serialize() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(12);
        byteBuffer.putLong(this.getLastApplied());
        byteBuffer.putInt(this.getLastIncludedTerm());
        byteBuffer.flip();
        return byteBuffer.array();
    }

    protected void parse(byte[] data) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        this.setLastApplied(byteBuffer.getLong());
        this.setLastIncludedTerm(byteBuffer.getInt());
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    public void setLastApplied(long lastApplied) {
        this.increaseVersion();
        this.lastApplied = lastApplied;
    }

    public int getLastIncludedTerm() {
        return this.lastIncludedTerm;
    }

    public void setLastIncludedTerm(int lastIncludedTerm) {
        this.increaseVersion();
        this.lastIncludedTerm = lastIncludedTerm;
    }
}

