/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.strategy;

import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.strategy.JournalCompactionStrategy;
import io.journalkeeper.utils.ThreadSafeFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJournalCompactionStrategy
implements JournalCompactionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultJournalCompactionStrategy.class);
    private final int retentionMin;

    public DefaultJournalCompactionStrategy(int journalRetentionMin) {
        this.retentionMin = journalRetentionMin;
    }

    @Override
    public long calculateCompactionIndex(SortedMap<Long, Long> snapshotTimestamps, Journal journal) {
        long index = -1L;
        long now = System.currentTimeMillis();
        if (this.retentionMin > 0) {
            long compactTimestamp = now - (long)(this.retentionMin * 60) * 1000L;
            for (Map.Entry<Long, Long> entry : snapshotTimestamps.entrySet()) {
                long snapshotIndex = entry.getKey();
                long snapshotTimestamp = entry.getValue();
                if (snapshotTimestamp > compactTimestamp) break;
                index = snapshotIndex;
            }
            logger.info("Calculate journal compaction index: {}, current timestamp: {}.", (Object)index, (Object)ThreadSafeFormat.format((Date)new Date(now)));
        }
        return index;
    }
}

