/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.transaction;

import io.journalkeeper.core.api.EntryFuture;
import io.journalkeeper.core.api.JournalEntry;
import io.journalkeeper.core.api.JournalEntryParser;
import io.journalkeeper.core.api.UpdateRequest;
import io.journalkeeper.core.api.transaction.JournalKeeperTransactionContext;
import io.journalkeeper.core.api.transaction.UUIDTransactionId;
import io.journalkeeper.core.journal.Journal;
import io.journalkeeper.core.transaction.JournalTransactionState;
import io.journalkeeper.core.transaction.TransactionEntry;
import io.journalkeeper.core.transaction.TransactionEntrySerializer;
import io.journalkeeper.core.transaction.TransactionEntryType;
import io.journalkeeper.exceptions.JournalException;
import io.journalkeeper.exceptions.TransactionException;
import io.journalkeeper.rpc.client.ClientServerRpc;
import io.journalkeeper.rpc.client.UpdateClusterStateRequest;
import io.journalkeeper.utils.state.ServerStateMachine;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;

public class JournalTransactionManager
extends ServerStateMachine {
    public static final int TRANSACTION_PARTITION_START = 30000;
    public static final int TRANSACTION_PARTITION_COUNT = 32;
    private final ClientServerRpc server;
    private final JournalTransactionState transactionState;
    private final Map<UUID, CompletableFuture<Void>> pendingCompleteTransactionFutures = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private final TransactionEntrySerializer transactionEntrySerializer = new TransactionEntrySerializer();

    public JournalTransactionManager(Journal journal, ClientServerRpc server, ScheduledExecutorService scheduledExecutor, long transactionTimeoutMs) {
        this.server = server;
        this.transactionState = new JournalTransactionState(journal, transactionTimeoutMs, server, scheduledExecutor);
    }

    protected void doStart() {
        super.doStart();
        this.transactionState.start();
    }

    protected void doStop() {
        this.transactionState.stop();
        super.doStop();
    }

    public CompletableFuture<JournalKeeperTransactionContext> createTransaction(Map<String, String> context) {
        int partition = this.transactionState.nextFreePartition();
        UUID transactionId = UUID.randomUUID();
        TransactionEntry entry = new TransactionEntry(transactionId, context);
        long timestamp = entry.getTimestamp();
        byte[] serializedEntry = this.transactionEntrySerializer.serialize(entry);
        return this.server.updateClusterState(new UpdateClusterStateRequest(new UpdateRequest(serializedEntry, partition, 1))).thenApply(response -> {
            if (response.success()) {
                return new JournalKeeperTransactionContext(new UUIDTransactionId(transactionId), context, timestamp);
            }
            throw new JournalException(response.errorString());
        });
    }

    public CompletableFuture<Void> completeTransaction(UUID transactionId, boolean completeOrAbort) {
        int partition = this.getTransactionPartition(transactionId);
        this.ensureTransactionOpen(transactionId);
        TransactionEntry entry = new TransactionEntry(transactionId, TransactionEntryType.TRANSACTION_PRE_COMPLETE, completeOrAbort);
        byte[] serializedEntry = this.transactionEntrySerializer.serialize(entry);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.pendingCompleteTransactionFutures.put(transactionId, future);
        this.server.updateClusterState(new UpdateClusterStateRequest(new UpdateRequest(serializedEntry, partition, 1))).thenAccept(response -> {
            CompletableFuture<Void> retFuture;
            if (!response.success() && null != (retFuture = this.pendingCompleteTransactionFutures.remove(transactionId))) {
                retFuture.completeExceptionally((Throwable)new TransactionException(response.errorString()));
            }
        });
        return future;
    }

    public JournalEntry wrapTransactionalEntry(JournalEntry entry, UUID transactionId, JournalEntryParser journalEntryParser) {
        return this.transactionState.wrapTransactionalEntry(entry, transactionId, journalEntryParser);
    }

    private void ensureTransactionOpen(UUID transactionId) {
        this.transactionState.ensureTransactionOpen(transactionId);
    }

    private int getTransactionPartition(UUID transactionId) {
        return this.transactionState.getPartition(transactionId);
    }

    public Collection<JournalKeeperTransactionContext> getOpeningTransactions() {
        return this.transactionState.getOpeningTransactions();
    }

    public void applyEntry(JournalEntry entryHeader, EntryFuture entryFuture) {
        int partition = entryHeader.getPartition();
        if (this.transactionState.isTransactionPartition(partition)) {
            TransactionEntry transactionEntry = this.transactionEntrySerializer.parse(entryFuture.get());
            this.transactionState.applyEntry(transactionEntry, partition, this.pendingCompleteTransactionFutures);
        }
    }
}

