/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.transaction;

import io.journalkeeper.core.transaction.TransactionEntryType;
import java.util.Map;
import java.util.UUID;

public class TransactionEntry {
    private final TransactionEntryType type;
    private final UUID transactionId;
    private int partition = -1;
    private boolean commitOrAbort = false;
    private byte[] entry = new byte[0];
    private int batchSize = 1;
    private long timestamp = System.currentTimeMillis();
    private Map<String, String> context;

    public TransactionEntry(UUID transactionId, Map<String, String> context) {
        this.transactionId = transactionId;
        this.context = context;
        this.type = TransactionEntryType.TRANSACTION_START;
    }

    public TransactionEntry(UUID transactionId, TransactionEntryType type, boolean commitOrAbort) {
        this.type = type;
        this.transactionId = transactionId;
        this.commitOrAbort = commitOrAbort;
    }

    public TransactionEntry(UUID transactionId, int partition, int batchSize, byte[] entry) {
        this.transactionId = transactionId;
        this.type = TransactionEntryType.TRANSACTION_ENTRY;
        this.partition = partition;
        this.batchSize = batchSize;
        this.entry = entry;
    }

    public TransactionEntry(UUID transactionId, long timestamp, TransactionEntryType type, int partition, boolean commitOrAbort, int batchSize, byte[] entry, Map<String, String> context) {
        this.transactionId = transactionId;
        this.timestamp = timestamp;
        this.type = type;
        this.partition = partition;
        this.commitOrAbort = commitOrAbort;
        this.batchSize = batchSize;
        this.entry = entry;
        this.context = context;
    }

    public TransactionEntryType getType() {
        return this.type;
    }

    public UUID getTransactionId() {
        return this.transactionId;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean isCommitOrAbort() {
        return this.commitOrAbort;
    }

    public byte[] getEntry() {
        return this.entry;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getContext() {
        return this.context;
    }
}

