/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.core.transaction;

import io.journalkeeper.base.Serializer;
import io.journalkeeper.core.transaction.TransactionEntry;
import io.journalkeeper.core.transaction.TransactionEntryType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;

public class TransactionEntrySerializer
implements Serializer<TransactionEntry> {
    private static final int FIXED_LENGTH = 30;

    public byte[] serialize(TransactionEntry entry) {
        int size = 34 + (entry.getEntry() == null ? 0 : entry.getEntry().length) + 4 + (entry.getContext() == null ? 0 : Stream.concat(entry.getContext().keySet().stream(), entry.getContext().values().stream()).mapToInt(s -> 4 + s.getBytes(StandardCharsets.UTF_8).length).sum());
        byte[] bytes = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.serializeUUID(entry.getTransactionId(), buffer);
        buffer.putLong(entry.getTimestamp());
        buffer.put((byte)entry.getType().value());
        buffer.putShort((short)entry.getPartition());
        buffer.put(entry.isCommitOrAbort() ? (byte)1 : 0);
        buffer.putShort((short)entry.getBatchSize());
        if (entry.getEntry() == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(entry.getEntry().length);
            buffer.put(entry.getEntry());
        }
        if (entry.getContext() == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(entry.getContext().size());
            entry.getContext().entrySet().stream().flatMap(e -> Stream.of((String)e.getKey(), (String)e.getValue())).forEach(s -> {
                byte[] sb = s.getBytes(StandardCharsets.UTF_8);
                buffer.putInt(sb.length);
                buffer.put(sb);
            });
        }
        return bytes;
    }

    private void serializeUUID(UUID uuid, ByteBuffer buffer) {
        long mostSigBits = 0L;
        long leastSigBits = 0L;
        if (null != uuid) {
            mostSigBits = uuid.getMostSignificantBits();
            leastSigBits = uuid.getLeastSignificantBits();
        }
        buffer.putLong(mostSigBits);
        buffer.putLong(leastSigBits);
    }

    private UUID parseUUID(ByteBuffer buffer) {
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        if (mostSigBits == 0L && leastSigBits == 0L) {
            return null;
        }
        return new UUID(mostSigBits, leastSigBits);
    }

    public TransactionEntry parse(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[] entryBytes = null;
        buffer.position(30);
        int length = buffer.getInt();
        if (length >= 0) {
            entryBytes = new byte[length];
            buffer.get(entryBytes);
        }
        HashMap<String, String> context = null;
        int size = buffer.getInt();
        if (size >= 0) {
            context = new HashMap<String, String>(size);
            for (int i = 0; i < size; ++i) {
                context.put(this.getString(buffer), this.getString(buffer));
            }
        }
        buffer.clear();
        return new TransactionEntry(this.parseUUID(buffer), buffer.getLong(), TransactionEntryType.valueOf(buffer.get()), buffer.getShort(), buffer.get() == 1, buffer.getShort(), entryBytes, context);
    }

    private String getString(ByteBuffer buffer) {
        int length = buffer.getInt();
        if (length >= 0) {
            byte[] bytes = new byte[length];
            buffer.get(bytes);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        return null;
    }
}

