/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.store.PositionOverflowException;
import org.joyqueue.store.PositionUnderflowException;
import org.joyqueue.store.QosStore;
import org.joyqueue.store.ReadException;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.StoreInitializeException;
import org.joyqueue.store.WriteRequest;
import org.joyqueue.store.WriteResult;
import org.joyqueue.store.file.Checkpoint;
import org.joyqueue.store.file.DiskFullException;
import org.joyqueue.store.file.PositioningStore;
import org.joyqueue.store.file.RollBackException;
import org.joyqueue.store.file.StoreMessageSerializer;
import org.joyqueue.store.file.WriteException;
import org.joyqueue.store.index.IndexItem;
import org.joyqueue.store.index.IndexSerializer;
import org.joyqueue.store.message.BatchMessageParser;
import org.joyqueue.store.message.MessageParser;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.store.utils.PreloadBufferPool;
import org.joyqueue.toolkit.concurrent.CasLock;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.LoopThread;
import org.joyqueue.toolkit.format.Format;
import org.joyqueue.toolkit.metric.Metric;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGroupStoreManager
extends Service
implements ReplicableStore,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(PartitionGroupStoreManager.class);
    private static final long EVENT_TIMEOUT_MILLS = 60000L;
    private final PositioningStore<ByteBuffer> store;
    private final File base;
    private final String topic;
    private final int partitionGroup;
    private final Map<QosLevel, CallbackPositioningBelt> callbackMap = new HashMap<QosLevel, CallbackPositioningBelt>(3);
    private final Map<Short, Partition> partitionMap = new ConcurrentHashMap<Short, Partition>();
    private final Config config;
    private final QosStore[] qosStores = new QosStore[]{new QosStore(this, QosLevel.ONE_WAY), new QosStore(this, QosLevel.RECEIVE), new QosStore(this, QosLevel.PERSISTENCE), new QosStore(this, QosLevel.REPLICATION), new QosStore(this, QosLevel.ALL)};
    private final PreloadBufferPool bufferPool;
    private final LoopThread writeLoopThread;
    private final LoopThread flushLoopThread;
    private final LoopThread metricThread;
    private final BlockingQueue<WriteCommand> writeCommandCache;
    private long replicationPosition;
    private long indexPosition;
    private AtomicBoolean enabled;
    private int term;
    private Metric produceMetrics = null;
    private Metric consumeMetrics = null;
    private Metric.MetricInstance produceMetric = null;
    private Metric.MetricInstance consumeMetric;
    private final Lock writeLock = new ReentrantLock();
    private AtomicLong lastCheckDiskSpaceTimestamp = new AtomicLong(0L);
    private volatile boolean isDiskFull = false;
    private static final long CHECK_DISK_SPACE_COOL_DOWN = 1000L;
    private static final long FLUSH_CHECKPOINT_INTERVAL_MS = 60000L;
    private long lastFlushCheckpointTimestamp = 0L;
    static final String CHECKPOINT_FILE = "checkpoint.json";
    private int lastEntryTerm = -1;
    private final CasLock flushLock = new CasLock();

    public PartitionGroupStoreManager(String topic, int partitionGroup, File base, Config config, PreloadBufferPool bufferPool) {
        this.base = base;
        this.topic = topic;
        this.partitionGroup = partitionGroup;
        this.config = config;
        this.writeCommandCache = new LinkedBlockingQueue<WriteCommand>(config.writeRequestCacheSize);
        this.bufferPool = bufferPool;
        this.enabled = new AtomicBoolean(false);
        this.callbackMap.put(QosLevel.PERSISTENCE, new CallbackPositioningBelt());
        this.callbackMap.put(QosLevel.REPLICATION, new CallbackPositioningBelt());
        this.callbackMap.put(QosLevel.ALL, new CallbackPositioningBelt());
        StoreMessageSerializer storeMessageSerializer = new StoreMessageSerializer(config.maxMessageLength);
        this.store = new PositioningStore<ByteBuffer>(base, config.storeConfig, bufferPool, storeMessageSerializer);
        if (!base.isDirectory()) {
            throw new StoreInitializeException(String.format("Partition group directory: %s not available!", base.getAbsolutePath()));
        }
        this.replicationPosition = this.store.flushPosition();
        this.term = this.getMaxTerm(this.store);
        this.writeLoopThread = LoopThread.builder().name(String.format("WriteThread-%s-%d", topic, partitionGroup)).doWork(this::write).sleepTime(0L, 0L).onException(e -> logger.warn("Write Exception: ", e)).build();
        this.flushLoopThread = LoopThread.builder().name(String.format("FlushThread-%s-%d", topic, partitionGroup)).doWork(this::flush).sleepTime(config.flushIntervalMs, config.flushIntervalMs).onException(e -> logger.warn("Flush Exception: ", e)).build();
        this.metricThread = this.initMetrics(config);
    }

    private LoopThread initMetrics(Config config) {
        if (config.printMetricIntervalMs > 0L) {
            this.produceMetrics = new Metric("WriteMetric-" + this.topic + "-" + this.partitionGroup, 1, new String[]{"WriteLatency", "FlushLatency"}, new String[]{"WriteCount", "FlushCount"}, new String[]{"WriteTraffic", "FlushTraffic"});
            this.produceMetric = (Metric.MetricInstance)this.produceMetrics.getMetricInstances().get(0);
            this.consumeMetrics = new Metric("ReadMetric-" + this.topic + "-" + this.partitionGroup, 1, new String[]{"ReadLatency"}, new String[]{"ReadCount"}, new String[]{"ReadTraffic"});
            this.consumeMetric = (Metric.MetricInstance)this.consumeMetrics.getMetricInstances().get(0);
            return LoopThread.builder().sleepTime(config.printMetricIntervalMs, config.printMetricIntervalMs).name("Metric-Thread").onException(e -> logger.warn("Exception:", e)).doWork(() -> {
                this.consumeMetrics.reportAndReset();
                this.produceMetrics.reportAndReset();
                logger.info("{}-{} WriteCommandCache size: {}, dirty size: {}/{}.", new Object[]{this.topic, this.partitionGroup, this.writeCommandCache.size(), this.store.right() - this.store.flushPosition(), config.maxDirtySize});
            }).build();
        }
        return null;
    }

    public void recover() {
        try {
            logger.info("Recovering message store {}...", (Object)this.base.getAbsolutePath());
            this.store.recover();
            this.resetLastEntryTerm();
            logger.info("Recovering index store {}...", (Object)this.base.getAbsolutePath());
            long safeIndexPosition = this.indexPosition = this.recoverPartitions();
            logger.info("Recovering the checkpoint {}...", (Object)this.base.getAbsolutePath());
            long checkPointIndexPosition = this.indexPosition = this.recoverCheckpoint();
            logger.info("Building indices {}...", (Object)this.base.getAbsolutePath());
            try {
                this.recoverIndices();
            }
            catch (Throwable t) {
                if (safeIndexPosition != this.indexPosition) {
                    this.indexPosition = safeIndexPosition;
                    logger.warn("Exception while recover indices using indexPosition {} from Checkpoint.json. Fall back safe index position {} and retry recover indices...", new Object[]{Format.formatWithComma((long)checkPointIndexPosition), Format.formatWithComma((long)safeIndexPosition), t});
                    this.indexPosition = safeIndexPosition;
                    this.recoverIndices();
                }
                throw t;
            }
            logger.info("Store recovered: {}...", (Object)this.base.getAbsolutePath());
        }
        catch (IOException e) {
            throw new StoreInitializeException(e);
        }
    }

    private void resetLastEntryTerm() {
        if (this.store.right() > 0L) {
            long lastLogPosition = this.store.toLogStart(this.store.right());
            this.lastEntryTerm = this.getEntryTerm(lastLogPosition);
        } else {
            this.lastEntryTerm = -1;
        }
    }

    private void recoverIndices() throws IOException {
        for (Partition partition : this.partitionMap.values()) {
            partition.rollbackTo(this.indexPosition);
        }
        while (this.indexPosition < this.store.right()) {
            ByteBuffer byteBuffer = this.store.read(this.indexPosition);
            if (null == byteBuffer) {
                throw new ReadException(String.format("Read log failed! store: %s, position: %d.", this.store.base().getAbsolutePath(), this.indexPosition));
            }
            IndexItem indexItem = IndexItem.parseMessage(byteBuffer, this.indexPosition);
            Partition partition = this.partitionMap.get(indexItem.getPartition());
            if (null == partition) {
                this.indexPosition += (long)indexItem.getLength();
                continue;
            }
            PositioningStore indexStore = partition.store;
            if (indexStore.right() == 0L) {
                indexStore.setRight(indexItem.getIndex() * 12L);
            }
            long storeIndex = indexStore.right() / 12L;
            if (indexItem.getIndex() == storeIndex) {
                if (BatchMessageParser.isBatch((ByteBuffer)byteBuffer)) {
                    short batchSize = BatchMessageParser.getBatchSize((ByteBuffer)byteBuffer);
                    indexItem.setBatchMessage(true);
                    indexItem.setBatchMessageSize(batchSize);
                }
                this.writeIndex(indexItem, partition.store);
            } else if (indexItem.getIndex() < storeIndex) {
                IndexItem pi = (IndexItem)indexStore.read(indexItem.getIndex() * 12L);
                if (pi.getOffset() != this.indexPosition) {
                    throw new WriteException(String.format("Index mismatch, store: %s, partition: %d, next index of the partition: %s\uff0cindex in log: %s, log position: %s, log: \n%s", this.base, indexItem.getPartition(), Format.formatWithComma((long)storeIndex), Format.formatWithComma((long)indexItem.getIndex()), Format.formatWithComma((long)this.indexPosition), MessageParser.getString((ByteBuffer)byteBuffer)));
                }
            } else if (indexItem.getIndex() > storeIndex) {
                throw new WriteException(String.format("Index must be continuous, store: %s, partition: %d, next index of the partition: %s\uff0cindex in log: %s, log position: %s, log: \n%s", this.base, indexItem.getPartition(), Format.formatWithComma((long)storeIndex), Format.formatWithComma((long)indexItem.getIndex()), Format.formatWithComma((long)this.indexPosition), MessageParser.getString((ByteBuffer)byteBuffer)));
            }
            if (indexStore.right() - indexStore.flushPosition() < 0xA00000L) continue;
            indexStore.flush();
            logger.info("Recovering index, topic: {}, group: {}, Write position: {}, index position: {}", new Object[]{this.topic, this.partitionGroup, this.store.right(), this.indexPosition});
        }
        for (Partition partition : this.partitionMap.values()) {
            PositioningStore indexStore = partition.store;
            if (indexStore.right() <= indexStore.flushPosition()) continue;
            indexStore.flush();
        }
    }

    private void rollbackPartitions(long messagePosition) throws IOException {
        for (Partition partition : this.partitionMap.values()) {
            partition.rollbackTo(messagePosition);
        }
    }

    private int getMaxTerm(PositioningStore<ByteBuffer> store) {
        int maxTerm = 0;
        if (store.right() > store.left()) {
            maxTerm = this.getEntryTerm(store.toLogStart(store.right()));
        }
        return maxTerm;
    }

    private long recoverCheckpoint() {
        block18: {
            try {
                File checkpointFile = new File(this.base, CHECKPOINT_FILE);
                if (checkpointFile.isFile()) {
                    byte[] serializedData = new byte[(int)checkpointFile.length()];
                    try (FileInputStream fis = new FileInputStream(checkpointFile);){
                        if (serializedData.length != fis.read(serializedData)) {
                            throw new IOException("File length not match!");
                        }
                    }
                    String jsonString = new String(serializedData, StandardCharsets.UTF_8);
                    Checkpoint checkpoint = (Checkpoint)JSON.parseObject((String)jsonString, Checkpoint.class);
                    if (checkpoint.getIndexPosition() > this.indexPosition && checkpoint.getPartitions().entrySet().stream().allMatch(entry -> {
                        short partition = (Short)entry.getKey();
                        long index = (Long)entry.getValue();
                        Partition p = this.partitionMap.get(partition);
                        return null != p && p.store.right() >= index * 12L;
                    })) {
                        logger.info("Using indexPosition: {} from the checkpoint file.", (Object)checkpoint.getIndexPosition());
                        return checkpoint.getIndexPosition();
                    }
                    break block18;
                }
                logger.info("Checkpoint file is NOT found, continue recover...");
            }
            catch (Throwable t) {
                logger.warn("Recover checkpoint exception, continue recover...", t);
            }
        }
        return this.indexPosition;
    }

    private long recoverPartitions() throws IOException {
        File indexBase = new File(this.base, "index");
        long indexPosition = this.store.right();
        if (!indexBase.isDirectory()) {
            throw new StoreInitializeException(String.format("Index directory: %s not found! ", indexBase.getAbsolutePath()));
        }
        Short[] partitionIndices = this.loadPartitionIndices(indexBase);
        if (partitionIndices == null) {
            return this.store.left();
        }
        Short[] shortArray = partitionIndices;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            IndexItem currentIndex;
            short partitionIndex = shortArray[i];
            File partitionBase = new File(indexBase, String.valueOf(partitionIndex));
            PositioningStore<IndexItem> indexStore = new PositioningStore<IndexItem>(partitionBase, this.config.indexStoreConfig, this.bufferPool, new IndexSerializer());
            indexStore.recover();
            indexStore.setRight(indexStore.right() - indexStore.right() % 12L);
            long validPosition = indexStore.right();
            IndexItem previousIndex = null;
            while ((validPosition -= 12L) >= indexStore.left() + 12L && !this.verifyCurrentIndex(currentIndex = null == previousIndex ? indexStore.read(validPosition) : previousIndex, previousIndex = indexStore.read(validPosition - 12L))) {
            }
            indexStore.setRight(validPosition + 12L);
            this.partitionMap.put(partitionIndex, new Partition(indexStore));
            if (indexStore.right() - indexStore.left() > 0L) {
                IndexItem lastIndexItem = indexStore.read(indexStore.right() - 12L);
                if (lastIndexItem == null) {
                    throw new ReadException(String.format("Failed to recover index store %s to position %s, batchRead index failed!", indexStore.base().getAbsolutePath(), Format.formatWithComma((long)(indexStore.right() - 12L))));
                }
                this.verifyBatchMessage(lastIndexItem, indexStore, this.store);
                long indexedMessagePosition = lastIndexItem.getOffset();
                logger.info("Topic: {}, group: {}, partition: {}, maxIndexedMessageOffset: {}.", new Object[]{this.topic, this.partitionGroup, partitionIndex, Format.formatWithComma((long)indexedMessagePosition)});
                if (indexPosition <= indexedMessagePosition) continue;
                logger.info("Topic: {}, group: {}, set indexPosition from {} to {}.", new Object[]{this.topic, this.partitionGroup, Format.formatWithComma((long)indexPosition), Format.formatWithComma((long)indexedMessagePosition)});
                indexPosition = indexedMessagePosition;
                continue;
            }
            indexPosition = this.store.left();
        }
        return indexPosition;
    }

    private boolean verifyCurrentIndex(IndexItem current, IndexItem previous) {
        return current.getLength() > 0 && current.getOffset() > previous.getOffset();
    }

    private Short[] loadPartitionIndices(File indexBase) {
        Short[] partitionIndices = null;
        File[] files = indexBase.listFiles(file -> file.isDirectory() && file.getName().matches("^\\d+$"));
        if (null != files) {
            partitionIndices = (Short[])Arrays.stream(files).map(File::getName).map(str -> {
                try {
                    return Short.parseShort(str);
                }
                catch (NumberFormatException ignored) {
                    return (short)-1;
                }
            }).filter(s -> s >= 0).toArray(Short[]::new);
        }
        return partitionIndices;
    }

    private void verifyBatchMessage(IndexItem lastIndexItem, PositioningStore<IndexItem> indexStore, PositioningStore<ByteBuffer> store) throws IOException {
        ByteBuffer msg;
        if (lastIndexItem.getOffset() < store.right() && BatchMessageParser.isBatch((ByteBuffer)(msg = store.read(lastIndexItem.getOffset())))) {
            short batchSize = BatchMessageParser.getBatchSize((ByteBuffer)msg);
            long startIndex = MessageParser.getLong((ByteBuffer)msg, (int)MessageParser.INDEX);
            if (indexStore.right() < ((long)batchSize + startIndex) * 12L) {
                logger.info("Incomplete batch message indices found, roll back index store to {}, index: {}, message position: {}, store: {}.", new Object[]{Format.formatWithComma((long)(startIndex * 12L)), Format.formatWithComma((long)lastIndexItem.getIndex()), Format.formatWithComma((long)lastIndexItem.getOffset()), indexStore.base().getAbsolutePath()});
                indexStore.setRight(startIndex * 12L);
            }
        }
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionGroup() {
        return this.partitionGroup;
    }

    Short[] listPartitions() {
        return this.partitionMap.keySet().toArray(new Short[0]);
    }

    private void removePartition(short partition) {
        File partitionBase;
        Partition p = this.partitionMap.remove(partition);
        if (null != p && !(partitionBase = new File(this.base, "index" + File.separator + partition)).renameTo(new File(partitionBase.getParent(), partitionBase.getName() + ".d." + SystemClock.now()))) {
            logger.warn("Rename directory {} failed!", (Object)partitionBase.getAbsolutePath());
        }
    }

    private void addPartition(short partition) throws IOException {
        if (this.partitionMap.get(partition) == null) {
            this.removePartition(partition);
            File partitionBase = new File(this.base, "index" + File.separator + partition);
            if (partitionBase.mkdirs()) {
                PositioningStore<IndexItem> indexStore = new PositioningStore<IndexItem>(partitionBase, this.config.indexStoreConfig, this.bufferPool, new IndexSerializer());
                indexStore.recover();
                this.partitionMap.put(partition, new Partition(indexStore));
            } else {
                throw new IOException(String.format("Create directory: %s failed!", partitionBase.getAbsolutePath()));
            }
        }
    }

    public ReadResult read(short partition, long index, int count, long maxSize) throws IOException {
        long t0 = System.nanoTime();
        ReadResult readResult = new ReadResult();
        this.checkPartition(partition);
        PositioningStore indexStore = this.partitionMap.get(partition).store;
        List indexItemList = indexStore.batchRead(index * 12L, count);
        long size = 0L;
        readResult.setEop(indexItemList.size() < count);
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(count);
        IndexItem lastIndexItem = null;
        for (int i = 0; i < indexItemList.size(); ++i) {
            IndexItem indexItem = (IndexItem)indexItemList.get(i);
            if (null != lastIndexItem && indexItem.getOffset() == lastIndexItem.getOffset() || indexItem.getOffset() >= this.commitPosition()) continue;
            try {
                ByteBuffer log;
                try {
                    log = this.store.read(indexItem.getOffset(), indexItem.getLength());
                    if (MessageParser.getInt((ByteBuffer)log, (int)MessageParser.LENGTH) != indexItem.getLength()) {
                        logger.warn("\u7d22\u5f15\u4e2d\u6d88\u606f\u957f\u5ea6\u4e0d\u6b63\u786e\uff01index: {} , offset: {}, message length (from index/from message): {}/{}, partition: {}, store: {}.", new Object[]{Format.formatWithComma((long)(index + (long)i)), Format.formatWithComma((long)indexItem.getOffset()), indexItem.getLength(), MessageParser.getInt((ByteBuffer)log, (int)MessageParser.LENGTH), partition, this.base.getAbsolutePath()});
                        log = this.store.read(indexItem.getOffset());
                    }
                }
                catch (Throwable t) {
                    logger.warn("Exception on read, try to read without length! index: {} , offset: {}, message length: {}, partition: {}, store: {}.", new Object[]{Format.formatWithComma((long)(index + (long)i)), Format.formatWithComma((long)indexItem.getOffset()), indexItem.getLength(), partition, this.base.getAbsolutePath(), t});
                    log = this.store.read(indexItem.getOffset());
                }
                if (null != log) {
                    if (maxSize > 0L && (size += (long)log.remaining()) >= maxSize) break;
                } else {
                    throw new ReadException(String.format("Read log failed! store: %s, position: %d.", this.store.base().getAbsolutePath(), indexItem.getOffset()));
                }
                buffers.add(log);
                lastIndexItem = indexItem;
                continue;
            }
            catch (Throwable t) {
                logger.warn("Exception on read! index: {} , offset: {}, message length: {}, partition: {}, store: {}.", new Object[]{Format.formatWithComma((long)(index + (long)i)), Format.formatWithComma((long)indexItem.getOffset()), indexItem.getLength(), partition, this.base.getAbsolutePath(), t});
                throw t;
            }
        }
        readResult.setMessages(buffers.toArray(new ByteBuffer[0]));
        readResult.setCode(JoyQueueCode.SUCCESS);
        if (null != this.consumeMetric) {
            this.consumeMetric.addCounter("ReadCount", (long)buffers.size());
            this.consumeMetric.addLatency("ReadLatency", System.nanoTime() - t0);
            this.consumeMetric.addTraffic("ReadTraffic", (long)buffers.stream().mapToInt(Buffer::remaining).sum());
        }
        return readResult;
    }

    private void checkPartition(short partition) {
        if (!this.partitionMap.containsKey(partition)) {
            throw new ReadException(String.format("No such partition: %d in topic: %s, partition group: %d.", partition, this.topic, this.partitionGroup));
        }
    }

    private long[] write(ByteBuffer ... byteBuffers) throws IOException {
        long start = this.store.right();
        Map<Short, Long> partitionSnapshot = this.createPartitionSnapshot();
        long position = start;
        long[] indices = new long[byteBuffers.length];
        try {
            int byteBuffersLength = byteBuffers.length;
            for (int i = 0; i < byteBuffersLength; ++i) {
                ByteBuffer byteBuffer = byteBuffers[i].slice();
                if (byteBuffer.remaining() > this.config.maxMessageLength) {
                    throw new WriteException(String.format("Message too large! Message length: %d, limit: %d", byteBuffer.remaining(), this.config.maxMessageLength));
                }
                IndexItem indexItem = IndexItem.parseMessage(byteBuffer, position);
                Partition partition = this.partitionMap.get(indexItem.getPartition());
                indices[i] = partition.store.right() / 12L;
                MessageParser.setLong((ByteBuffer)byteBuffer, (int)MessageParser.INDEX, (long)indices[i]);
                indexItem.setIndex(indices[i]);
                position = this.store.append(byteBuffer);
                this.updateLastEntryTerm(byteBuffer);
                if (BatchMessageParser.isBatch((ByteBuffer)byteBuffer)) {
                    short batchSize = BatchMessageParser.getBatchSize((ByteBuffer)byteBuffer);
                    indexItem.setBatchMessage(true);
                    indexItem.setBatchMessageSize(batchSize);
                }
                this.writeIndex(indexItem, partition.store);
                this.flushLoopThread.wakeup();
            }
        }
        catch (Throwable t) {
            this.onWriteException(start, partitionSnapshot, t);
            throw t;
        }
        return indices;
    }

    private Map<Short, Long> createPartitionSnapshot() {
        return this.partitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Partition)entry.getValue()).store.right()));
    }

    private void writeIndex(IndexItem indexItem, PositioningStore<IndexItem> indexStore) throws IOException {
        if (indexItem.isBatchMessage()) {
            this.appendBatchMessageIndices(indexStore, indexItem);
        } else {
            indexStore.append(indexItem);
        }
        this.indexPosition += (long)indexItem.getLength();
    }

    private void appendBatchMessageIndices(PositioningStore<IndexItem> indexStore, IndexItem indexItem) throws IOException {
        ByteBuffer indexBuffer = ByteBuffer.allocate(indexItem.getBatchMessageSize() * 12);
        for (int j = 0; j < indexItem.getBatchMessageSize(); ++j) {
            indexItem.serializeTo(indexBuffer);
        }
        indexBuffer.flip();
        indexStore.appendByteBuffer(indexBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        WriteCommand writeCommand = null;
        if (!this.writeLock.tryLock()) {
            throw new IllegalStateException("Acquire write lock failed!");
        }
        try {
            writeCommand = this.writeCommandCache.take();
            if (null != this.produceMetric) {
                this.produceMetric.addTraffic("WriteTraffic", (long)Arrays.stream(writeCommand.messages).mapToInt(Buffer::remaining).sum());
            }
            long t0 = System.nanoTime();
            this.verifyState(true);
            if (this.waitForFlush() && writeCommand.eventListener != null) {
                writeCommand.eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SE_WRITE_TIMEOUT, null));
            } else {
                long[] indices = this.write(writeCommand.messages);
                this.handleCallback(writeCommand, this.store.right(), indices);
            }
            long t1 = System.nanoTime();
            if (null != this.produceMetric) {
                this.produceMetric.addLatency("WriteLatency", t1 - t0);
                this.produceMetric.addCounter("WriteCount", 1L);
            }
        }
        catch (DiskFullException e) {
            if (null != writeCommand && writeCommand.eventListener != null) {
                writeCommand.eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SE_DISK_FULL, null));
            }
            logger.warn("Write failed, cause: disk full! Store: {}.", (Object)this.base.getAbsolutePath());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IllegalStateException e) {
            if (null != writeCommand && writeCommand.eventListener != null) {
                writeCommand.eventListener.onEvent((Object)new WriteResult(JoyQueueCode.CY_STATUS_ERROR, null));
            }
            logger.warn("Write failed, cause: store disabled! Store: {}.", (Object)this.base.getAbsolutePath());
        }
        catch (Throwable t) {
            if (null != writeCommand && writeCommand.eventListener != null) {
                writeCommand.eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SE_WRITE_FAILED, null));
            }
            logger.warn("Write failed, cause: exception! Store: {}.", (Object)this.base.getAbsolutePath(), (Object)t);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void verifyState(boolean expectedState) {
        if (this.enabled.get() != expectedState) {
            throw new IllegalStateException();
        }
    }

    private boolean waitForFlush() {
        long t0 = SystemClock.now();
        while (this.store.right() - this.store.flushPosition() >= this.config.maxDirtySize && SystemClock.now() - t0 <= this.config.writeTimeoutMs) {
            Thread.yield();
        }
        return SystemClock.now() - t0 > this.config.writeTimeoutMs;
    }

    private void handleCallback(WriteCommand writeCommand, long position, long[] indices) {
        Callback callback = new Callback(writeCommand.qosLevel, (EventListener<WriteResult>)writeCommand.eventListener, indices);
        callback.position = position;
        CallbackPositioningBelt belt = this.callbackMap.get(writeCommand.qosLevel);
        if (null != belt) {
            belt.put(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() {
        if (this.flushLock.tryLock()) {
            try {
                boolean flushed;
                do {
                    long t0 = System.nanoTime();
                    long before = this.store.flushPosition();
                    flushed = this.store.flush() | this.flushIndices();
                    if (null != this.produceMetric && flushed) {
                        long t1 = System.nanoTime();
                        this.produceMetric.addTraffic("FlushTraffic", this.store.flushPosition() - before);
                        this.produceMetric.addLatency("FlushLatency", t1 - t0);
                        this.produceMetric.addCounter("FlushCount", 1L);
                    }
                    if (flushed) {
                        this.callbackMap.get(QosLevel.PERSISTENCE).callbackBefore(this.flushPosition());
                    }
                    this.flushCheckpointPeriodically();
                } while (flushed && this.isStarted());
            }
            catch (IOException e) {
                logger.warn("Exception:", (Throwable)e);
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    private boolean flushIndices() {
        boolean ret = false;
        try {
            boolean flushed;
            do {
                flushed = false;
                for (Partition partition : this.partitionMap.values()) {
                    flushed = partition.store.flush() || flushed;
                }
                boolean bl = ret = ret || flushed;
            } while (flushed);
        }
        catch (Exception e) {
            logger.warn("Exception: ", (Throwable)e);
        }
        return ret;
    }

    private boolean isDiskFull() {
        long timestamp = this.lastCheckDiskSpaceTimestamp.get();
        if (SystemClock.now() - timestamp > 1000L && this.lastCheckDiskSpaceTimestamp.compareAndSet(timestamp, SystemClock.now())) {
            this.isDiskFull = this.store.isDiskFull();
        }
        return this.isDiskFull;
    }

    void asyncWrite(QosLevel qosLevel, EventListener<WriteResult> eventListener, WriteRequest ... writeRequests) {
        block9: {
            this.ensureStarted();
            if (this.isDiskFull()) {
                if (eventListener != null) {
                    eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SE_DISK_FULL, null));
                }
                return;
            }
            if (!this.enabled.get()) {
                throw new WriteException(String.format("Store disabled! topic: %s, partitionGroup: %d.", this.topic, this.partitionGroup));
            }
            ByteBuffer[] messages = new ByteBuffer[writeRequests.length];
            for (WriteRequest writeRequest : writeRequests) {
                ByteBuffer byteBuffer = writeRequest.getBuffer();
                int length = MessageParser.getInt((ByteBuffer)byteBuffer, (int)MessageParser.LENGTH);
                if (length != byteBuffer.remaining()) {
                    throw new WriteException(String.format("Message length check error! Expect: %d, actual: %d", length, byteBuffer.remaining()));
                }
                if (!this.partitionMap.containsKey(writeRequest.getPartition())) {
                    throw new WriteException(String.format("No partition %d in partition group %d of topic %s!", writeRequest.getPartition(), this.partitionGroup, this.topic));
                }
                MessageParser.setShort((ByteBuffer)byteBuffer, (int)MessageParser.PARTITION, (short)writeRequest.getPartition());
                MessageParser.setInt((ByteBuffer)byteBuffer, (int)MessageParser.TERM, (int)this.term);
                MessageParser.setInt((ByteBuffer)byteBuffer, (int)MessageParser.STORAGE_TIMESTAMP, (int)((int)(SystemClock.now() - MessageParser.getLong((ByteBuffer)byteBuffer, (int)MessageParser.CLIENT_TIMESTAMP))));
                messages[i] = writeRequest.getBuffer();
            }
            WriteCommand writeCommand = new WriteCommand(qosLevel, eventListener, messages);
            try {
                this.writeCommandCache.put(writeCommand);
            }
            catch (InterruptedException e) {
                logger.warn("Exception: ", (Throwable)e);
                if (eventListener == null) break block9;
                eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SE_WRITE_FAILED, null));
            }
        }
        if (qosLevel == QosLevel.RECEIVE && null != eventListener) {
            eventListener.onEvent((Object)new WriteResult(JoyQueueCode.SUCCESS, null));
        }
    }

    long indexPosition() {
        return this.indexPosition;
    }

    PositioningStore<IndexItem> indexStore(short partition) {
        if (this.partitionMap.containsKey(partition)) {
            return this.partitionMap.get(partition).store;
        }
        return null;
    }

    PositioningStore<ByteBuffer> messageStore() {
        return this.store;
    }

    Set<PositioningStore<IndexItem>> meetPositioningStores() {
        return this.partitionMap.values().stream().map(p -> ((Partition)p).store).collect(Collectors.toSet());
    }

    long clean(long time, Map<Short, Long> partitionAckMap, boolean keepUnconsumed) throws IOException {
        long deletedSize = 0L;
        long minMessagePosition = -1L;
        for (Map.Entry<Short, Long> partition : partitionAckMap.entrySet()) {
            Short p = partition.getKey();
            long minPartitionIndex = partition.getValue();
            PositioningStore<IndexItem> indexStore = this.indexStore(p);
            if (indexStore == null) continue;
            minPartitionIndex = minPartitionIndex != Long.MAX_VALUE && keepUnconsumed ? (minPartitionIndex *= 12L) : Long.MAX_VALUE;
            if (time <= 0L) {
                if (indexStore.fileCount() > 1 && indexStore.meetMinStoreFile(minPartitionIndex) > 1) {
                    deletedSize += indexStore.physicalDeleteLeftFile();
                    if (logger.isDebugEnabled()) {
                        logger.info("Delete PositioningStore physical index file by size, partition: <{}>, offset position: <{}>", (Object)p, (Object)minPartitionIndex);
                    }
                }
            } else if (indexStore.fileCount() > 1 && indexStore.meetMinStoreFile(minPartitionIndex) > 1 && this.hasEarly(indexStore, time)) {
                deletedSize += indexStore.physicalDeleteLeftFile();
                if (logger.isDebugEnabled()) {
                    logger.info("Delete PositioningStore physical index file by time, partition: <{}>, offset position: <{}>", (Object)p, (Object)minPartitionIndex);
                }
            }
            try {
                long storeMinMessagePosition = indexStore.read(indexStore.left()).getOffset();
                if (minMessagePosition >= 0L && minMessagePosition <= storeMinMessagePosition) continue;
                minMessagePosition = storeMinMessagePosition;
            }
            catch (PositionOverflowException positionOverflowException) {}
        }
        if (minMessagePosition >= 0L) {
            deletedSize += this.store.physicalDeleteTo(minMessagePosition);
            if (logger.isDebugEnabled()) {
                logger.info("Delete PositioningStore physical message file, offset position: <{}>", (Object)minMessagePosition);
            }
        }
        return deletedSize;
    }

    private boolean hasEarly(PositioningStore<IndexItem> indexStore, long time) throws IOException {
        long offset;
        long left = indexStore.left();
        IndexItem item = indexStore.read(left);
        ByteBuffer message = this.store.read(item.getOffset());
        long clientTimestamp = MessageParser.getLong((ByteBuffer)message, (int)MessageParser.CLIENT_TIMESTAMP);
        return clientTimestamp + (offset = (long)MessageParser.getInt((ByteBuffer)message, (int)MessageParser.STORAGE_TIMESTAMP)) < time;
    }

    synchronized void rePartition(Short[] partitions) throws IOException {
        Short[] shortArray = partitions;
        int n = shortArray.length;
        for (int i = 0; i < n; ++i) {
            short partition = shortArray[i];
            if (this.partitionMap.containsKey(partition)) continue;
            this.addPartition(partition);
        }
        List<Short> partitionList = Arrays.asList(partitions);
        ArrayList<Short> toBeRemoved = new ArrayList<Short>();
        for (Map.Entry<Short, Partition> entry : this.partitionMap.entrySet()) {
            if (partitionList.contains(entry.getKey())) continue;
            toBeRemoved.add(entry.getKey());
        }
        for (Short partition : toBeRemoved) {
            this.removePartition(partition);
        }
    }

    protected void doStart() throws Exception {
        if (this.config.printMetricIntervalMs > 0L) {
            this.metricThread.start();
        }
        this.startFlushThread();
        if (this.enabled.get()) {
            this.startWriteThread();
        }
    }

    private void startFlushThread() {
        this.flushLoopThread.start();
    }

    private void startWriteThread() {
        this.writeLoopThread.start();
    }

    protected void doStop() {
        try {
            this.logSafe("Stopping store {}-{}...", this.topic, this.partitionGroup);
            this.logSafe("Waiting for flush finished {}-{}...", this.topic, this.partitionGroup);
            try {
                while (!this.isAllStoreClean()) {
                    Thread.sleep(50L);
                }
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.stopWriteThread();
            this.logSafe("Stopping flush thread {}-{}...", this.topic, this.partitionGroup);
            this.stopFlushThread();
            this.flushCheckpoint();
            if (this.config.printMetricIntervalMs > 0L) {
                this.logSafe("Stopping metric threads {}-{}...", this.topic, this.partitionGroup);
                this.metricThread.stop();
            }
            System.out.println("Store stopped. " + this.base.getAbsolutePath());
            this.logSafe("Store stopped {}-{}.", this.topic, this.partitionGroup);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private void logSafe(String format, Object ... arguments) {
        try {
            logger.info(format, arguments);
        }
        catch (Throwable t) {
            System.out.println(String.format(format.replaceAll("\\{}", "%s"), arguments));
        }
    }

    private boolean isAllStoreClean() {
        return Stream.concat(Stream.of(this.store), this.partitionMap.values().stream().map(partition -> ((Partition)partition).store)).allMatch(PositioningStore::isClean);
    }

    private void stopFlushThread() {
        this.flushLoopThread.stop();
    }

    private void stopWriteThread() {
        this.writeLoopThread.stop();
    }

    long getLeftIndex(short partition) {
        long index = -1L;
        Partition p = this.partitionMap.get(partition);
        if (null != p) {
            index = p.store.left() / 12L;
        }
        return index;
    }

    public long getRightIndex(short partition) {
        long index = -1L;
        Partition p = this.partitionMap.get(partition);
        if (null != p) {
            index = p.store.right() / 12L;
        }
        return index;
    }

    public boolean serviceStatus() {
        return this.enabled.get();
    }

    public void enable() {
        if (this.isStarted() && this.enabled.compareAndSet(false, true)) {
            this.startWriteThread();
        }
    }

    public void disable() {
        if (this.enabled.get()) {
            this.writeCommandCache.clear();
            this.stopWriteThread();
            this.enabled.set(false);
        }
    }

    public void setRightPosition(long position) throws IOException {
        this.flushLock.waitAndLock();
        try {
            this.rollback(position);
        }
        finally {
            this.flushLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(long position) throws IOException {
        this.flushLock.waitAndLock();
        try {
            for (Partition partition : this.partitionMap.values()) {
                partition.store.setRight(0L);
            }
            this.store.clear(position);
        }
        finally {
            this.flushLock.unlock();
        }
    }

    private void rollback(long position) throws IOException {
        boolean clearIndexStore;
        if (this.indexPosition > position) {
            this.indexPosition = position;
            this.flushCheckpoint();
        }
        boolean bl = clearIndexStore = position <= this.leftPosition() || position > this.rightPosition();
        if (clearIndexStore) {
            for (Partition partition : this.partitionMap.values()) {
                partition.store.setRight(0L);
            }
        } else {
            this.rollbackPartitions(position);
        }
        this.store.setRight(position);
        this.resetLastEntryTerm();
    }

    private void flushCheckpointPeriodically() throws IOException {
        if (SystemClock.now() > this.lastFlushCheckpointTimestamp + 60000L) {
            this.flushCheckpoint();
            this.lastFlushCheckpointTimestamp = SystemClock.now();
        }
    }

    private void flushCheckpoint() throws IOException {
        Checkpoint checkpoint = new Checkpoint(this.indexPosition, this.partitionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Partition)entry.getValue()).store.right() / 12L)));
        byte[] serializedData = JSON.toJSONString((Object)checkpoint, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.DisableCircularReferenceDetect}).getBytes(StandardCharsets.UTF_8);
        File checkpointFile = new File(this.base, CHECKPOINT_FILE);
        try (FileOutputStream fos = new FileOutputStream(checkpointFile);){
            fos.write(serializedData);
        }
    }

    long flushPosition() {
        return this.store.flushPosition();
    }

    public long commitPosition() {
        return this.replicationPosition;
    }

    public int term() {
        return this.term;
    }

    public void term(int term) {
        this.term = term;
    }

    public ByteBuffer readEntryBuffer(long position, int length) throws IOException {
        long t0 = System.nanoTime();
        ByteBuffer buffer = this.store.readByteBuffer(position, length);
        if (null != this.consumeMetric) {
            this.consumeMetric.addCounter("ReadCount", 1L);
            this.consumeMetric.addLatency("ReadLatency", System.nanoTime() - t0);
            this.consumeMetric.addTraffic("ReadTraffic", (long)buffer.remaining());
        }
        return buffer;
    }

    public long appendEntryBuffer(ByteBuffer byteBuffer) throws IOException, TimeoutException {
        this.ensureStarted();
        if (!this.writeLock.tryLock()) {
            throw new IllegalStateException("Acquire write lock failed!");
        }
        try {
            this.verifyState(false);
            long t0 = System.nanoTime();
            if (this.waitForFlush()) {
                throw new TimeoutException("Wait for flush timeout! The broker is too much busy to write data to disks.");
            }
            long start = this.store.right();
            Map<Short, Long> partitionSnapshot = this.createPartitionSnapshot();
            int counter = 0;
            int size = byteBuffer.remaining();
            try {
                long position = this.store.appendByteBuffer(byteBuffer.asReadOnlyBuffer());
                while (byteBuffer.hasRemaining()) {
                    IndexItem indexItem = IndexItem.parseMessage(byteBuffer, start + (long)byteBuffer.position());
                    Partition partition = this.partitionMap.get(indexItem.getPartition());
                    if (partition.store.right() == 0L) {
                        partition.store.setRight(indexItem.getIndex() * 12L);
                    } else if (indexItem.getIndex() * 12L != partition.store.right()) {
                        throw new WriteException(String.format("Index must be continuous, store: %s, partition: %d, next index of the partition: %s\uff0cindex in log: %s, log position: %s, log: \n%s", this.base, indexItem.getPartition(), Format.formatWithComma((long)(partition.store.right() / 12L)), Format.formatWithComma((long)indexItem.getIndex()), Format.formatWithComma((long)(start + (long)byteBuffer.position())), MessageParser.getString((ByteBuffer)byteBuffer)));
                    }
                    if (BatchMessageParser.isBatch((ByteBuffer)byteBuffer)) {
                        short batchSize = BatchMessageParser.getBatchSize((ByteBuffer)byteBuffer);
                        indexItem.setBatchMessage(true);
                        indexItem.setBatchMessageSize(batchSize);
                    }
                    this.writeIndex(indexItem, partition.store);
                    this.updateLastEntryTerm(byteBuffer);
                    byteBuffer.position(byteBuffer.position() + indexItem.getLength());
                    ++counter;
                }
                if (null != this.produceMetric) {
                    long t1 = System.nanoTime();
                    this.produceMetric.addTraffic("WriteTraffic", (long)size);
                    this.produceMetric.addLatency("WriteLatency", t1 - t0);
                    this.produceMetric.addCounter("WriteCount", (long)counter);
                }
                long l = position;
                return l;
            }
            catch (Throwable t) {
                this.onWriteException(start, partitionSnapshot, t);
                throw t;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void ensureStarted() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Store stopped.");
        }
    }

    private void updateLastEntryTerm(ByteBuffer byteBuffer) {
        int term = MessageParser.getInt((ByteBuffer)byteBuffer, (int)MessageParser.TERM);
        if (term < 0) {
            throw new WriteException(String.format("Invalid term %d at position %d!", term, byteBuffer.position()));
        }
        this.lastEntryTerm = term;
    }

    private void onWriteException(long start, Map<Short, Long> partitionSnapshot, Throwable t) {
        try {
            this.rollback(start, partitionSnapshot);
        }
        catch (Throwable e) {
            logger.warn("Rollback failed, rollback to position: {}, topic={}, partitionGroup={}.", new Object[]{start, this.topic, this.partitionGroup, e});
        }
        if (t instanceof DiskFullException) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            logger.warn("Write failed, rollback to position: {}, topic={}, partitionGroup={}.", new Object[]{start, this.topic, this.partitionGroup, t});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollback(long position, Map<Short, Long> partitionSnapshot) throws IOException {
        this.flushLock.waitAndLock();
        try {
            partitionSnapshot.forEach((partition, snapshotPosition) -> {
                try {
                    this.partitionMap.get(partition).store.setRight((long)snapshotPosition);
                }
                catch (Throwable e) {
                    logger.warn("Rollback partition failed! topic: {}, group: {}, partition: {}, rollback position: {}, current position: {}, store: {}.", new Object[]{this.topic, this.partitionGroup, partition, snapshotPosition, this.partitionMap.get(partition).store.right(), this.base.getAbsoluteFile(), e});
                }
            });
            this.indexPosition = position;
            try {
                this.flushCheckpoint();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.store.setRight(position);
        }
        finally {
            this.flushLock.unlock();
        }
    }

    public long position(long position, int offsetCount) {
        return this.store.position(position, offsetCount);
    }

    public int lastEntryTerm() {
        return this.lastEntryTerm;
    }

    public void commit(long position) {
        CallbackPositioningBelt belt;
        if (position > this.replicationPosition) {
            this.replicationPosition = position;
            belt = this.callbackMap.get(QosLevel.REPLICATION);
            belt.callbackBefore(this.commitPosition());
        }
        belt = this.callbackMap.get(QosLevel.ALL);
        belt.callbackBefore(Math.min(this.flushPosition(), this.commitPosition()));
    }

    public int getEntryTerm(long position) {
        int term;
        block5: {
            term = 0;
            if (this.store.right() > this.store.left()) {
                try {
                    ByteBuffer log = this.store.read(position);
                    if (log != null) {
                        int logTerm = MessageParser.getInt((ByteBuffer)log, (int)MessageParser.TERM);
                        if (logTerm >= 0) {
                            term = logTerm;
                        }
                        break block5;
                    }
                    throw new ReadException(String.format("Read log failed! store: %s, position: %d.", this.store.base().getAbsolutePath(), position));
                }
                catch (Exception e) {
                    throw new ReadException(String.format("Read log failed! store: %s, position: %d.", this.store.base().getAbsolutePath(), position), (Throwable)e);
                }
            }
        }
        return term;
    }

    public long leftPosition() {
        return this.store.left();
    }

    public long rightPosition() {
        return this.store.right();
    }

    @Override
    public void close() {
        if (null != this.store) {
            this.store.close();
        }
        for (Partition partition : this.partitionMap.values()) {
            partition.store.close();
        }
    }

    public long getIndex(short partition, long timestamp) {
        try {
            if (this.partitionMap.containsKey(partition)) {
                PositioningStore indexStore = this.partitionMap.get(partition).store;
                long searchedIndex = this.binarySearchByTimestamp(timestamp, this.store, indexStore, indexStore.left() / 12L, indexStore.right() / 12L - 1L);
                while (searchedIndex - 1L >= indexStore.left() && timestamp <= this.getStorageTimestamp(this.store, indexStore, searchedIndex - 1L)) {
                    --searchedIndex;
                }
                return searchedIndex;
            }
        }
        catch (IOException | PositionOverflowException | PositionUnderflowException e) {
            logger.warn("Exception: ", (Throwable)e);
        }
        return -1L;
    }

    private long getStorageTimestamp(PositioningStore<ByteBuffer> journalStore, PositioningStore<IndexItem> indexStore, long index) throws IOException {
        IndexItem indexItem = indexStore.read(index * 12L);
        ByteBuffer journal = journalStore.read(indexItem.getOffset(), indexItem.getLength());
        return MessageParser.getLong((ByteBuffer)journal, (int)MessageParser.CLIENT_TIMESTAMP) + (long)MessageParser.getInt((ByteBuffer)journal, (int)MessageParser.STORAGE_TIMESTAMP);
    }

    private long binarySearchByTimestamp(long timestamp, PositioningStore<ByteBuffer> journalStore, PositioningStore<IndexItem> indexStore, long leftIndexInclude, long rightIndexInclude) throws IOException {
        if (rightIndexInclude <= leftIndexInclude) {
            return -1L;
        }
        if (timestamp <= this.getStorageTimestamp(journalStore, indexStore, leftIndexInclude)) {
            return leftIndexInclude;
        }
        if (timestamp > this.getStorageTimestamp(journalStore, indexStore, rightIndexInclude)) {
            return -1L;
        }
        if (leftIndexInclude + 1L == rightIndexInclude) {
            return rightIndexInclude;
        }
        long mid = leftIndexInclude + (rightIndexInclude - leftIndexInclude) / 2L;
        long midTimestamp = this.getStorageTimestamp(journalStore, indexStore, mid);
        if (timestamp < midTimestamp) {
            return this.binarySearchByTimestamp(timestamp, journalStore, indexStore, leftIndexInclude, mid);
        }
        return this.binarySearchByTimestamp(timestamp, journalStore, indexStore, mid, rightIndexInclude);
    }

    QosStore getQosStore(QosLevel level) {
        return this.qosStores[level.value()];
    }

    class CallbackPositioningBelt {
        private final ConcurrentLinkedQueue<Callback> queue = new ConcurrentLinkedQueue();
        private AtomicLong callbackPosition = new AtomicLong(0L);

        CallbackPositioningBelt() {
        }

        Callback getFirst() {
            Callback f = this.queue.peek();
            if (f == null) {
                throw new NoSuchElementException();
            }
            return f;
        }

        Callback removeFirst() {
            Callback f = this.queue.poll();
            if (f == null) {
                throw new NoSuchElementException();
            }
            return f;
        }

        boolean remove(Callback callback) {
            return this.queue.remove(callback);
        }

        void addLast(Callback callback) {
            this.queue.add(callback);
        }

        void callbackBefore(long position) {
            try {
                if (position > this.callbackPosition.get()) {
                    this.callbackPosition.set(position);
                    while (this.getFirst().position <= position) {
                        Callback callback = this.removeFirst();
                        callback.listener.onEvent((Object)new WriteResult(JoyQueueCode.SUCCESS, callback.indices));
                    }
                }
                long deadline = SystemClock.now() - 60000L;
                while (this.getFirst().timestamp < deadline) {
                    Callback callback = this.removeFirst();
                    callback.listener.onEvent((Object)new WriteResult(JoyQueueCode.SE_WRITE_TIMEOUT, null));
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }

        void put(Callback callback) {
            this.addLast(callback);
            if (callback.position <= this.callbackPosition.get() && this.remove(callback)) {
                callback.listener.onEvent((Object)new WriteResult(JoyQueueCode.SUCCESS, callback.indices));
            }
        }
    }

    public static class Config {
        public static final int DEFAULT_MAX_MESSAGE_LENGTH = 0x400000;
        public static final int DEFAULT_WRITE_REQUEST_CACHE_SIZE = 128;
        public static final long DEFAULT_FLUSH_INTERVAL_MS = 50L;
        public static final long DEFAULT_WRITE_TIMEOUT_MS = 3000L;
        public static final long DEFAULT_MAX_DIRTY_SIZE = 0xA00000L;
        public static final long DEFAULT_PRINT_METRIC_INTERVAL_MS = 0L;
        private final long maxDirtySize;
        private final long writeTimeoutMs;
        private final int maxMessageLength;
        private final int writeRequestCacheSize;
        private final long flushIntervalMs;
        private final long printMetricIntervalMs;
        private PositioningStore.Config storeConfig;
        private PositioningStore.Config indexStoreConfig;

        public Config() {
            this(0x400000, 128, 50L, 3000L, 0xA00000L, 0L, new PositioningStore.Config(0x8000000), new PositioningStore.Config(0x8000000, true));
        }

        public Config(int maxMessageLength, int writeRequestCacheSize, long flushIntervalMs, long writeTimeoutMs, long maxDirtySize, long printMetricIntervalMs, PositioningStore.Config storeConfig, PositioningStore.Config indexStoreConfig) {
            this.maxMessageLength = maxMessageLength;
            this.writeRequestCacheSize = writeRequestCacheSize;
            this.flushIntervalMs = flushIntervalMs;
            this.writeTimeoutMs = writeTimeoutMs;
            this.maxDirtySize = maxDirtySize;
            this.printMetricIntervalMs = printMetricIntervalMs;
            this.storeConfig = storeConfig;
            this.indexStoreConfig = indexStoreConfig;
        }
    }

    private static class WriteCommand {
        private final QosLevel qosLevel;
        private final EventListener<WriteResult> eventListener;
        private final ByteBuffer[] messages;

        private WriteCommand(QosLevel qosLevel, EventListener<WriteResult> eventListener, ByteBuffer[] messages) {
            this.qosLevel = qosLevel;
            this.eventListener = eventListener;
            this.messages = messages;
        }
    }

    private static class Partition {
        private final PositioningStore<IndexItem> store;

        private Partition(PositioningStore<IndexItem> store) {
            this.store = store;
        }

        private void rollbackTo(long messagePosition) throws IOException {
            long indexPosition;
            for (indexPosition = this.store.right() - 12L; indexPosition >= this.store.left(); indexPosition -= 12L) {
                IndexItem indexItem = this.store.read(indexPosition);
                if (null != indexItem) {
                    if (indexItem.getOffset() + (long)indexItem.getLength() > messagePosition) continue;
                    break;
                }
                throw new RollBackException(String.format("Failed to rollback store %s to position %d, batchRead index failed!", this.store.base().getAbsolutePath(), messagePosition));
            }
            this.store.setRight(indexPosition <= this.store.left() ? 0L : indexPosition + 12L);
        }
    }

    private static class Callback {
        long position;
        EventListener<WriteResult> listener;
        long[] indices;
        long timestamp;
        QosLevel qosLevel;

        Callback(QosLevel qosLevel, EventListener<WriteResult> listener, long[] indices) {
            this.listener = listener;
            this.indices = indices;
            this.qosLevel = qosLevel;
            this.timestamp = SystemClock.now();
        }
    }
}

