/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import java.io.File;
import org.joyqueue.store.StoreInitializeException;

public class PartitionGroupStoreSupport {
    public static void init(File base, short[] partitions) {
        if (!base.exists()) {
            try {
                if (!base.mkdirs()) {
                    throw new StoreInitializeException(String.format("Create directory %s failed!", base.getAbsolutePath()));
                }
                PartitionGroupStoreSupport.configPartitions(base, partitions);
            }
            catch (Throwable t) {
                if (base.exists() && base.exists()) {
                    PartitionGroupStoreSupport.deleteFolder(base);
                }
                throw t;
            }
        } else {
            throw new StoreInitializeException(String.format("Directory %s exists, remove it before init!", base.getAbsolutePath()));
        }
    }

    private static void configPartitions(File base, short[] partitions) {
        File indexBase = new File(base, "index");
        if (indexBase.mkdirs()) {
            if (null != partitions) {
                for (short partition : partitions) {
                    File partitionBase = new File(indexBase, String.valueOf(partition));
                    if (partitionBase.mkdirs()) continue;
                    throw new StoreInitializeException(String.format("Create directory %s failed! ", partitionBase.getAbsolutePath()));
                }
            }
        } else {
            throw new StoreInitializeException(String.format("Create directory %s failed! ", indexBase.getAbsolutePath()));
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    PartitionGroupStoreSupport.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

