/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.PartitionGroupStoreManager;
import org.joyqueue.store.ReadResult;
import org.joyqueue.store.WriteRequest;
import org.joyqueue.store.WriteResult;
import org.joyqueue.store.file.PositioningStore;
import org.joyqueue.toolkit.concurrent.EventFuture;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QosStore
implements PartitionGroupStore {
    private static final Logger logger = LoggerFactory.getLogger(QosStore.class);
    private final PartitionGroupStoreManager store;
    private final QosLevel qosLevel;

    public QosStore(PartitionGroupStoreManager store, QosLevel qosLevel) {
        this.store = store;
        this.qosLevel = qosLevel;
    }

    public String getTopic() {
        return this.store.getTopic();
    }

    public int getPartitionGroup() {
        return this.store.getPartitionGroup();
    }

    public Short[] listPartitions() {
        return this.store.listPartitions();
    }

    public long getLeftIndex(short partition) {
        return this.store.getLeftIndex(partition);
    }

    public long getRightIndex(short partition) {
        return this.store.getRightIndex(partition);
    }

    public long getTotalPhysicalStorageSize() {
        return this.store.messageStore().physicalSize() + this.store.meetPositioningStores().stream().mapToLong(PositioningStore::physicalSize).sum();
    }

    public long clean(long time, Map<Short, Long> partitionAckMap, boolean keepUnconsumed) throws IOException {
        return this.store.clean(time, partitionAckMap, keepUnconsumed);
    }

    public long getIndex(short partition, long timestamp) {
        return this.store.getIndex(partition, timestamp);
    }

    public Future<WriteResult> asyncWrite(WriteRequest ... writeRequests) {
        EventFuture future = new EventFuture();
        this.asyncWrite((EventListener<WriteResult>)future, writeRequests);
        return future;
    }

    public void asyncWrite(EventListener<WriteResult> eventListener, WriteRequest ... writeRequests) {
        this.store.asyncWrite(this.qosLevel, eventListener, writeRequests);
    }

    public ReadResult read(short partition, long index, int count, long maxSize) throws IOException {
        return this.store.read(partition, index, count, maxSize);
    }
}

