/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.monitor.BufferPoolMonitorInfo;
import org.joyqueue.store.NoSuchPartitionGroupException;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.PartitionGroupStoreManager;
import org.joyqueue.store.PartitionGroupStoreSupport;
import org.joyqueue.store.StoreConfig;
import org.joyqueue.store.StoreInitializeException;
import org.joyqueue.store.StoreLock;
import org.joyqueue.store.StoreManagement;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreNode;
import org.joyqueue.store.StoreNodes;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.event.StoreEvent;
import org.joyqueue.store.file.PositioningStore;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.store.transaction.TransactionStore;
import org.joyqueue.store.transaction.TransactionStoreManager;
import org.joyqueue.store.utils.PreloadBufferPool;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Store
extends Service
implements StoreService,
Closeable,
PropertySupplierAware {
    private static final Logger logger = LoggerFactory.getLogger(Store.class);
    private static final int SCHEDULE_EXECUTOR_THREADS = 16;
    private static final String TOPICS_DIR = "topics";
    private static final String TX_DIR = "tx";
    private static final String DEL_PREFIX = ".d.";
    private final Map<String, PartitionGroupStoreManager> storeMap = new HashMap<String, PartitionGroupStoreManager>();
    private final Map<String, TransactionStoreManager> txStoreMap = new HashMap<String, TransactionStoreManager>();
    private StoreConfig config;
    private PreloadBufferPool bufferPool;
    private File base;
    private PropertySupplier propertySupplier;
    private StoreLock storeLock;

    public Store() {
    }

    public Store(StoreConfig config) {
        this.config = config;
    }

    protected void validate() throws Exception {
        super.validate();
        if (this.config == null) {
            this.config = new StoreConfig(this.propertySupplier);
        }
        if (this.base == null) {
            this.base = new File(this.config.getPath());
        }
        this.checkOrCreateBase();
        if (this.storeLock == null) {
            this.storeLock = new StoreLock(new File(this.base, "lock"));
            this.storeLock.lock();
        }
        if (this.bufferPool == null) {
            System.setProperty("PreloadBufferPool.PrintMetricIntervalMs", String.valueOf(this.config.getPrintMetricIntervalMs()));
            this.bufferPool = PreloadBufferPool.getInstance();
        }
        this.bufferPool.addPreLoad(this.config.getIndexFileSize(), this.config.getPreLoadBufferCoreCount(), this.config.getPreLoadBufferMaxCount());
        this.bufferPool.addPreLoad(this.config.getMessageFileSize(), this.config.getPreLoadBufferCoreCount(), this.config.getPreLoadBufferMaxCount());
    }

    protected void doStart() throws Exception {
        super.doStart();
        logger.info("Starting store {}...", (Object)this.base.getPath());
        for (PartitionGroupStoreManager manger : this.storeMap.values()) {
            if (manger.isStarted()) continue;
            manger.start();
        }
        this.started.set(true);
        logger.info("Store started.");
    }

    protected void doStop() {
        super.doStop();
        logger.info("Stopping store {}...", (Object)this.base.getPath());
        this.storeMap.values().forEach(p -> {
            p.disable();
            p.stop();
        });
        this.storeLock.unlock();
        logger.info("Store {} stopped.", (Object)this.base.getPath());
    }

    public void checkOrCreateBase() {
        if (!this.base.exists()) {
            if (!this.base.mkdirs()) {
                throw new StoreInitializeException(String.format("Failed to create directory: %s.", this.base.getAbsolutePath()));
            }
        } else if (!this.base.isDirectory()) {
            throw new StoreInitializeException(String.format("Failed to create directory: %s! Cause: file exists!", this.base.getAbsolutePath()));
        }
    }

    public boolean physicalDelete() {
        if (this.started.get()) {
            logger.info("Stop me fist!");
            return false;
        }
        logger.info("PHYSICAL DELETE {}...", (Object)this.base.getAbsolutePath());
        this.deleteFolder(this.base);
        return true;
    }

    public boolean partitionGroupExists(String topic, int partitionGroup) {
        return new File(this.base, this.getPartitionGroupRelPath(topic, partitionGroup)).isDirectory();
    }

    public boolean topicExists(String topic) {
        return new File(this.base, this.getTopicRelPath(topic)).isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStore getTransactionStore(String topic) {
        Map<String, TransactionStoreManager> map = this.txStoreMap;
        synchronized (map) {
            if (this.txStoreMap.containsKey(topic)) {
                return this.txStoreMap.get(topic);
            }
            File txBase = new File(new File(this.base, this.getTopicRelPath(topic)), TX_DIR);
            if (this.topicExists(topic) && (txBase.isDirectory() || txBase.mkdirs())) {
                TransactionStoreManager transactionStore = new TransactionStoreManager(txBase, this.getMessageStoreConfig(this.config), this.bufferPool);
                this.txStoreMap.put(topic, transactionStore);
                return transactionStore;
            }
            return null;
        }
    }

    public List<TransactionStore> getAllTransactionStores() {
        return this.storeMap.keySet().stream().map(key -> key.replaceAll("^(.*)/\\d+$", "$1")).distinct().map(topic -> {
            Map<String, TransactionStoreManager> map = this.txStoreMap;
            synchronized (map) {
                if (this.txStoreMap.containsKey(topic)) {
                    return this.txStoreMap.get(topic);
                }
                File txBase = new File(new File(this.base, this.getTopicRelPath((String)topic)), TX_DIR);
                if (txBase.isDirectory()) {
                    TransactionStoreManager transactionStore = new TransactionStoreManager(txBase, this.getMessageStoreConfig(this.config), this.bufferPool);
                    this.txStoreMap.put((String)topic, transactionStore);
                    return transactionStore;
                }
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removePartitionGroup(String topic, int partitionGroup) {
        File topicBase;
        File[] files;
        File groupBase;
        PartitionGroupStoreManager partitionGroupStoreManger = this.storeMap.remove(topic + "/" + partitionGroup);
        if (null != partitionGroupStoreManger) {
            partitionGroupStoreManger.stop();
            partitionGroupStoreManger.close();
        }
        if ((groupBase = new File(this.base, this.getPartitionGroupRelPath(topic, partitionGroup))).exists()) {
            this.delete(groupBase);
        }
        if (null == (files = (topicBase = new File(this.base, this.getTopicRelPath(topic))).listFiles((dir, name) -> name.matches("\\d+"))) || files.length == 0) {
            Map<String, TransactionStoreManager> map = this.txStoreMap;
            synchronized (map) {
                TransactionStoreManager transactionStore;
                if (this.txStoreMap.containsKey(topic) && null != (transactionStore = this.txStoreMap.remove(topic))) {
                    transactionStore.close();
                }
            }
            this.delete(topicBase);
        }
    }

    public synchronized void restorePartitionGroup(String topic, int partitionGroup) throws Exception {
        PartitionGroupStoreManager partitionGroupStoreManger = this.partitionGroupStore(topic, partitionGroup);
        if (null == partitionGroupStoreManger) {
            File groupBase = new File(this.base, this.getPartitionGroupRelPath(topic, partitionGroup));
            partitionGroupStoreManger = new PartitionGroupStoreManager(topic, partitionGroup, groupBase, this.getPartitionGroupConfig(this.config), this.bufferPool);
            partitionGroupStoreManger.recover();
            if (this.isStarted()) {
                partitionGroupStoreManger.start();
            }
            this.storeMap.put(topic + "/" + partitionGroup, partitionGroupStoreManger);
        }
    }

    public synchronized void createPartitionGroup(String topic, int partitionGroup, short[] partitions) throws Exception {
        if (!this.storeMap.containsKey(topic + "/" + partitionGroup)) {
            File groupBase = new File(this.base, this.getPartitionGroupRelPath(topic, partitionGroup));
            if (groupBase.exists()) {
                this.delete(groupBase);
            }
            PartitionGroupStoreSupport.init(groupBase, partitions);
            this.restorePartitionGroup(topic, partitionGroup);
        }
    }

    private PartitionGroupStoreManager.Config getPartitionGroupConfig(StoreConfig config) {
        PositioningStore.Config messageConfig = this.getMessageStoreConfig(config);
        PositioningStore.Config indexConfig = this.getIndexStoreConfig(config);
        return new PartitionGroupStoreManager.Config(config.getMaxMessageLength(), config.getWriteRequestCacheSize(), config.getFlushIntervalMs(), config.getWriteTimeoutMs(), config.getMaxDirtySize(), config.getPrintMetricIntervalMs(), messageConfig, indexConfig);
    }

    private PositioningStore.Config getIndexStoreConfig(StoreConfig config) {
        return new PositioningStore.Config(config.getIndexFileSize(), config.getFileHeaderSize(), config.getDiskFullRatio(), 12, config.isIndexFileLoadOnRead());
    }

    private PositioningStore.Config getMessageStoreConfig(StoreConfig config) {
        return new PositioningStore.Config(config.getMessageFileSize(), config.getFileHeaderSize(), config.getDiskFullRatio(), config.getMaxMessageLength(), config.isMessageFileLoadOnRead());
    }

    private boolean delete(File file) {
        File renamed = new File(file.getParent(), DEL_PREFIX + SystemClock.now() + "." + file.getName());
        return file.renameTo(renamed);
    }

    public PartitionGroupStore getStore(String topic, int partitionGroup, QosLevel writeQosLevel) {
        PartitionGroupStoreManager partitionGroupStoreManager = this.partitionGroupStore(topic, partitionGroup);
        return partitionGroupStoreManager == null ? null : partitionGroupStoreManager.getQosStore(writeQosLevel);
    }

    public PartitionGroupStore getStore(String topic, int partitionGroup) {
        return this.getStore(topic, partitionGroup, QosLevel.REPLICATION);
    }

    public List<PartitionGroupStore> getStore(String topic) {
        return this.partitionGroupStores(topic).stream().map(p -> p.getQosStore(QosLevel.REPLICATION)).collect(Collectors.toList());
    }

    public void rePartition(String topic, int partitionGroup, Short[] partitions) throws IOException {
        PartitionGroupStoreManager partitionGroupStoreManger = this.partitionGroupStore(topic, partitionGroup);
        if (null == partitionGroupStoreManger) {
            throw new NoSuchPartitionGroupException();
        }
        partitionGroupStoreManger.rePartition(partitions);
    }

    public ReplicableStore getReplicableStore(String topic, int partitionGroup) {
        return this.partitionGroupStore(topic, partitionGroup);
    }

    public StoreManagementService getManageService() {
        return new StoreManagement(128, 128, this.config.getMaxMessageLength(), this.bufferPool, this);
    }

    public BufferPoolMonitorInfo monitorInfo() {
        return this.bufferPool.monitorInfo();
    }

    public StoreNodes getNodes(String topic, int partitionGroup) {
        PartitionGroupStoreManager partitionGroupStoreManger = this.partitionGroupStore(topic, partitionGroup);
        if (partitionGroupStoreManger == null) {
            return null;
        }
        return new StoreNodes(new StoreNode(0, true, true));
    }

    public void addListener(EventListener<StoreEvent> listener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(EventListener<StoreEvent> listener) {
        throw new UnsupportedOperationException();
    }

    private String getPartitionGroupRelPath(String topic, int partitionGroup) {
        return TOPICS_DIR + File.separator + topic.replace('/', '@') + File.separator + partitionGroup;
    }

    private String getTopicRelPath(String topic) {
        return TOPICS_DIR + File.separator + topic;
    }

    File base() {
        return this.base;
    }

    @Override
    public void close() throws IOException {
        for (PartitionGroupStoreManager p : this.storeMap.values()) {
            p.close();
        }
    }

    private void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.deleteFolder(f);
                    continue;
                }
                if (f.delete()) continue;
                logger.warn("Delete failed: {}", (Object)f.getAbsolutePath());
            }
        }
        if (!folder.delete()) {
            logger.warn("Delete failed: {}", (Object)folder.getAbsolutePath());
        }
    }

    List<String> topics() {
        return this.storeMap.keySet().stream().map(k -> k.split("/")[0]).distinct().collect(Collectors.toList());
    }

    List<String> partitionGroups() {
        return new ArrayList<String>(this.storeMap.keySet());
    }

    List<Integer> partitionGroups(String topic) {
        return this.storeMap.keySet().stream().filter(k -> k.matches("^" + topic + "/\\d+$")).map(k -> k.substring(topic.length() + 1)).map(Integer::parseInt).collect(Collectors.toList());
    }

    PartitionGroupStoreManager partitionGroupStore(String topic, int partitionGroup) {
        return this.storeMap.get(topic + "/" + partitionGroup);
    }

    List<PartitionGroupStoreManager> partitionGroupStores(String topic) {
        return this.partitionGroups(topic).stream().map(id -> this.storeMap.get(topic + "/" + id)).collect(Collectors.toList());
    }

    public void setSupplier(PropertySupplier supplier) {
        this.propertySupplier = supplier;
        if (this.config == null) {
            this.config = new StoreConfig(supplier);
        }
    }
}

